/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import java.text.DecimalFormat;
import javax.baja.agent.BIAgent;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BNumberToStatusString
extends BConverter
implements BIAgent {
    public static final Property format = BNumberToStatusString.newProperty((int)0, (String)"", (BFacets)BFacets.NULL);
    public static final Type TYPE = Sys.loadType(BNumberToStatusString.class);

    public final String getFormat() {
        return this.getString(format);
    }

    public final void setFormat(String format) {
        this.setString(BNumberToStatusString.format, format, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusString statusString = (BStatusString)to;
        if (from instanceof BFloat && from == BFloat.NaN || from instanceof BDouble && from == BDouble.NaN) {
            statusString.setStatus(64);
            return statusString;
        }
        if (this.getFormat().length() == 0) {
            statusString.setValue(from.toString(cx));
            statusString.setStatus(BStatus.ok);
        } else {
            try {
                DecimalFormat decFormat = new DecimalFormat(this.getFormat());
                statusString.setValue(decFormat.format(((BNumber)from).getDouble()));
            }
            catch (IllegalArgumentException iae) {
                statusString.setStatus(BStatus.fault);
            }
        }
        return statusString;
    }
}

