/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;

public final class BEnumToSimpleMap
extends BSimple {
    public static final BEnumToSimpleMap NULL;
    public static final BEnumToSimpleMap DEFAULT;
    public static final Type TYPE;
    private Item[] items;
    BSimple def;
    private String string;

    public static BEnumToSimpleMap make(BSimple def) {
        return BEnumToSimpleMap.make(new int[0][], new BSimple[0], def);
    }

    public static BEnumToSimpleMap make(int[][] ordinals, BSimple[] values, BSimple def) {
        if (ordinals.length != values.length) {
            throw new IllegalArgumentException();
        }
        if (ordinals.length == 0 && def == null) {
            return NULL;
        }
        Item[] items = new Item[ordinals.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new Item();
            items[i].ordinals = (int[])ordinals[i].clone();
            items[i].value = values[i];
        }
        return new BEnumToSimpleMap(items, def);
    }

    public static BEnumToSimpleMap make(String s) {
        if (s.equals("null")) {
            return NULL;
        }
        try {
            int space = s.indexOf(32);
            Type type = Sys.getType((String)s.substring(0, space));
            BSimple proto = (BSimple)type.getInstance();
            BSimple def = null;
            String[] tokens = BEnumToSimpleMap.tokenizeItems(s.substring(space + 1));
            Array items = new Array(Item.class);
            for (String tok : tokens) {
                int eq = tok.indexOf(61);
                String key = tok.substring(0, eq);
                String valueStr = tok.substring(eq + 1);
                BSimple value = (BSimple)proto.decodeFromString(valueStr);
                if (key.equals("default")) {
                    def = value;
                    continue;
                }
                Item item = new Item();
                item.ordinals = BEnumToSimpleMap.tokenizeOrdinals(key);
                item.value = value;
                items.add((Object)item);
            }
            return new BEnumToSimpleMap((Item[])items.trim(), def);
        }
        catch (TypeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(s);
        }
    }

    static String[] tokenizeItems(String s) {
        int len = s.length();
        String[] temp = new String[len / 2];
        int n = 0;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ';') {
                char x;
                char c2 = x = i + 1 < len ? s.charAt(i + 1) : (char)'\u0000';
                if (x != ';') {
                    temp[n++] = buf.toString();
                    buf.setLength(0);
                    continue;
                }
                buf.append(';');
                ++i;
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            temp[n++] = buf.toString();
        }
        String[] result = new String[n];
        System.arraycopy(temp, 0, result, 0, n);
        return result;
    }

    static int[] tokenizeOrdinals(String s) {
        int[] temp = new int[s.length()];
        int n = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            temp[n++] = Integer.parseInt(st.nextToken());
        }
        int[] result = new int[n];
        System.arraycopy(temp, 0, result, 0, n);
        return result;
    }

    private BEnumToSimpleMap(Item[] items, BSimple def) {
        this.items = items;
        this.def = def;
    }

    public BSimple get(int ordinal) {
        for (Item item : this.items) {
            for (int j = 0; j < item.ordinals.length; ++j) {
                if (ordinal != item.ordinals[j]) continue;
                return item.value;
            }
        }
        return this.def;
    }

    public Type getValueType() {
        if (this.def != null) {
            return this.def.getType();
        }
        return this.items[0].value.getType();
    }

    public BSimple getDefault() {
        return this.def;
    }

    public int[][] getOrdinals() {
        int[][] arr = new int[this.items.length][];
        for (int i = 0; i < this.items.length; ++i) {
            int n = this.items[i].ordinals.length;
            arr[i] = new int[n];
            System.arraycopy(this.items[i].ordinals, 0, arr[i], 0, n);
        }
        return arr;
    }

    public BSimple[] getValues() {
        BSimple[] arr = new BSimple[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            arr[i] = this.items[i].value;
        }
        return arr;
    }

    public boolean isNull() {
        return this.items.length == 0;
    }

    public int hashCode() {
        int hash = this.def != null ? this.def.hashCode() : 0;
        for (Item item : this.items) {
            hash = 31 * hash + item.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BEnumToSimpleMap) {
            BEnumToSimpleMap x = (BEnumToSimpleMap)((Object)obj);
            if (this.items.length != x.items.length) {
                return false;
            }
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i].equals(x.items[i])) continue;
                return false;
            }
            if (this.def == null) {
                return x.def == null;
            }
            if (x.def == null) {
                return false;
            }
            return this.def.equals((Object)x.def);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BEnumToSimpleMap.make(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.items.length == 0 && this.def == null) {
                this.string = "null";
                return "null";
            }
            StringBuilder s = new StringBuilder();
            s.append(this.getValueType()).append(' ');
            for (Item item : this.items) {
                for (int j = 0; j < item.ordinals.length; ++j) {
                    if (j > 0) {
                        s.append(',');
                    }
                    s.append(item.ordinals[j]);
                }
                s.append('=');
                String value = item.value.encodeToString();
                value = TextUtil.replace((String)value, (String)";", (String)";;");
                s.append(value).append(';');
            }
            if (this.def != null) {
                String defstr = this.def.encodeToString();
                defstr = TextUtil.replace((String)defstr, (String)";", (String)";;");
                s.append("default=").append(defstr).append(';');
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BEnumToSimpleMap.make(s);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 205: {
                this.setBaseOrd(a);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void setBaseOrd(Object baseOrd) {
        if (this.def != null) {
            this.def.fw(205, baseOrd, null, null, null);
        }
        for (Item item : this.items) {
            item.value.fw(205, baseOrd, null, null, null);
        }
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BEnumToSimpleMap(new Item[0], null);
        TYPE = Sys.loadType(BEnumToSimpleMap.class);
    }

    static class Item {
        int[] ordinals;
        BSimple value;

        Item() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Item)) {
                return false;
            }
            Item x = (Item)obj;
            if (this.ordinals.length != x.ordinals.length) {
                return false;
            }
            for (int i = 0; i < this.ordinals.length; ++i) {
                if (this.ordinals[i] == x.ordinals[i]) continue;
                return false;
            }
            return this.value.equals((Object)x.value);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.ordinals), this.value);
        }
    }
}

