/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BBooleanToDynamicEnum
extends BConverter
implements BIAgent {
    public static final Property trueOrdinal = BBooleanToDynamicEnum.newProperty((int)0, (int)BBoolean.TRUE.getOrdinal(), (BFacets)BFacets.NULL);
    public static final Property falseOrdinal = BBooleanToDynamicEnum.newProperty((int)0, (int)BBoolean.FALSE.getOrdinal(), (BFacets)BFacets.NULL);
    public static final Type TYPE = Sys.loadType(BBooleanToDynamicEnum.class);

    public final int getTrueOrdinal() {
        return this.getInt(trueOrdinal);
    }

    public final void setTrueOrdinal(int trueValue) {
        this.setInt(trueOrdinal, trueValue, null);
    }

    public final int getFalseOrdinal() {
        return this.getInt(falseOrdinal);
    }

    public final void setFalseOrdinal(int falseValue) {
        this.setInt(falseOrdinal, falseValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        int ordinal = ((BBoolean)from).getBoolean() ? this.getTrueOrdinal() : this.getFalseOrdinal();
        return BDynamicEnum.make((int)ordinal, (BEnumRange)((BDynamicEnum)to).getRange());
    }
}

