/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;

public class ParserCreationException
extends Exception {
    public static final int INTERNAL_ERROR = 0;
    public static final int INVALID_PARSER_ERROR = 1;
    public static final int INVALID_TOKEN_ERROR = 2;
    public static final int INVALID_PRODUCTION_ERROR = 3;
    public static final int INFINITE_LOOP_ERROR = 4;
    public static final int INHERENT_AMBIGUITY_ERROR = 5;
    private int type;
    private String name;
    private String info;
    private ArrayList details;

    public ParserCreationException(int type, String info) {
        this(type, null, info);
    }

    public ParserCreationException(int type, String name, String info) {
        this(type, name, info, null);
    }

    public ParserCreationException(int type, String name, String info, ArrayList details) {
        this.type = type;
        this.name = name;
        this.info = info;
        this.details = details;
    }

    public int getErrorType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public String getDetails() {
        StringBuffer buffer = new StringBuffer();
        if (this.details == null) {
            return null;
        }
        for (int i = 0; i < this.details.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
                if (i + 1 == this.details.size()) {
                    buffer.append("and ");
                }
            }
            buffer.append(this.details.get(i));
        }
        return buffer.toString();
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                buffer.append("parser is invalid, as ");
                buffer.append(this.info);
                break;
            }
            case 2: {
                buffer.append("token '");
                buffer.append(this.name);
                buffer.append("' is invalid, as ");
                buffer.append(this.info);
                break;
            }
            case 3: {
                buffer.append("production '");
                buffer.append(this.name);
                buffer.append("' is invalid, as ");
                buffer.append(this.info);
                break;
            }
            case 4: {
                buffer.append("infinite loop found in production pattern '");
                buffer.append(this.name);
                buffer.append("'");
                break;
            }
            case 5: {
                buffer.append("inherent ambiguity in production '");
                buffer.append(this.name);
                buffer.append("'");
                if (this.info != null) {
                    buffer.append(" ");
                    buffer.append(this.info);
                }
                if (this.details == null) break;
                buffer.append(" starting with ");
                if (this.details.size() > 1) {
                    buffer.append("tokens ");
                } else {
                    buffer.append("token ");
                }
                buffer.append(this.getDetails());
                break;
            }
            default: {
                buffer.append("internal error");
            }
        }
        return buffer.toString();
    }
}

