/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.BSnmpDeviceFolder;
import com.tridium.nSnmp.BSnmpNetwork;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BSnmpDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BSnmpDeviceManager.class);
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final Lexicon lexicon = Lexicon.make(BSnmpDeviceManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(7);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BSnmpDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);
    MgrColumn colPollFreq = new SnmpProp(BSnmpDevice.pollFrequency, 3);
    MgrColumn colVersion = new SnmpProp(BSnmpDevice.snmpVersion, 3);
    MgrColumn colAddress = new SnmpProp(BSnmpDevice.ipAddress, 1);
    MgrColumn colPort = new SnmpProp(BSnmpDevice.port, 1);
    MgrColumn colCommunity = new SnmpProp(BSnmpDevice.community, 3);
    MgrColumn colMaxVarBinds = new SnmpProp(BSnmpDevice.maxVariableBindingsPerRequest, 3);
    MgrColumn colRetries = new SnmpProp(BSnmpDevice.retryCount, 3);
    MgrColumn colTimeout = new SnmpProp(BSnmpDevice.responseTimeout, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colStatus, this.colEnabled, this.colHealth, this.colPollFreq, this.colVersion, this.colAddress, this.colPort, this.colCommunity, this.colMaxVarBinds, this.colRetries, this.colTimeout};

    public Type getType() {
        return TYPE;
    }

    public BSnmpNetwork getNetwork() {
        if (this.getCurrentValue() instanceof BSnmpNetwork) {
            return (BSnmpNetwork)this.getCurrentValue();
        }
        if (this.getCurrentValue() instanceof BSnmpDeviceFolder) {
            return (BSnmpNetwork)((BSnmpDeviceFolder)this.getCurrentValue()).getNetwork();
        }
        return null;
    }

    protected MgrModel makeModel() {
        return new SnmpModel(this);
    }

    protected MgrController makeController() {
        return new SnmpController(this);
    }

    public static class SnmpProp
    extends MgrColumn.Prop {
        public SnmpProp(String name, Property prop, int flags) {
            super(name, prop, flags);
        }

        public SnmpProp(Property prop, int flags) {
            super(prop, flags);
        }

        public SnmpProp(Property prop) {
            super(prop);
        }

        public Object get(Object row) {
            if (row instanceof BSnmpAgent) {
                return BString.DEFAULT;
            }
            return super.get(row);
        }

        public BValue load(MgrEditRow row) {
            if (row.getTarget() instanceof BSnmpAgent) {
                return BString.DEFAULT;
            }
            return super.load(row);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (row.getTarget() instanceof BSnmpAgent) {
                return;
            }
            super.save(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            for (int i = 0; i < rows.length; ++i) {
                if (!(rows[i].getTarget() instanceof BSnmpAgent)) continue;
                return null;
            }
            return super.toEditor(rows, colIndex, currentEditor);
        }
    }

    public class SnmpController
    extends DeviceController {
        public SnmpController(BDeviceManager manager) {
            super(manager);
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrModel model = this.getManager().getModel();
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem((Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            String title = this.newCommand.getLabel();
            int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
            if (r == 2) {
                return null;
            }
            MgrTypeInfo type = (MgrTypeInfo)typeField.getSelectedItem();
            BComponent child = model.newInstance(type);
            int count = Integer.parseInt(countField.getText());
            if (child != null && child instanceof BSnmpAgent) {
                Object[] children = BSnmpDeviceManager.this.getNetwork().getChildren(BSnmpAgent.class);
                if (children != null && children.length > 0) {
                    BDialog.error((BWidget)this.getManager(), (Object)lexicon.getText("devManager.error.agentAlreadyExists"));
                    return null;
                }
                count = 1;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                MgrEditRow row = new MgrEditRow(model.newInstance(type), null, types);
                edit.addRow(row);
            }
            return edit;
        }
    }

    public class SnmpModel
    extends DeviceModel {
        public SnmpModel(BSnmpDeviceManager manager) {
            super((BDeviceManager)manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] retVal = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BSnmpDevice.TYPE)};
            return retVal;
        }

        public MgrColumn[] makeColumns() {
            return BSnmpDeviceManager.this.cols;
        }
    }
}

