/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.ui.BMibListDialog;
import com.tridium.nSnmp.ui.BSnmpAutoMibOptions;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;

public class BMibPathDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BMibPathDialog.class);
    static Lexicon lex = Lexicon.make(BMibPathDialog.class);
    BMibListDialog listDiag;
    BSnmpAutoMibOptions options = BSnmpAutoMibOptions.getDefault();

    public Type getType() {
        return TYPE;
    }

    public BMibPathDialog() {
    }

    public BMibPathDialog(BAbstractManager manager) {
        super((BWidget)manager, lex.getText("mibPathDialog.title"), true);
        String[] mibDirectories = this.options.getMibDirectories().getArray();
        this.listDiag = new BMibListDialog(mibDirectories);
        Ok ok = new Ok((BWidget)this);
        Cancel cancel = new Cancel((BWidget)this);
        BGridPane okPane = new BGridPane();
        okPane.setColumnAlign(BHalign.fill);
        okPane.setUniformColumnWidth(true);
        okPane.add(null, (BValue)new BButton((Command)ok));
        okPane.add(null, (BValue)new BButton((Command)cancel));
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)new BBorderPane((BWidget)this.listDiag));
        content.setBottom((BWidget)new BBorderPane((BWidget)okPane));
        this.setBoundsCenteredOnOwner();
        this.setContent((BWidget)content);
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        int pw = Math.max((int)this.getPreferredWidth(), 400);
        int ph = Math.max((int)this.getPreferredHeight(), 400);
        pw = Math.min(700, pw);
        ph = Math.min(600, ph);
        this.setPreferredSize(pw, ph);
    }

    class Cancel
    extends Command {
        Cancel(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BMibPathDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            String[] mps = BMibPathDialog.this.listDiag.getMibPaths();
            BMibPathDialog.this.options.getMibDirectories().setArray(mps);
            BMibPathDialog.this.options.save();
            BMibPathDialog.this.close();
            return null;
        }
    }
}

