/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.plugins;

import com.tridium.nSnmp.datatypes.BNetworkManagerConfiguration;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BNetworkManagerConfigurationPlugin
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BNetworkManagerConfigurationPlugin.class);
    private static final UiLexicon lex = UiLexicon.makeUiLexicon(BNetworkManagerConfigurationPlugin.class);
    BGridPane editPane;
    BCheckBox isRouteAlarms = new BCheckBox(lex.getText("managerPlugin.strings.route"));
    BCheckBox isUseDefault = new BCheckBox(lex.getText("managerPlugin.strings.useDefault"));
    RouteAlarmsToggle routeAlarmsToggle = new RouteAlarmsToggle((BWidget)this);
    UseDefaultToggle useDefaultToggle;
    BWbFieldEditor addressEditor;
    BWbFieldEditor portEditor;
    BWbFieldEditor versionEditor;
    BWbFieldEditor communityEditor;

    public Type getType() {
        return TYPE;
    }

    public BNetworkManagerConfigurationPlugin() {
        this.isRouteAlarms.setCommand((Command)this.routeAlarmsToggle, false, false);
        this.useDefaultToggle = new UseDefaultToggle((BWidget)this);
        this.isUseDefault.setCommand((Command)this.useDefaultToggle, false, false);
        this.editPane = new BGridPane(2);
        this.editPane.setHalign(BHalign.left);
        this.setContent((BWidget)this.editPane);
    }

    protected void doLoadValue(BObject raw, Context cx) throws Exception {
        BNetworkManagerConfiguration se = (BNetworkManagerConfiguration)raw;
        BString address = BString.make((String)se.getNetworkManagerIpAddress());
        BInteger port = BInteger.make((int)se.getNetworkManagerTrapsPort());
        BFacets portFacets = se.getSlotFacets((Slot)BNetworkManagerConfiguration.networkManagerTrapsPort);
        BInteger version = BInteger.make((int)se.getNetworkManagerSnmpVersion());
        BFacets versionFacets = se.getSlotFacets((Slot)BNetworkManagerConfiguration.networkManagerSnmpVersion);
        BString community = BString.make((String)se.getNetworkManagerTrapsCommunity());
        if (this.addressEditor == null || this.portEditor == null || this.communityEditor == null || this.versionEditor == null) {
            this.addressEditor = BWbFieldEditor.makeFor((BObject)address);
            this.portEditor = BWbFieldEditor.makeFor((BObject)port);
            this.versionEditor = BWbFieldEditor.makeFor((BObject)version);
            this.communityEditor = BWbFieldEditor.makeFor((BObject)community);
            this.linkTo("lk0", (BComponent)this.addressEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
            this.linkTo("lk1", (BComponent)this.addressEditor, (Slot)BWbFieldEditor.actionPerformed, (Slot)actionPerformed);
            this.linkTo("lk2", (BComponent)this.portEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
            this.linkTo("lk3", (BComponent)this.portEditor, (Slot)BWbFieldEditor.actionPerformed, (Slot)actionPerformed);
            this.linkTo("lk8", (BComponent)this.versionEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
            this.linkTo("lk9", (BComponent)this.versionEditor, (Slot)BWbFieldEditor.actionPerformed, (Slot)actionPerformed);
            this.linkTo("lk4", (BComponent)this.communityEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
            this.linkTo("lk5", (BComponent)this.communityEditor, (Slot)BWbFieldEditor.actionPerformed, (Slot)actionPerformed);
            this.linkTo("lk6", (BComponent)this.isRouteAlarms, (Slot)BCheckBox.selected, (Slot)setModified);
            this.linkTo("lk7", (BComponent)this.isUseDefault, (Slot)BCheckBox.selected, (Slot)setModified);
            this.editPane.add("routeAlarms", (BValue)this.isRouteAlarms);
            this.editPane.add("label1", (BValue)new BLabel(""));
            this.editPane.add("useDefault", (BValue)this.isUseDefault);
            this.editPane.add("label2", (BValue)new BLabel(""));
            this.editPane.add("label3", (BValue)new BLabel(lex.getText("managerPlugin.strings.ipAddress")));
            this.editPane.add("managerAddress", (BValue)this.addressEditor);
            this.editPane.add("label4", (BValue)new BLabel(lex.getText("managerPlugin.strings.port")));
            this.editPane.add("managerPort", (BValue)this.portEditor);
            this.editPane.add("label6", (BValue)new BLabel(lex.getText("managerPlugin.strings.version")));
            this.editPane.add("managerVersion", (BValue)this.versionEditor);
            this.editPane.add("label5", (BValue)new BLabel(lex.getText("managerPlugin.strings.community")));
            this.editPane.add("managerCommunity", (BValue)this.communityEditor);
        }
        this.addressEditor.loadValue((BObject)address, cx);
        this.portEditor.loadValue((BObject)port, (Context)new BasicContext(cx, portFacets));
        this.versionEditor.loadValue((BObject)version, (Context)new BasicContext(cx, versionFacets));
        this.communityEditor.loadValue((BObject)community, cx);
        this.isRouteAlarms.setSelected(se.getRouteAlarmsToNetworkManager());
        this.isUseDefault.setSelected(se.getUseDefaultNetworkManager());
    }

    protected BObject doSaveValue(BObject raw, Context cx) throws Exception {
        BNetworkManagerConfiguration se = (BNetworkManagerConfiguration)raw;
        BValue a = (BValue)this.addressEditor.saveValue(cx);
        BValue p = (BValue)this.portEditor.saveValue(cx);
        BValue v = (BValue)this.versionEditor.saveValue(cx);
        BValue c = (BValue)this.communityEditor.saveValue(cx);
        se.set(BNetworkManagerConfiguration.networkManagerIpAddress, a, cx);
        se.set(BNetworkManagerConfiguration.networkManagerTrapsPort, p, cx);
        se.set(BNetworkManagerConfiguration.networkManagerSnmpVersion, v, cx);
        se.set(BNetworkManagerConfiguration.networkManagerTrapsCommunity, c, cx);
        se.set(BNetworkManagerConfiguration.routeAlarmsToNetworkManager, (BValue)BBoolean.make((boolean)this.isRouteAlarms.isSelected()), cx);
        se.set(BNetworkManagerConfiguration.useDefaultNetworkManager, (BValue)BBoolean.make((boolean)this.isUseDefault.isSelected()), cx);
        return se;
    }

    class UseDefaultToggle
    extends ToggleCommand {
        UseDefaultToggle(BWidget owner) {
            super(owner, "useDefault");
        }

        public void setSelected(boolean s) {
            super.setSelected(s);
            if (BNetworkManagerConfigurationPlugin.this.addressEditor != null) {
                BNetworkManagerConfigurationPlugin.this.addressEditor.setReadonly(s);
            }
            if (BNetworkManagerConfigurationPlugin.this.portEditor != null) {
                BNetworkManagerConfigurationPlugin.this.portEditor.setReadonly(s);
            }
            if (BNetworkManagerConfigurationPlugin.this.versionEditor != null) {
                BNetworkManagerConfigurationPlugin.this.versionEditor.setReadonly(s);
            }
            if (BNetworkManagerConfigurationPlugin.this.communityEditor != null) {
                BNetworkManagerConfigurationPlugin.this.communityEditor.setReadonly(s);
            }
        }
    }

    class RouteAlarmsToggle
    extends ToggleCommand {
        RouteAlarmsToggle(BWidget owner) {
            super(owner, "routeAlarms");
        }

        public void setSelected(boolean s) {
            boolean readonlyEditors;
            super.setSelected(s);
            boolean bl = readonlyEditors = !s || BNetworkManagerConfigurationPlugin.this.isUseDefault.isSelected();
            if (BNetworkManagerConfigurationPlugin.this.addressEditor != null) {
                BNetworkManagerConfigurationPlugin.this.addressEditor.setReadonly(readonlyEditors);
            }
            if (BNetworkManagerConfigurationPlugin.this.portEditor != null) {
                BNetworkManagerConfigurationPlugin.this.portEditor.setReadonly(readonlyEditors);
            }
            if (BNetworkManagerConfigurationPlugin.this.versionEditor != null) {
                BNetworkManagerConfigurationPlugin.this.versionEditor.setReadonly(readonlyEditors);
            }
            if (BNetworkManagerConfigurationPlugin.this.communityEditor != null) {
                BNetworkManagerConfigurationPlugin.this.communityEditor.setReadonly(readonlyEditors);
            }
            if (BNetworkManagerConfigurationPlugin.this.isUseDefault != null) {
                BNetworkManagerConfigurationPlugin.this.isUseDefault.setEnabled(s);
            }
        }
    }
}

