/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.ui.HelpTreeNode;
import com.tridium.help.ui.TocNode;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.tree.TreeModel;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class TocRootNode
extends HelpTreeNode {
    private static BImage icon = BImage.make((String)"module://icons/x16/file.png");
    private String moduleName;
    private String name;

    public TocRootNode(TreeModel model, String moduleName) {
        super(model, BOrd.make((String)("local:|module://" + moduleName + "/doc/index.html")));
        this.moduleName = moduleName;
        this.name = TextUtil.toFriendly((String)moduleName);
    }

    public String getText() {
        return this.name;
    }

    public BImage getIcon() {
        return icon;
    }

    @Override
    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        BufferedInputStream in = HelpSystem.getJarEntryInputStream(this.moduleName, "doc/toc.xml");
        if (in == null) {
            throw new IllegalStateException();
        }
        try {
            XElem rootElem = XParser.make((InputStream)in).parse();
            this.loadNodes(this.moduleName, this, rootElem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private void loadNodes(String moduleName, HelpTreeNode parentNode, XElem parentElm) {
        XElem[] kidElms = parentElm.elems();
        ArrayList<TocNode> kidNodes = new ArrayList<TocNode>();
        for (int i = 0; i < kidElms.length; ++i) {
            try {
                XElem kidElm = kidElms[i];
                String target = kidElm.get("target", null);
                String text = kidElm.get("text", null);
                String image = kidElm.get("image", null);
                BOrd ord = BOrd.NULL;
                if (target != null) {
                    int pos;
                    if (text == null && (pos = (text = (pos = target.lastIndexOf(46)) > -1 ? target.substring(0, pos) : target).lastIndexOf(47)) > -1 && text.length() > pos + 1) {
                        text = text.substring(pos + 1);
                    }
                    ord = BOrd.make((String)("local:|module://" + moduleName + "/doc/" + target));
                }
                if (text == null) continue;
                BImage icon = null;
                if (image != null) {
                    icon = BImage.make((BOrd)BOrd.make((String)image));
                }
                TocNode kidNode = new TocNode(this, ord, text, icon);
                kidNodes.add(kidNode);
                this.loadNodes(moduleName, kidNode, kidElm);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (parentNode == this) {
            this.kids = kidNodes.toArray(new HelpTreeNode[kidNodes.size()]);
        } else {
            ((TocNode)parentNode).setChildren(kidNodes.toArray(new HelpTreeNode[kidNodes.size()]));
        }
    }
}

