/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.SearchResult;
import com.tridium.help.Searcher;
import com.tridium.help.ui.SearchNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.baja.file.types.text.BHtmlFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;

public class SearchTreeModel
extends TreeModel {
    private SearchNode[] roots = new SearchNode[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String str) {
        this.getTree().enterBusy();
        try {
            SearchResult[] results = Searcher.getInstance().search(str);
            if (results.length == 0) {
                this.roots = new SearchNode[1];
                this.roots[0] = new SearchNode(this, BOrd.NULL, "(none found)", SearchNode.NONE);
            } else {
                this.roots = new SearchNode[results.length];
                for (int i = 0; i < results.length; ++i) {
                    BOrd ord = results[i].ord();
                    String name = ord.toString();
                    BImage icon = SearchNode.NONE;
                    if (name.endsWith("package-index.bajadoc")) {
                        icon = SearchNode.BAJADOC;
                        int n = (name = name.substring("module://".length())).indexOf("/doc/");
                        if (n != -1) {
                            name = name.substring(n + "/doc/".length());
                        }
                        if ((n = name.lastIndexOf(47)) != -1) {
                            name = name.substring(0, n);
                        }
                        name = name.replace('/', '.') + " Package";
                    } else if (name.endsWith("module-index.bajadoc")) {
                        icon = SearchNode.BAJADOC;
                        int n = (name = name.substring("module://".length())).indexOf(47);
                        if (n != -1) {
                            name = name.substring(0, n);
                        }
                        name = TextUtil.capitalize((String)name) + " Module";
                    } else if (name.endsWith(".bajadoc")) {
                        icon = SearchNode.BAJADOC;
                        int n = (name = name.substring(0, name.length() - ".bajadoc".length())).lastIndexOf(47);
                        if (n != -1) {
                            name = name.substring(n + 1);
                        }
                    } else {
                        String title = null;
                        if (name.endsWith(".html")) {
                            icon = SearchNode.HTML;
                            title = SearchTreeModel.htmlTitle(ord);
                        } else if (name.endsWith(".java")) {
                            icon = SearchNode.JAVA;
                        }
                        if (title == null) {
                            int n = name.lastIndexOf(47);
                            if (n != -1) {
                                name = name.substring(n + 1);
                            }
                        } else {
                            name = title;
                        }
                    }
                    this.roots[i] = new SearchNode(this, ord, name, icon);
                }
            }
            this.getTree().relayout();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.getTree().exitBusy();
        }
    }

    private static String htmlTitle(BOrd ord) {
        BObject obj = ord.get();
        if (!(obj instanceof BHtmlFile)) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(((BHtmlFile)obj).getInputStream()));
            String str = reader.readLine();
            while (str != null) {
                String low = TextUtil.toLowerCase((String)str);
                int a = low.indexOf("<title>");
                if (a != -1) {
                    int b = low.indexOf("</title>");
                    if (b != -1 && a < b) {
                        return str.substring(a + "<title>".length(), b).trim();
                    }
                    return null;
                }
                str = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public int getRootCount() {
        return this.roots.length;
    }

    public TreeNode getRoot(int index) {
        return this.roots[index];
    }
}

