/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.ui.DocClassNode;
import com.tridium.help.ui.DocGroupingNode;
import com.tridium.help.ui.DocPackageNode;
import com.tridium.help.ui.DocTreeModel;
import com.tridium.help.ui.HelpTreeNode;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;

public class DocModuleNode
extends HelpTreeNode {
    private static final BImage icon = BImage.make((BIcon)ModuleDoc.ICON);
    private static final BImage classIcon = BImage.make((BIcon)ClassDoc.defaultIcon);
    private final String apiModulePart;
    private final String docModule;

    public DocModuleNode(DocTreeModel model, String docModule, String apiModulePart) {
        super(model);
        this.docModule = docModule;
        this.apiModulePart = apiModulePart;
        BOrd ord = BOrd.make((String)String.format("local:|module://%s/doc/%s/module-index.bajadoc", docModule, apiModulePart));
        this.setContentOrd(ord);
    }

    public String getText() {
        return this.apiModulePart;
    }

    public BImage getIcon() {
        return icon;
    }

    @Override
    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        this.kids = new HelpTreeNode[0];
        try {
            BufferedInputStream in = HelpSystem.getJarEntryInputStream(this.docModule, "doc/" + this.apiModulePart + "/module-index.bajadoc");
            if (in == null) {
                throw new IllegalStateException();
            }
            BajadocParser parser = new BajadocParser();
            ModuleDoc moduleDoc = (ModuleDoc)parser.parse(in, this.docModule);
            ArrayList<HelpTreeNode> kidList = new ArrayList<HelpTreeNode>();
            this.addPackages(moduleDoc.packagesSorted(), kidList);
            this.addClasses("Types", moduleDoc.typesSorted(), kidList);
            this.kids = new HelpTreeNode[kidList.size()];
            for (int i = 0; i < kidList.size(); ++i) {
                this.kids[i] = kidList.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private void addPackages(PackageDoc[] packages, ArrayList<HelpTreeNode> kidList) {
        if (packages != null && packages.length > 0) {
            DocGroupingNode groupNode = new DocGroupingNode(this, this.getContentOrd(), "Packages");
            HelpTreeNode[] grandkids = new HelpTreeNode[packages.length];
            for (int i = 0; i < packages.length; ++i) {
                String packageName = packages[i].name();
                grandkids[i] = new DocPackageNode(groupNode, this.getPackageOrd(packageName), this.docModule, this.apiModulePart, packageName);
            }
            groupNode.setChildren(grandkids);
            kidList.add(groupNode);
        }
    }

    private BOrd getPackageOrd(String packageName) {
        String packagePath = packageName.replace('.', '/');
        return BOrd.make((String)String.format("local:|module://%s/doc/%s/%s/package-index.bajadoc", this.docModule, this.apiModulePart, packagePath));
    }

    private void addClasses(String parentName, ClassSummary[] classDocs, ArrayList<HelpTreeNode> kidList) {
        if (classDocs != null && classDocs.length > 0) {
            DocGroupingNode groupNode = new DocGroupingNode(this, this.getContentOrd(), parentName);
            HelpTreeNode[] grandkids = new HelpTreeNode[classDocs.length];
            for (int i = 0; i < classDocs.length; ++i) {
                ClassSummary classInfo = classDocs[i];
                grandkids[i] = new DocClassNode(groupNode, DocModuleNode.getClassOrd(this.docModule, this.apiModulePart, classInfo), DocModuleNode.getClassName(classInfo), classIcon);
            }
            groupNode.setChildren(grandkids);
            kidList.add(groupNode);
        }
    }

    static BOrd getClassOrd(String docModule, String apiModulePart, ClassSummary classInfo) {
        String qualifiedClassName = classInfo.qualifiedName();
        String nameOnly = TextUtil.getClassName((String)qualifiedClassName).replace('$', '.');
        String packagePath = classInfo.packageName().replace('.', '/');
        StringBuilder buf = new StringBuilder();
        buf.append("local:|module://");
        buf.append(docModule);
        buf.append("/doc/");
        buf.append(apiModulePart);
        buf.append('/');
        buf.append(packagePath);
        buf.append('/');
        buf.append(nameOnly);
        buf.append(".bajadoc");
        return BOrd.make((String)buf.toString());
    }

    static String getClassName(ClassSummary classInfo) {
        String qualifiedClassName = classInfo.qualifiedName();
        String nameOnly = TextUtil.getClassName((String)qualifiedClassName).replace('$', '.');
        return nameOnly;
    }
}

