/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.BajadocIndex;
import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.SlotDoc;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import java.util.HashMap;
import java.util.Optional;
import javax.baja.file.BIFile;

public class Flattener {
    ClassDoc target;
    HashMap<String, String> types = new HashMap();
    HashMap<String, MemberDoc> properties = new HashMap();
    HashMap<String, MemberDoc> actions = new HashMap();
    HashMap<String, MemberDoc> topics = new HashMap();
    HashMap<String, MemberDoc> fields = new HashMap();
    HashMap<String, MemberDoc> enums = new HashMap();
    HashMap<String, MemberDoc> methods = new HashMap();

    public ClassDoc flatten(ClassDoc cls) throws Exception {
        JavaType[] interfaces;
        this.target = cls;
        this.register(cls);
        this.register(cls.superClass());
        for (JavaType i : interfaces = cls.interfaces()) {
            this.register(i);
        }
        return new ClassDoc(cls.module(), cls.profile(), cls.name(), cls.packageName(), cls.docModule(), cls.modifiers(), cls.superClass(), cls.interfaces(), cls.typeParams(), cls.ancestors(), cls.extenders(), cls.implementors(), this.properties.values().toArray(new PropertyDoc[this.properties.size()]), this.actions.values().toArray(new ActionDoc[this.actions.size()]), this.topics.values().toArray(new TopicDoc[this.topics.size()]), this.fields.values().toArray(new FieldDoc[this.fields.size()]), this.enums.values().toArray(new FieldDoc[this.enums.size()]), cls.constructors(), this.methods.values().toArray(new MethodDoc[this.methods.size()]), ClassDoc.none, cls.classCategory(), cls.isInnerClass(), cls.description(), cls.tags(), cls.annotations());
    }

    private boolean register(JavaType type) throws Exception {
        JavaType[] interfaces;
        BIFile file;
        if (type == null) {
            return false;
        }
        String qName = type.qualifiedName();
        if (this.types.get(qName) != null) {
            return false;
        }
        this.types.put(qName, "marker");
        try {
            BajadocIndex.Entry entry = BajadocIndex.instance().getFirstEntry(qName, Optional.empty());
            if (entry == null) {
                return false;
            }
            file = (BIFile)entry.toOrd().resolve().get();
        }
        catch (Exception e) {
            System.out.println("WARNING: Cannot resolve: " + type.qualifiedName());
            return false;
        }
        ClassDoc cls = (ClassDoc)new BajadocParser().parse(file);
        this.register(cls);
        this.register(cls.superClass());
        for (JavaType i : interfaces = cls.interfaces()) {
            this.register(i);
        }
        return true;
    }

    private void register(ClassDoc cls) {
        for (PropertyDoc propertyDoc : cls.properties()) {
            Flattener.register(propertyDoc, this.properties);
        }
        for (SlotDoc slotDoc : cls.actions()) {
            Flattener.register(slotDoc, this.actions);
        }
        for (SlotDoc slotDoc : cls.topics()) {
            Flattener.register(slotDoc, this.topics);
        }
        for (MemberDoc memberDoc : cls.methods()) {
            Flattener.register(memberDoc, this.methods);
        }
        for (MemberDoc memberDoc : cls.fields()) {
            Flattener.register(memberDoc, this.fields);
        }
        for (MemberDoc memberDoc : cls.enumConstants()) {
            Flattener.register(memberDoc, this.enums);
        }
    }

    private static void register(MemberDoc member, HashMap<String, MemberDoc> list) {
        String anchor = member.anchor();
        MemberDoc dup = list.get(anchor);
        if (dup != null) {
            if (dup.description().length == 0 || dup.description()[0].text().length() == 1) {
                dup.setDescription(member.description());
            }
        } else {
            list.put(anchor, member);
        }
    }
}

