/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.parser;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.AnnotationElement;
import com.tridium.help.bajadoc.AnnotationElementDoc;
import com.tridium.help.bajadoc.AnnotationTypeDoc;
import com.tridium.help.bajadoc.AnnotationValue;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.FrameworkDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.JavaTypeVariable;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.ParameterizedJavaType;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.Returns;
import com.tridium.help.bajadoc.Tag;
import com.tridium.help.bajadoc.Throws;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.WildcardJavaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.baja.file.BIFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.Flags;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

public class BajadocParser {
    private static final JavaTypeVariable[] EMPTY_TYPE_PARAMS = new JavaTypeVariable[0];

    public Doc parse(InputStream in, String docModuleName) throws Exception {
        return this.parse(XParser.make((InputStream)in).parse(false), docModuleName);
    }

    public Doc parse(BIFile file) throws Exception {
        try (InputStream in = file.getInputStream();){
            BZipSpace space;
            Optional docModule;
            String docModuleName = null;
            if (file.getFileSpace() instanceof BZipSpace && (docModule = (space = (BZipSpace)file.getFileSpace()).getModule()).isPresent()) {
                docModuleName = ((BModule)docModule.get()).getModuleName();
            }
            Doc doc = this.parse(in, docModuleName);
            return doc;
        }
    }

    public Doc parse(String str, String docModuleName) throws Exception {
        return this.parse(XParser.make((String)str).parse(), docModuleName);
    }

    private Doc parse(XElem rootElem, String docModule) throws Exception {
        if (!"bajadoc".equals(rootElem.name())) {
            throw new XException("Not bajadoc XML file", rootElem);
        }
        if (!"2.0".equals(rootElem.get("version"))) {
            throw new XException("Only version 2.0 supported", rootElem);
        }
        if (rootElem.contentSize() == 0) {
            throw new XException("No bajadoc elements!", rootElem);
        }
        XElem contentElem = rootElem.elem(0);
        String content = contentElem.name();
        if ("class".equals(content)) {
            return this.parseClass(contentElem, docModule);
        }
        if ("package".equals(content)) {
            return BajadocParser.parsePackage(contentElem, docModule);
        }
        if ("module".equals(content)) {
            return BajadocParser.parseModule(contentElem, docModule);
        }
        if ("framework".equals(content)) {
            return BajadocParser.parseFramework(contentElem, docModule);
        }
        throw new XException("Unknown bajadoc content: " + content, contentElem);
    }

    private static FrameworkDoc parseFramework(XElem f, String docModule) throws Exception {
        XElem[] m = f.elems("module");
        ModuleDoc[] modules = new ModuleDoc[m.length];
        for (int i = 0; i < modules.length; ++i) {
            String name = m[i].get("name");
            DescriptionPart[] desc = DescriptionPart.makeBasicText(m[i].string());
            modules[i] = new ModuleDoc(name, "", "", "", "", docModule, null, null, desc, Tag.none);
        }
        DescriptionPart[] description = BajadocParser.getDescription(f);
        String vendorVersion = f.get("vendorVersion");
        Tag[] tags = BajadocParser.getTags(f);
        return new FrameworkDoc(modules, vendorVersion, description, tags);
    }

    private static ModuleDoc parseModule(XElem moduleElem, String docModule) throws Exception {
        String module = moduleElem.get("name");
        String profile = moduleElem.get("runtimeProfile");
        String bajaVersion = moduleElem.get("bajaVersion");
        String vendor = moduleElem.get("vendor");
        String vendorVersion = moduleElem.get("vendorVersion");
        XElem[] packageElems = moduleElem.elems("package");
        PackageDoc[] packages = new PackageDoc[packageElems.length];
        for (int i = 0; i < packages.length; ++i) {
            XElem p = packageElems[i];
            String name = p.get("name");
            DescriptionPart[] summary = BajadocParser.getDescription(p);
            packages[i] = new PackageDoc(module, profile, name, docModule, ClassSummary.none, summary, Tag.none, Annotation.none);
        }
        XElem[] classElems = moduleElem.elems("class");
        ClassSummary[] types = new ClassSummary[classElems.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = BajadocParser.parseClassSummary(classElems[i]);
        }
        DescriptionPart[] description = BajadocParser.getDescription(moduleElem);
        Tag[] tags = BajadocParser.getTags(moduleElem);
        return new ModuleDoc(module, profile, bajaVersion, vendor, vendorVersion, docModule, packages, types, description, tags);
    }

    private static PackageDoc parsePackage(XElem packageElem, String docModule) throws Exception {
        String module = packageElem.get("module", null);
        String profile = packageElem.get("runtimeProfile", null);
        String name = packageElem.get("name");
        XElem[] classElems = packageElem.elems("class");
        ClassSummary[] classes = new ClassSummary[classElems.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = BajadocParser.parseClassSummary(classElems[i]);
        }
        DescriptionPart[] description = BajadocParser.getDescription(packageElem);
        Tag[] tags = BajadocParser.getTags(packageElem);
        Annotation[] annotations = BajadocParser.getAnnotations(packageElem);
        return new PackageDoc(module, profile, name, docModule, classes, description, tags, annotations);
    }

    private static ClassSummary parseClassSummary(XElem clsElem) throws Exception {
        String packageName = clsElem.get("packageName");
        String name = clsElem.get("name");
        int category = 0;
        String cat = clsElem.get("category", null);
        if (cat != null) {
            category = ClassDoc.stringToCategory(cat);
        }
        DescriptionPart[] description = BajadocParser.getDescription(clsElem);
        String summary = ClassDoc.parseSummary(description);
        return new ClassSummary(name, packageName, category, summary);
    }

    private ClassDoc parseClass(XElem clsElem, String docModule) throws Exception {
        String module = clsElem.get("module", null);
        String profile = clsElem.get("runtimeProfile", null);
        String packageName = clsElem.get("packageName");
        String name = clsElem.get("name");
        int modifiers = BajadocParser.getModifiers(clsElem);
        boolean isInnerClass = clsElem.getb("innerClass", false);
        int category = 0;
        String cat = clsElem.get("category", null);
        if (cat != null) {
            category = ClassDoc.stringToCategory(cat);
        }
        JavaType[] ancestors = this.getExtraTypeInfo(clsElem.elem("ancestors"));
        JavaType[] extenders = this.getExtraTypeInfo(clsElem.elem("extenders"));
        JavaType[] implementors = this.getExtraTypeInfo(clsElem.elem("implementors"));
        XElem extendElem = clsElem.elem("extends");
        JavaType superClass = null;
        if (extendElem != null) {
            superClass = BajadocParser.getType(extendElem);
        }
        XElem[] interfaceElems = clsElem.elems("implements");
        JavaType[] interfaces = new JavaType[interfaceElems.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = BajadocParser.getType(interfaceElems[i]);
        }
        JavaTypeVariable[] params = BajadocParser.getTypeParams(clsElem);
        Annotation[] annotations = BajadocParser.getAnnotations(clsElem);
        XElem[] propertyElems = clsElem.elems("property");
        PropertyDoc[] properties = new PropertyDoc[propertyElems.length];
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = this.getProperty(propertyElems[i]);
        }
        XElem[] actionElems = clsElem.elems("action");
        ActionDoc[] actions = new ActionDoc[actionElems.length];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = this.getAction(actionElems[i]);
        }
        XElem[] topicElems = clsElem.elems("topic");
        TopicDoc[] topics = new TopicDoc[topicElems.length];
        for (int i = 0; i < topics.length; ++i) {
            topics[i] = this.getTopic(topicElems[i]);
        }
        XElem[] ctorElems = clsElem.elems("constructor");
        ConstructorDoc[] constructors = new ConstructorDoc[ctorElems.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructors[i] = this.getConstructor(ctorElems[i]);
        }
        XElem[] methodElems = clsElem.elems("method");
        MethodDoc[] methods = new MethodDoc[methodElems.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = this.getMethod(methodElems[i]);
        }
        XElem[] allFields = clsElem.elems("field");
        XElem[] fieldElems = (XElem[])Arrays.stream(allFields).filter(x -> !x.getb("enum", false)).toArray(XElem[]::new);
        FieldDoc[] fields = new FieldDoc[fieldElems.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.getField(fieldElems[i]);
        }
        XElem[] enumElems = (XElem[])Arrays.stream(allFields).filter(x -> x.getb("enum", false)).toArray(XElem[]::new);
        FieldDoc[] enums = new FieldDoc[enumElems.length];
        for (int i = 0; i < enums.length; ++i) {
            enums[i] = this.getField(enumElems[i]);
        }
        DescriptionPart[] description = BajadocParser.getDescription(clsElem);
        Tag[] tags = BajadocParser.getTags(clsElem);
        if ("annotation".equals(cat)) {
            XElem[] annotationElems = clsElem.elems("annotationElement");
            AnnotationElementDoc[] elements = new AnnotationElementDoc[annotationElems.length];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = this.getAnnotationElement(annotationElems[i]);
            }
            return new AnnotationTypeDoc(module, profile, name, packageName, docModule, modifiers, superClass, interfaces, params, ancestors, extenders, implementors, properties, actions, topics, fields, enums, constructors, methods, elements, ClassDoc.none, category, isInnerClass, description, tags, annotations);
        }
        return new ClassDoc(module, profile, name, packageName, docModule, modifiers, superClass, interfaces, params, ancestors, extenders, implementors, properties, actions, topics, fields, enums, constructors, methods, ClassDoc.none, category, isInnerClass, description, tags, annotations);
    }

    JavaType[] getExtraTypeInfo(XElem extra) throws Exception {
        if (extra == null) {
            return JavaType.NONE;
        }
        XElem[] xt = extra.elems("type");
        JavaType[] types = new JavaType[xt.length];
        for (int i = 0; i < xt.length; ++i) {
            types[i] = BajadocParser.getType(xt[i]);
        }
        return types;
    }

    private PropertyDoc getProperty(XElem elem) throws Exception {
        String name = elem.get("name");
        int flags = Flags.decodeFromString((String)elem.get("flags"));
        JavaType type = BajadocParser.getType(elem);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        return new PropertyDoc(name, flags, type, description, tags);
    }

    private ActionDoc getAction(XElem elem) throws Exception {
        String name = elem.get("name");
        int flags = Flags.decodeFromString((String)elem.get("flags"));
        Parameter[] params = this.getParams(elem);
        Parameter param = params.length == 0 ? null : params[0];
        Returns returns = this.getReturns(elem);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        return new ActionDoc(name, flags, param, returns, description, tags);
    }

    private TopicDoc getTopic(XElem elem) throws Exception {
        String name = elem.get("name");
        int flags = Flags.decodeFromString((String)elem.get("flags"));
        XElem typeElem = elem.elem("eventType");
        if (typeElem == null) {
            throw new XException("Missing eventType element on topic: " + name, elem);
        }
        JavaType eventType = BajadocParser.getType(typeElem);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        return new TopicDoc(name, flags, eventType, description, tags);
    }

    private ConstructorDoc getConstructor(XElem elem) throws Exception {
        String name = elem.get("name");
        int mods = BajadocParser.getModifiers(elem);
        Parameter[] params = this.getParams(elem);
        Throws[] throwTypes = this.getThrows(elem);
        boolean varargs = elem.getb("isVarargs", false);
        Annotation[] annotations = BajadocParser.getAnnotations(elem);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        return new ConstructorDoc(name, mods, varargs, params, throwTypes, description, tags, annotations);
    }

    private MethodDoc getMethod(XElem elem) throws Exception {
        String name = elem.get("name");
        int mods = BajadocParser.getModifiers(elem);
        JavaTypeVariable[] typeParams = BajadocParser.getTypeParams(elem);
        Annotation[] annotations = BajadocParser.getAnnotations(elem);
        Parameter[] params = this.getParams(elem);
        Throws[] throwTypes = this.getThrows(elem);
        Returns returns = this.getReturns(elem);
        boolean varargs = elem.getb("isVarargs", false);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        return new MethodDoc(name, mods, varargs, typeParams, params, throwTypes, returns, description, tags, annotations);
    }

    private FieldDoc getField(XElem elem) throws Exception {
        String name = elem.get("name");
        int mods = BajadocParser.getModifiers(elem);
        JavaType type = BajadocParser.getType(elem);
        Annotation[] annotations = BajadocParser.getAnnotations(elem);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        return new FieldDoc(name, mods, type, description, tags, annotations);
    }

    private AnnotationElementDoc getAnnotationElement(XElem elem) throws Exception {
        String name = elem.get("name");
        int mods = BajadocParser.getModifiers(elem);
        Returns returns = this.getReturns(elem);
        DescriptionPart[] description = BajadocParser.getDescription(elem);
        Tag[] tags = BajadocParser.getTags(elem);
        AnnotationValue def = null;
        XElem defElem = elem.elem("defaultValue");
        if (defElem != null) {
            def = BajadocParser.getAnnotationValue(defElem);
        }
        return new AnnotationElementDoc(name, mods, returns, description, tags, Annotation.none, def);
    }

    private static AnnotationValue getAnnotationValue(XElem elem) throws Exception {
        AnnotationValue[] vals = BajadocParser.getAnnotationValues(elem);
        return vals.length > 0 ? vals[0] : null;
    }

    private static AnnotationValue[] getAnnotationValues(XElem elem) throws Exception {
        XElem[] valueElems = elem.elems("annotationValue");
        AnnotationValue[] values = new AnnotationValue[valueElems.length];
        block14: for (int i = 0; i < values.length; ++i) {
            switch (valueElems[i].get("kind")) {
                case "array": {
                    XElem arrayElem = valueElems[i].elem("elementArray");
                    values[i] = AnnotationValue.makeForArray(BajadocParser.getAnnotationValues(arrayElem));
                    continue block14;
                }
                case "type": {
                    JavaType t = BajadocParser.getType(valueElems[i]);
                    values[i] = AnnotationValue.makeForType(t);
                    continue block14;
                }
                case "annotation": {
                    values[i] = AnnotationValue.makeForAnnotation(BajadocParser.getAnnotations(valueElems[i])[0]);
                    continue block14;
                }
                case "enum": {
                    String field = valueElems[i].elem("enumField").get("name");
                    JavaType t = BajadocParser.getType(valueElems[i]);
                    values[i] = AnnotationValue.makeForEnum(t, field);
                    continue block14;
                }
                case "expr": {
                    values[i] = AnnotationValue.makeForExpression(valueElems[i].elem("expression").string());
                }
            }
        }
        return values;
    }

    private static JavaTypeVariable[] getTypeParams(XElem elem) throws Exception {
        XElem[] paramElems;
        XElem paramSetElem = elem.elem("typeParameters");
        if (paramSetElem != null && (paramElems = paramSetElem.elems("typeVariable")).length > 0) {
            JavaTypeVariable[] params = new JavaTypeVariable[paramElems.length];
            for (int i = 0; i < params.length; ++i) {
                String className = paramElems[i].get("class");
                int dim = paramElems[i].geti("dimension", 0);
                Annotation[] annotations = BajadocParser.getAnnotations(paramElems[i]);
                params[i] = BajadocParser.getTypeVariableJavaType(className, dim, paramElems[i], annotations);
            }
            return params;
        }
        return EMPTY_TYPE_PARAMS;
    }

    private static Annotation[] getAnnotations(XElem elem) throws Exception {
        XElem[] annotationElems = elem.elems("annotation");
        Annotation[] annotations = new Annotation[annotationElems.length];
        for (int i = 0; i < annotationElems.length; ++i) {
            JavaType type = BajadocParser.getType(annotationElems[i]);
            XElem[] valueElems = annotationElems[i].elems("elementValue");
            AnnotationElement[] elems = new AnnotationElement[valueElems.length];
            for (int j = 0; j < valueElems.length; ++j) {
                elems[j] = new AnnotationElement(valueElems[j].get("name"), BajadocParser.getAnnotationValue(valueElems[j]));
            }
            annotations[i] = new Annotation(type, elems);
        }
        return annotations;
    }

    private Returns getReturns(XElem elem) throws Exception {
        XElem returnsElem = elem.elem("return");
        if (returnsElem == null) {
            throw new XException("Missing return element: " + elem, elem);
        }
        JavaType returnType = BajadocParser.getType(returnsElem);
        DescriptionPart[] returnDescription = BajadocParser.getDescription(returnsElem);
        return new Returns(returnType, returnDescription);
    }

    private Parameter[] getParams(XElem elem) throws Exception {
        XElem[] paramElems = elem.elems("parameter");
        Parameter[] params = new Parameter[paramElems.length];
        for (int i = 0; i < params.length; ++i) {
            String name = paramElems[i].get("name");
            JavaType type = BajadocParser.getType(paramElems[i]);
            DescriptionPart[] description = BajadocParser.getDescription(paramElems[i]);
            Annotation[] annotations = BajadocParser.getAnnotations(paramElems[i]);
            params[i] = new Parameter(name, type, description, annotations);
        }
        return params;
    }

    private Throws[] getThrows(XElem elem) throws Exception {
        XElem[] exceptionElems = elem.elems("throws");
        if (exceptionElems.length == 0) {
            return Throws.none;
        }
        Throws[] exceptions = new Throws[exceptionElems.length];
        for (int i = 0; i < exceptions.length; ++i) {
            JavaType type = BajadocParser.getType(exceptionElems[i]);
            DescriptionPart[] description = BajadocParser.getDescription(exceptionElems[i]);
            exceptions[i] = new Throws(type, description);
        }
        return exceptions;
    }

    private static JavaType getType(XElem elem) throws Exception {
        JavaType[] types = BajadocParser.getTypes(elem.elems());
        return types.length > 0 ? types[0] : null;
    }

    private static XElem[] filterTypeElements(XElem[] elems) {
        return (XElem[])Arrays.stream(elems).filter(x -> BajadocParser.isJavaTypeElement(x)).toArray(XElem[]::new);
    }

    private static boolean isJavaTypeElement(XElem elem) {
        String name = elem.name();
        return "type".equals(name) || "parameterizedType".equals(name) || "wildcardType".equals(name) || "typeVariable".equals(name);
    }

    private static JavaType[] getTypes(XElem[] elems) throws Exception {
        if (elems == null || elems.length == 0) {
            return JavaType.NONE;
        }
        XElem[] typeElems = BajadocParser.filterTypeElements(elems);
        if (typeElems.length == 0) {
            return JavaType.NONE;
        }
        JavaType[] types = new JavaType[typeElems.length];
        block12: for (int i = 0; i < typeElems.length; ++i) {
            XElem elem = typeElems[i];
            String className = elem.get("class");
            String module = elem.get("module", null);
            String profile = elem.get("profile", null);
            int dim = elem.geti("dimension", 0);
            Annotation[] annotations = BajadocParser.getAnnotations(elem);
            switch (elem.name()) {
                case "parameterizedType": {
                    JavaType[] args = BajadocParser.getTypes(elem.elem("args").elems());
                    types[i] = new ParameterizedJavaType(className, dim, args, annotations);
                    continue block12;
                }
                case "wildcardType": {
                    types[i] = BajadocParser.getWildcardType(className, dim, elem, annotations);
                    continue block12;
                }
                case "typeVariable": {
                    types[i] = BajadocParser.getTypeVariableJavaType(className, dim, elem, annotations);
                    continue block12;
                }
                case "type": {
                    types[i] = new JavaType(className, dim, annotations);
                    continue block12;
                }
                default: {
                    throw new XException("Unexpected type element", elem);
                }
            }
        }
        return types;
    }

    private static JavaTypeVariable getTypeVariableJavaType(String className, int dim, XElem elem, Annotation[] annotations) throws Exception {
        XElem boundsElem = elem.elem("bounds");
        DescriptionPart[] desc = BajadocParser.getDescription(elem);
        return boundsElem != null ? new JavaTypeVariable(className, dim, BajadocParser.getTypes(boundsElem.elems()), desc, annotations) : new JavaTypeVariable(className, dim, desc, annotations);
    }

    private static WildcardJavaType getWildcardType(String className, int dim, XElem elem, Annotation[] annotations) throws Exception {
        XElem boundsElem = elem.elem("bounds");
        if (boundsElem != null) {
            String kind = boundsElem.get("kind");
            if (kind != null) {
                JavaType[] bounds = BajadocParser.getTypes(boundsElem.elems());
                if ("extends".equals(kind)) {
                    return WildcardJavaType.makeExtendsBounded(className, dim, bounds, annotations);
                }
                if ("super".equals(kind)) {
                    return WildcardJavaType.makeSuperBounded(className, dim, bounds, annotations);
                }
                throw new XException("Unknown value for bounds kind attribute", boundsElem);
            }
            throw new XException("Expected bounds kind attribute", boundsElem);
        }
        return WildcardJavaType.make(className, dim, annotations);
    }

    private static int getModifiers(XElem elem) throws Exception {
        int mods = 0;
        if (elem.getb("public", false)) {
            mods |= 1;
        }
        if (elem.getb("protected", false)) {
            mods |= 4;
        }
        if (elem.getb("private", false)) {
            mods |= 2;
        }
        if (elem.getb("abstract", false)) {
            mods |= 0x400;
        }
        if (elem.getb("static", false)) {
            mods |= 8;
        }
        if (elem.getb("final", false)) {
            mods |= 0x10;
        }
        if (elem.getb("interface", false)) {
            mods |= 0x200;
        }
        if (elem.getb("transient", false)) {
            mods |= 0x80;
        }
        if (elem.getb("native", false)) {
            mods |= 0x100;
        }
        if (elem.getb("synchronized", false)) {
            mods |= 0x20;
        }
        if (elem.getb("volatile", false)) {
            mods |= 0x40;
        }
        return mods;
    }

    private static DescriptionPart[] getDescription(XElem elem) {
        XElem descriptionElem = elem.elem("description");
        if (descriptionElem != null) {
            return BajadocParser.getDescriptionParts(descriptionElem);
        }
        return DescriptionPart.none;
    }

    private static Tag[] getTags(XElem elem) {
        XElem[] tagElems = elem.elems("tag");
        if (tagElems.length == 0) {
            return Tag.none;
        }
        Tag[] tags = new Tag[tagElems.length];
        for (int i = 0; i < tags.length; ++i) {
            String name = tagElems[i].get("name");
            DescriptionPart[] description = BajadocParser.getDescriptionParts(tagElems[i]);
            tags[i] = new Tag(name, description);
        }
        return tags;
    }

    private static DescriptionPart[] getDescriptionParts(XElem elem) {
        if (elem == null || elem.contentSize() == 0) {
            return DescriptionPart.none;
        }
        ArrayList<DescriptionPart> parts = new ArrayList<DescriptionPart>();
        for (int i = 0; i < elem.contentSize(); ++i) {
            XElem elemContent;
            XContent content = elem.content(i);
            if (content instanceof XText) {
                parts.add(DescriptionPart.makeText(((XText)content).string()));
                continue;
            }
            if (!(content instanceof XElem) || !"see".equals((elemContent = (XElem)content).name())) continue;
            String ref = elemContent.get("ref", null);
            if (ref != null) {
                parts.add(DescriptionPart.makeLink(elemContent.string(), ref));
                continue;
            }
            parts.add(DescriptionPart.makeText(elemContent.string()));
        }
        return parts.toArray(new DescriptionPart[parts.size()]);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: BajadocParser <bajadocFile>");
            return;
        }
        File file = new File(args[0]);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ClassDoc doc = (ClassDoc)new BajadocParser().parse(in, "test-doc");
            in.close();
            doc.dump();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

