/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.html;

import com.tridium.help.BajadocIndex;
import com.tridium.help.Hierarchy;
import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.AnnotationElement;
import com.tridium.help.bajadoc.AnnotationElementDoc;
import com.tridium.help.bajadoc.AnnotationTypeDoc;
import com.tridium.help.bajadoc.AnnotationValue;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.ExecutableDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.FrameworkDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.JavaTypeVariable;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.Returns;
import com.tridium.help.bajadoc.SlotDoc;
import com.tridium.help.bajadoc.Tag;
import com.tridium.help.bajadoc.Throws;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.html.UriPath;
import com.tridium.help.bajadoc.ui.BBajadocOptions;
import com.tridium.help.bajadoc.ui.Flattener;
import com.tridium.help.bajadoc.util.TypeNameFormatter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Flags;

public class HtmlCompiler
extends HtmlWriter {
    private static final String ICONS_BASE = "module://icons";
    private static final String CSS = "bajadoc.css";
    private static final String JQUERY = "jquery/jquery-3.4.1.min.js";
    private static final String PROPERTY_ICON = "x16/shapes/squareBlue.png";
    private static final String ACTION_ICON = "x16/shapes/squareGreen.png";
    private static final String TOPIC_ICON = "x16/shapes/squareGold.png";
    private static final String CONSTRUCTOR_ICON = "x16/shapes/diamondRed.png";
    private static final String METHOD_ICON = "x16/shapes/diamondGreen.png";
    private static final String FIELD_ICON = "x16/shapes/diamondPurple.png";
    private static final String ENUM_CONSTANT_ICON = "x16/shapes/diamondBlue.png";
    private static final String ANNOTATION_ELEM_ICON = "x16/shapes/circleGold.png";
    private static final String FRAMEWORK_ICON = "x16/files/bajadoc.png";
    private static final String MODULE_ICON = "x16/module.png";
    private static final String PACKAGE_ICON = "x16/folder.png";
    private static final String CLASS_ICON = "x16/object.png";
    private static final String EXPANDED_ICON = "x16/arrowDown.png";
    private static final String CLOSED_ICON = "x16/arrowRight.png";
    private static final String DEPRECATED_ICON = "x16/warning.png";
    private final BajadocHtmlCompilerOptions options;

    private HtmlCompiler(Writer out, BajadocHtmlCompilerOptions options) {
        super(out);
        this.options = options;
    }

    public static void compile(Writer out, Doc doc, BajadocHtmlCompilerOptions opts) {
        HtmlCompiler h = new HtmlCompiler(out, opts);
        if (doc instanceof FrameworkDoc) {
            h.doCompileFramework((FrameworkDoc)doc);
        } else if (doc instanceof ModuleDoc) {
            h.doCompileModule((ModuleDoc)doc);
        } else if (doc instanceof PackageDoc) {
            h.doCompilePackage((PackageDoc)doc);
        } else if (doc instanceof ClassDoc) {
            h.doCompileClass((ClassDoc)doc);
        } else {
            throw new IllegalStateException(doc.toString());
        }
    }

    public static void compileFramework(Writer out, FrameworkDoc f, BajadocHtmlCompilerOptions opts) {
        HtmlCompiler h = new HtmlCompiler(out, opts);
        h.doCompileFramework(f);
    }

    public static void compileModule(Writer out, ModuleDoc m, BajadocHtmlCompilerOptions opts) {
        HtmlCompiler h = new HtmlCompiler(out, opts);
        h.doCompileModule(m);
    }

    public static void compilePackage(Writer out, PackageDoc p, BajadocHtmlCompilerOptions opts) {
        HtmlCompiler h = new HtmlCompiler(out, opts);
        h.doCompilePackage(p);
    }

    public static void compileClass(Writer out, ClassDoc c, boolean bajaOnly, BajadocHtmlCompilerOptions opts) {
        HtmlCompiler h = new HtmlCompiler(out, opts);
        h.doCompileClass(c);
    }

    private void doCompileFramework(FrameworkDoc f) {
        String name = "Niagara Framework " + f.frameworkVersion();
        this.printHeader(name, f);
        this.printMainItemDocStart();
        this.printItemIcons(FRAMEWORK_ICON);
        this.printContentBlockStart();
        this.printTitleBlockStart(f, "", name, null, null, false, f.annotations());
        this.printTitleBlockEnd();
        this.printContentBlockEnd();
        this.printMainItemDocEnd();
        this.println();
        this.printSummaryGroupSeparator("Modules");
        this.printSummaryTableStart();
        this.println();
        for (ModuleDoc m : f.modules()) {
            String desc = this.descriptionPartsToHtml(m.description());
            if (desc == null) {
                desc = "";
            }
            String modulePart = m.modulePart();
            String docModule = m.docModule();
            this.w("<tr><td>");
            this.a(this.getModuleHref(modulePart, docModule), modulePart);
            this.w("</td><td>").w((Object)desc).w((Object)"</td></tr>").println();
        }
        this.printSummaryTableEnd();
        this.println();
        this.printFooter();
    }

    private void doCompileModule(ModuleDoc m) {
        this.printHeader("Module Part " + m.modulePart(), m);
        this.printMainItemDocStart();
        this.printItemIcons(MODULE_ICON);
        this.printContentBlockStart();
        this.printModuleTitleBlock(m);
        this.printContentBlockEnd();
        this.printMainItemDocEnd();
        this.printModuleIndex(m);
        this.printFooter();
    }

    private void printModuleTitleBlock(ModuleDoc m) {
        this.printTitleBlockStart(m, "module part ", m.modulePart(), null, null, false, m.annotations());
        if (m.bajaVersion() != null && !m.bajaVersion().isEmpty()) {
            this.printTitleBlockItem("baja version", m.bajaVersion());
        }
        if (m.vendor() != null && !m.vendor().isEmpty()) {
            this.printTitleBlockItem("vendor", m.vendor());
        }
        if (m.vendorVersion() != null && !m.vendorVersion().isEmpty()) {
            this.printTitleBlockItem("vendor version", m.vendorVersion());
        }
        this.printTitleBlockEnd();
        this.printMainItemDescriptionStart();
        this.printDetails(m);
        this.printMainItemDescriptionEnd();
    }

    private void printModuleIndex(ModuleDoc m) {
        PackageDoc[] packages = m.packages();
        Arrays.sort(packages, (p1, p2) -> p1.name().compareTo(p2.name()));
        this.printSummaryGroupSeparator("Packages");
        this.printSummaryTableStart();
        for (PackageDoc p : packages) {
            this.w("<tr><td><a href='");
            String href = this.getPackageHref(p.modulePart(), p.name(), p.docModule());
            this.w(href).w((Object)"'>");
            this.w(p.name()).w((Object)"</a></td><td>\n");
            String s = p.summary();
            if (s.isEmpty()) {
                s = "&nbsp;";
            }
            this.w(s);
            this.w("</td></tr>\n");
        }
        this.printSummaryTableEnd();
        ClassSummary[] types = m.typesSorted();
        if (types.length > 0) {
            this.printSummaryGroupSeparator("Types");
            this.printSummaryTableStart();
            for (ClassSummary c : types) {
                this.printModuleTypeSummary(m, c);
            }
            this.printSummaryTableEnd();
        }
    }

    private void printModuleTypeSummary(ModuleDoc m, ClassSummary c) {
        this.w("<tr><td><a href='");
        this.w(this.getTypeHref(m.modulePart(), c, m.docModule())).w((Object)"'>");
        this.w(c.name()).w((Object)"</a></td><td>\n");
        String s = c.summary();
        if (s == null || s.isEmpty()) {
            s = "&nbsp;";
        }
        this.w(s);
        this.w("</td></tr>\n");
    }

    private void doCompilePackage(PackageDoc p) {
        this.printHeader("Package " + p.name(), p);
        this.printMainItemDocStart();
        this.printItemIcons(PACKAGE_ICON);
        this.printContentBlockStart();
        this.printPackageTitleBlock(p);
        this.printContentBlockEnd();
        this.printMainItemDocEnd();
        this.printPackageIndex(p);
        this.printFooter();
    }

    private void printPackageTitleBlock(PackageDoc p) {
        this.printTitleBlockStart(p, "package ", p.name(), p.modulePart(), p.docModule(), false, p.annotations());
        this.printTitleBlockEnd();
        this.printMainItemDescriptionStart();
        this.printDetails(p);
        this.printMainItemDescriptionEnd();
    }

    private void printPackageIndex(PackageDoc p) {
        this.printPackageSummaryGroup(p, p.interfacesSorted(), "Interfaces");
        this.printPackageSummaryGroup(p, p.normalSorted(), "Classes");
        this.printPackageSummaryGroup(p, p.enumsSorted(), "Enums");
        this.printPackageSummaryGroup(p, p.exceptionsSorted(), "Exceptions");
        this.printPackageSummaryGroup(p, p.annotationTypesSorted(), "Annotation Types");
    }

    private void printPackageSummaryGroup(PackageDoc p, ClassSummary[] cs, String group) {
        if (cs.length > 0) {
            this.printSummaryGroupSeparator(group);
            this.printSummaryTableStart();
            for (ClassSummary c : cs) {
                this.printPackageClassSummary(p, c);
            }
            this.printSummaryTableEnd();
        }
    }

    private void printPackageClassSummary(PackageDoc p, ClassSummary c) {
        this.w("<tr><td><a href='");
        this.w(this.getTypeHref(p.modulePart(), c, p.docModule())).w((Object)"'>");
        this.w(c.name()).w((Object)"</a></td><td>\n");
        String s = c.summary();
        if (s == null || s.isEmpty()) {
            s = "&nbsp;";
        }
        this.w(s);
        this.w("</td></tr>\n");
    }

    private void doCompileClass(ClassDoc c) {
        try {
            Hierarchy.Entry entry;
            Hierarchy hierarchy;
            if (this.options.flattenInheritance) {
                c = new Flattener().flatten(c);
            }
            this.printHeader(c.qualifiedName(), c);
            this.printMainItemDocStart();
            this.printItemIcons(CLASS_ICON);
            this.printContentBlockStart();
            this.printClassTitleBlock(c, c.isDeprecated());
            this.printAncestors(c);
            this.printClassDetails(c);
            this.printContentBlockEnd();
            this.printMainItemDocEnd();
            if (this.options.includeSubclassHierarchy && !c.isInterface() && !"java.lang.Object".equals(c.qualifiedName()) && (hierarchy = Hierarchy.instance()).available() && hierarchy.hasSubEntries(entry = new Hierarchy.Entry(c.modulePart(), c.packageName(), c.name()))) {
                this.printSummaryGroupSeparator("Subclasses");
                this.printSubclassItemStart(entry, true, false, null);
                this.printSubClassTree(hierarchy, entry);
                this.printSubclassItemEnd();
            }
            if (this.options.includeMemberIndex) {
                this.printMemberIndex(c);
            }
            this.printMemberDetails(c);
            this.printFooter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSubClassTree(Hierarchy hierarchy, Hierarchy.Entry entry) {
        Arrays.stream(hierarchy.getSubEntries(entry)).sorted(Comparator.comparing(e -> e.name())).forEach(e -> {
            String href = this.getTypeHref(e.packageName(), e.name());
            if (hierarchy.hasSubEntries((Hierarchy.Entry)e)) {
                this.printSubclassItemStart((Hierarchy.Entry)e, false, false, href);
                this.printSubClassTree(hierarchy, (Hierarchy.Entry)e);
                this.printSubclassItemEnd();
            } else {
                this.printSubclassItemStart((Hierarchy.Entry)e, false, true, href);
                this.printSubclassItemEnd();
            }
        });
    }

    private void printSubclassItemStart(Hierarchy.Entry e, boolean isRoot, boolean isLeaf, String href) {
        this.w("<div class='subclass");
        if (isLeaf) {
            this.w(" leaf");
        } else if (isRoot) {
            this.w(" root");
        }
        this.w("'>\n");
        if (!isLeaf) {
            this.w("<a class='expand-subclass'>");
            this.printIcon(CLOSED_ICON, "closed-subclass");
            this.printIcon(EXPANDED_ICON, "expanded-subclass");
            this.w("</a>\n");
        }
        this.printIcon(CLASS_ICON);
        if (href != null) {
            this.w("<a href='").w((Object)href).w((Object)"'>");
            this.w(e.name());
            this.w("</a>\n");
        } else {
            this.w(e.name());
        }
    }

    private void printSubclassItemEnd() {
        this.w("</div>\n");
    }

    private void printAncestors(ClassDoc clsDoc) {
        JavaType[] ancestors = clsDoc.ancestors();
        if (ancestors.length == 0) {
            return;
        }
        this.w("<pre>").nl();
        for (int i = 0; i < ancestors.length; ++i) {
            if (i > 0) {
                if (i > 1) {
                    this.w(TextUtil.getSpaces((int)((i - 1) * 5)));
                }
                this.w("  |").nl();
                if (i > 1) {
                    this.w(TextUtil.getSpaces((int)((i - 1) * 5)));
                }
                this.w("  +--");
            }
            this.a(this.getTypeHref(ancestors[i]), ancestors[i].name()).nl();
        }
        this.w("</pre><br>").nl();
    }

    private String makeClassTitleDetails(ClassDoc clsDoc) {
        if (clsDoc.typeParams().length > 0) {
            StringBuilder sb = new StringBuilder(clsDoc.name());
            this.getTypeParamDetails(clsDoc.typeParams(), sb);
            return sb.toString();
        }
        return clsDoc.name();
    }

    private static String getClassIntro(ClassDoc cls) {
        StringBuilder sb = new StringBuilder(cls.explicitModifiersToString());
        if (cls.isInterface()) {
            sb.append("interface ");
        } else if (cls.isEnum()) {
            sb.append("enum ");
        } else if (cls.isAnnotationType()) {
            sb.append("@interface ");
        } else {
            sb.append("class ");
        }
        return sb.toString();
    }

    private void printClassTitleBlock(ClassDoc clsDoc, boolean deprecated) {
        JavaType[] implementors;
        int i;
        JavaType[] extenders;
        JavaType[] interfaces;
        String lead = HtmlCompiler.getClassIntro(clsDoc);
        String titleName = this.makeClassTitleDetails(clsDoc);
        this.printTitleBlockStart(clsDoc, lead, titleName, clsDoc.modulePart(), clsDoc.docModule(), deprecated, clsDoc.annotations());
        String packageName = clsDoc.packageName();
        String packageHref = this.getPackageHref(clsDoc.modulePart(), packageName, clsDoc.docModule());
        this.printTitleBlockItem("package", "<a href='" + packageHref + "'>" + packageName + "</a>");
        JavaType superClass = clsDoc.superClass();
        if (superClass != null) {
            this.printTitleBlockItemStart("extends");
            this.printType(superClass);
            this.printTitleBlockItemEnd();
        }
        if ((interfaces = clsDoc.interfaces()).length > 0) {
            String key = clsDoc.isInterface() ? "extends" : "implements";
            this.printTitleBlockItemStart(key);
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                if (i2 > 0) {
                    this.w(", ");
                }
                this.printType(interfaces[i2]);
            }
            this.printTitleBlockItemEnd();
        }
        if ((extenders = clsDoc.extenders()).length > 0) {
            String key = clsDoc.isInterface() ? "known subinterfaces" : "known subclasses";
            this.printTitleBlockItemStart(key);
            for (i = 0; i < extenders.length; ++i) {
                if (i > 0) {
                    this.w(", ");
                }
                this.printType(extenders[i]);
            }
            this.printTitleBlockItemEnd();
        }
        if ((implementors = clsDoc.implementors()).length > 0) {
            this.printTitleBlockItemStart("known implementing classes");
            for (i = 0; i < implementors.length; ++i) {
                if (i > 0) {
                    this.w(", ");
                }
                this.printType(implementors[i]);
            }
            this.printTitleBlockItemEnd();
        }
        this.printTitleBlockEnd();
    }

    /*
     * WARNING - void declaration
     */
    private void printMemberIndex(ClassDoc clsDoc) {
        TopicDoc[] topics;
        ActionDoc[] actions;
        PropertyDoc[] props;
        this.w("<div class='member-index'>\n");
        boolean firstProperty = true;
        for (PropertyDoc p : props = clsDoc.propertiesSorted()) {
            if (firstProperty) {
                this.printSummaryGroupSeparator("Property Summary");
                this.w("<ul class='member-index'>\n");
                firstProperty = false;
            }
            this.w("<li>");
            this.printIcon(PROPERTY_ICON);
            this.printPropertySummary(p, true);
            this.w("</li>\n");
        }
        if (!firstProperty) {
            this.w("</ul>\n");
        }
        boolean firstAction = true;
        for (ActionDoc a : actions = clsDoc.actionsSorted()) {
            if (firstAction) {
                this.printSummaryGroupSeparator("Action Summary");
                this.w("<ul class='member-index'>\n");
                firstAction = false;
            }
            this.w("<li>");
            this.printIcon(ACTION_ICON);
            this.printActionSummary(a, true);
            this.w("</li>\n");
        }
        if (!firstAction) {
            this.w("</ul>\n");
        }
        boolean firstTopic = true;
        for (TopicDoc topicDoc : topics = clsDoc.topicsSorted()) {
            if (firstTopic) {
                this.printSummaryGroupSeparator("Topic Summary");
                this.w("<ul class='member-index'>\n");
                firstTopic = false;
            }
            this.w("<li>");
            this.printIcon(TOPIC_ICON);
            this.printTopicSummary(topicDoc, true);
            this.w("</li>\n");
        }
        if (!firstTopic) {
            this.w("</ul>\n");
        }
        if (!this.options.showBajaOnly) {
            boolean bl;
            void var11_29;
            boolean firstConstructor = true;
            for (int i = 0; !this.options.showBajaOnly && i < clsDoc.constructors().length; ++i) {
                ConstructorDoc constructor = clsDoc.constructors()[i];
                if (!HtmlCompiler.isDocAccess(clsDoc, constructor.modifiers())) continue;
                if (firstConstructor) {
                    this.printSummaryGroupSeparator("Constructor Summary");
                    this.w("<ul class='member-index'>\n");
                    firstConstructor = false;
                }
                this.w("<li>");
                this.printIcon(CONSTRUCTOR_ICON);
                this.printConstructorSummary(constructor, true);
                this.w("</li>\n");
            }
            if (!firstConstructor) {
                this.w("</ul>\n");
            }
            if (clsDoc.isEnum() && !this.options.showBajaOnly) {
                FieldDoc[] enums;
                boolean firstEnum = true;
                for (FieldDoc f : enums = clsDoc.enumConstants()) {
                    if (firstEnum) {
                        this.printSummaryGroupSeparator("Enum Constant Summary");
                        this.w("<ul class='member-index'>\n");
                        firstEnum = false;
                    }
                    this.w("<li>");
                    this.printIcon(ENUM_CONSTANT_ICON);
                    this.printFieldSummary(f, true, true);
                    this.w("</li>\n");
                }
                if (!firstEnum) {
                    this.w("</ul>\n");
                }
            }
            boolean firstMethod = true;
            MethodDoc[] methods = clsDoc.methodsSorted();
            boolean bl2 = false;
            while (!this.options.showBajaOnly && var11_29 < methods.length) {
                MethodDoc method = methods[var11_29];
                if (HtmlCompiler.isDocAccess(clsDoc, method.modifiers())) {
                    if (firstMethod) {
                        this.printSummaryGroupSeparator("Method Summary");
                        this.w("<ul class='member-index'>\n");
                        firstMethod = false;
                    }
                    this.w("<li>");
                    this.printIcon(METHOD_ICON);
                    this.printMethodSummary(clsDoc, method, true);
                    this.w("</li>\n");
                }
                ++var11_29;
            }
            if (!firstMethod) {
                this.w("</ul>\n");
            }
            boolean bl3 = true;
            FieldDoc[] fields = clsDoc.fieldsSorted();
            for (int i = 0; !this.options.showBajaOnly && i < fields.length; ++i) {
                FieldDoc field = fields[i];
                if (!HtmlCompiler.isDocAccess(clsDoc, field.modifiers())) continue;
                if (bl) {
                    this.printSummaryGroupSeparator("Field Summary");
                    this.w("<ul class='member-index'>\n");
                    bl = false;
                }
                this.w("<li>");
                this.printIcon(FIELD_ICON);
                this.printFieldSummary(field, false, true);
                this.w("</li>\n");
            }
            if (!bl) {
                this.w("</ul>\n");
            }
        }
        if (clsDoc instanceof AnnotationTypeDoc && !this.options.showBajaOnly) {
            boolean firstElement = true;
            AnnotationElementDoc[] elems = ((AnnotationTypeDoc)clsDoc).elementsSorted();
            for (int i = 0; i < elems.length; ++i) {
                AnnotationElementDoc annotationElementDoc = elems[i];
                if (firstElement) {
                    this.printSummaryGroupSeparator("Element Summary");
                    this.w("<ul class='member-index'>\n");
                    firstElement = false;
                }
                this.w("<li>");
                this.printIcon(ANNOTATION_ELEM_ICON);
                this.printAnnotationElementSummary(annotationElementDoc, true);
                this.w("</li>\n");
            }
            if (!firstElement) {
                this.w("</ul>\n");
            }
        }
        this.w("</div>\n");
    }

    private void printClassDetails(ClassDoc clsDoc) {
        this.printMainItemDescriptionStart();
        this.w("<a name='classDetails'></a>\n");
        if (clsDoc.isDeprecated()) {
            Tag deprecatedTag = clsDoc.tag("@deprecated");
            this.printDeprecationNotice(this.descriptionPartsToHtml(deprecatedTag.value()));
        }
        this.printDetails(clsDoc);
        this.printMainItemDescriptionEnd();
    }

    private void printMemberDetails(ClassDoc clsDoc) {
        int i;
        if (clsDoc.properties().length > 0) {
            this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Property Detail" : "Properties");
            for (i = 0; i < clsDoc.propertiesSorted().length; ++i) {
                PropertyDoc prop = clsDoc.propertiesSorted()[i];
                this.printPropertyDetail(prop);
            }
        }
        if (clsDoc.actions().length > 0) {
            this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Action Detail" : "Actions");
            for (i = 0; i < clsDoc.actionsSorted().length; ++i) {
                ActionDoc action = clsDoc.actionsSorted()[i];
                this.printActionDetail(action);
            }
        }
        if (clsDoc.topics().length > 0) {
            this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Topic Detail" : "Topics");
            for (i = 0; i < clsDoc.topicsSorted().length; ++i) {
                TopicDoc topic = clsDoc.topicsSorted()[i];
                this.printTopicDetail(topic);
            }
        }
        if (!this.options.showBajaOnly) {
            if (clsDoc.constructors().length > 0) {
                boolean firstConstructor = true;
                for (int i2 = 0; i2 < clsDoc.constructors().length; ++i2) {
                    ConstructorDoc constructor = clsDoc.constructors()[i2];
                    if (!HtmlCompiler.isDocAccess(clsDoc, constructor.modifiers())) continue;
                    if (firstConstructor) {
                        this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Constructor Detail" : "Constructors");
                        firstConstructor = false;
                    }
                    this.printConstructorDetail(constructor);
                }
            }
            if (clsDoc.isEnum()) {
                this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Enum Constant Detail" : "Enum Constants");
                for (i = 0; i < clsDoc.enumConstantsSorted().length; ++i) {
                    FieldDoc field = clsDoc.enumConstantsSorted()[i];
                    this.printFieldDetail(field, true);
                }
            }
            if (clsDoc.methods().length > 0) {
                boolean firstMethod = true;
                for (int i3 = 0; i3 < clsDoc.methodsSorted().length; ++i3) {
                    MethodDoc method = clsDoc.methodsSorted()[i3];
                    if (!HtmlCompiler.isDocAccess(clsDoc, method.modifiers())) continue;
                    if (firstMethod) {
                        this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Method Detail" : "Methods");
                        firstMethod = false;
                    }
                    this.printMethodDetail(clsDoc, method);
                }
            }
            if (clsDoc.fields().length > 0) {
                boolean firstField = true;
                for (int i4 = 0; i4 < clsDoc.fieldsSorted().length; ++i4) {
                    FieldDoc field = clsDoc.fieldsSorted()[i4];
                    if (!HtmlCompiler.isDocAccess(clsDoc, field.modifiers())) continue;
                    if (firstField) {
                        this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Field Detail" : "Fields");
                        firstField = false;
                    }
                    this.printFieldDetail(field, false);
                }
            }
            if (clsDoc instanceof AnnotationTypeDoc) {
                AnnotationTypeDoc annotationDoc = (AnnotationTypeDoc)clsDoc;
                boolean firstElement = true;
                for (int i5 = 0; i5 < annotationDoc.elementsSorted().length; ++i5) {
                    AnnotationElementDoc elem = annotationDoc.elementsSorted()[i5];
                    if (!HtmlCompiler.isDocAccess(annotationDoc, elem.modifiers())) continue;
                    if (firstElement) {
                        this.printSummaryGroupSeparator(this.options.includeMemberIndex ? "Element Detail" : "Elements");
                        firstElement = false;
                    }
                    this.printAnnotationElementDetail(elem);
                }
            }
        }
    }

    private void printPropertySummary(PropertyDoc doc, boolean isHref) {
        this.printType(doc.type());
        this.w(' ');
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        if (isHref) {
            this.w("</a>");
        }
    }

    private void printPropertyDetail(PropertyDoc doc) {
        this.printMemberBlockStart();
        this.printItemIcons(PROPERTY_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        if (!this.options.moduleBased) {
            this.w("property ");
        }
        this.printPropertySummary(doc, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printActionSummary(ActionDoc doc, boolean isHref) {
        if (doc.returns() != null) {
            this.printType(doc.returns().type());
            this.w(' ');
        }
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        if (isHref) {
            this.w("</a>");
        }
        if (doc.parameter() != null) {
            this.w('(');
            this.printType(doc.parameter().type());
            this.w(' ').w((Object)doc.parameter().name()).w(')');
        } else {
            this.w("()");
        }
    }

    private void printActionDetail(ActionDoc doc) {
        this.printMemberBlockStart();
        this.printItemIcons(ACTION_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        if (!this.options.moduleBased) {
            this.w("action ");
        }
        this.printActionSummary(doc, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printTopicSummary(TopicDoc doc, boolean isHref) {
        this.printType(doc.eventType());
        this.w(' ');
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        if (isHref) {
            this.w("</a>");
        }
    }

    private void printTopicDetail(TopicDoc doc) {
        this.printMemberBlockStart();
        this.printItemIcons(TOPIC_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        if (!this.options.moduleBased) {
            this.w("topic ");
        }
        this.printTopicSummary(doc, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printConstructorSummary(ConstructorDoc doc, boolean isHref) {
        this.printSummaryStart(doc.isDeprecated());
        this.w(doc.modifiersToString());
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        if (isHref) {
            this.w("</a>");
        }
        this.printParams(doc.parameters(), doc.isVarargs());
        this.printSummaryEnd();
    }

    private void printConstructorDetail(ConstructorDoc doc) {
        this.printMemberBlockStart();
        this.printItemIcons(CONSTRUCTOR_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        this.printConstructorSummary(doc, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printMethodSummary(ClassDoc cls, MethodDoc doc, boolean isHref) {
        this.printSummaryStart(doc.isDeprecated());
        this.w(doc.explicitModifiersToString(cls));
        if (doc.typeParams().length > 0) {
            this.w(' ');
            this.w(this.getTypeParamDetails(doc.typeParams()));
            this.w(' ');
        }
        this.printType(doc.returns().type());
        this.w(' ');
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        if (isHref) {
            this.w("</a>");
        }
        this.printParams(doc.parameters(), doc.isVarargs());
        this.printSummaryEnd();
    }

    private void printMethodDetail(ClassDoc cls, MethodDoc doc) {
        this.printMemberBlockStart();
        this.printItemIcons(METHOD_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        this.printMethodSummary(cls, doc, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printFieldSummary(FieldDoc doc, boolean isEnumConstant, boolean isHref) {
        this.printSummaryStart(doc.isDeprecated());
        if (!isEnumConstant) {
            this.w(doc.modifiersToString());
        }
        this.printType(doc.type());
        this.w(' ');
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        if (isHref) {
            this.w("</a>");
        }
        this.printSummaryEnd();
    }

    private void printFieldDetail(FieldDoc doc, boolean isEnumConstant) {
        this.printMemberBlockStart();
        this.printItemIcons(isEnumConstant ? ENUM_CONSTANT_ICON : FIELD_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        this.printFieldSummary(doc, isEnumConstant, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printAnnotationElementSummary(AnnotationElementDoc doc, boolean isHref) {
        this.printSummaryStart(doc.isDeprecated());
        this.printType(doc.returns().type());
        this.w(' ');
        if (isHref) {
            this.w("<a href='#").w((Object)doc.anchor()).w((Object)"'>");
        }
        if (this.options.flattenInheritance) {
            this.printDeclaringClass(doc);
        }
        this.printMemberName(doc.name());
        this.w("()");
        if (isHref) {
            this.w("</a>");
        }
        if (doc.defaultValue() != null) {
            this.w(" default ");
            AnnotationValue value = doc.defaultValue();
            this.printAnnotationValue(value);
        }
        this.printSummaryEnd();
    }

    private void printAnnotationElementDetail(AnnotationElementDoc doc) {
        this.printMemberBlockStart();
        this.printItemIcons(ANNOTATION_ELEM_ICON);
        this.printContentBlockStart();
        this.printMemberAnnotations(doc.annotations());
        this.w("<a name='").w((Object)doc.anchor()).w((Object)"'></a>\n");
        this.printAnnotationElementSummary(doc, false);
        this.printMemberDescription(doc);
        this.printContentBlockEnd();
        this.printMemberBlockEnd();
    }

    private void printMemberDescription(Doc doc) {
        this.w("<div class='doc-description member-description'>\n");
        if (doc.isDeprecated()) {
            Tag deprecatedTag = doc.tag("@deprecated");
            this.printDeprecationNotice(this.descriptionPartsToHtml(deprecatedTag.value()));
        }
        this.printDetails(doc);
        this.w("</div>\n");
    }

    public void printDetails(Doc doc) {
        Tag since;
        ClassDoc cls;
        String description;
        this.w("<dl>\n");
        if (doc instanceof SlotDoc) {
            int flags = ((SlotDoc)doc).flags();
            this.w("<dl><dt>Flags: " + Flags.toDisplayString((int)flags, null) + "</dt></dl>\n");
        }
        if ((description = this.descriptionPartsToHtml(doc.description())) != null) {
            this.w("<dd>\n");
            this.w(description);
            this.w("</dd>\n");
        }
        if (doc instanceof ClassDoc && (cls = (ClassDoc)doc).typeParams().length > 0) {
            this.w("<dl><dt>Type Parameters:</dt>\n");
            this.printTypeParameters(cls.typeParams());
            this.w("</dl>\n");
        }
        if (doc instanceof ExecutableDoc) {
            this.printExecutableDetails((ExecutableDoc)doc);
        }
        if ((since = doc.tag("@since")) != null && since.value() != null) {
            this.w("<dl><dt>Since:</dt><dd>").w((Object)this.descriptionPartsToHtml(since.value())).w((Object)"</dd>\n");
        }
        this.w("</dl>\n");
    }

    private void printExecutableDetails(ExecutableDoc doc) {
        Throws[] exceptions;
        Parameter[] params = doc.parameters();
        if (params.length > 0) {
            this.w("<dl><dt>Parameters:</dt>");
            for (Parameter p : params) {
                this.w("<dd>");
                this.printType(p.type());
                this.w(" ");
                this.w(p.name());
                String d = this.descriptionPartsToHtml(p.description());
                if (d != null) {
                    this.w(" - ").w((Object)d);
                }
                this.w("</dd>\n");
            }
            this.w("</dl>\n");
        }
        if (doc instanceof MethodDoc) {
            Returns r;
            String d;
            MethodDoc methodDoc = (MethodDoc)doc;
            if (methodDoc.typeParams().length > 0) {
                this.w("<dl><dt>Type Parameters:</dt>");
                this.printTypeParameters(methodDoc.typeParams());
                this.w("</dl>\n");
            }
            if ((d = this.descriptionPartsToHtml((r = methodDoc.returns()).description())) != null) {
                this.w("<dl><dt>Returns:</dt>");
                this.w("<dd>").w((Object)d).w((Object)"</dd></dl>\n");
            }
        }
        if ((exceptions = doc.exceptions()).length > 0) {
            this.w("<dl><dt>Exceptions: </dt>");
            for (Throws ex : exceptions) {
                this.w("<dd>");
                this.printType(ex.type());
                String d = this.descriptionPartsToHtml(ex.description());
                if (d != null) {
                    this.w(" - ").w((Object)d);
                }
                this.w("</dd>\n");
            }
            this.w("</dl>\n");
        }
    }

    private void printTypeParameters(JavaTypeVariable[] params) {
        for (JavaTypeVariable v : params) {
            this.w("<dd>&lt;");
            this.printType(v);
            this.w("&gt;\n");
            String d = this.descriptionPartsToHtml(v.description());
            if (d != null) {
                this.w(" - ").w((Object)d);
            }
            this.w("\n</dd>\n");
        }
    }

    private void printThrows(Throws[] exceptions) {
        if (exceptions.length == 0) {
            return;
        }
        this.w(" throws ");
        for (int i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                this.w(", ");
            }
            this.printType(exceptions[i].type());
        }
    }

    private void printParams(Parameter[] params, boolean varargs) {
        this.w("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.w(", ");
            }
            this.printSignatureAnnotations(params[i].annotations());
            this.printType(params[i].type(), varargs && i == params.length - 1);
            this.w(' ');
            this.w(params[i].name());
        }
        this.w(")\n");
    }

    private void printSignatureAnnotations(Annotation[] annotations) {
        if (annotations.length > 0) {
            this.w("<span class='signature-annotation'>");
            for (int i = 0; i < annotations.length; ++i) {
                if (i > 0) {
                    this.w(", ");
                }
                this.w('@');
                this.printType(annotations[i].type());
                AnnotationElement[] elems = annotations[i].elements();
                if (elems.length <= 0) continue;
                this.w('(');
                if (elems.length == 1 && elems[0].isDefaultElement()) {
                    this.w(elems[0].value());
                } else {
                    for (int j = 0; j < elems.length; ++j) {
                        if (j > 0) {
                            this.w(", ");
                        }
                        this.w(elems[j].name()).w((Object)" = ").w((Object)elems[j].value());
                    }
                }
                this.w(')');
            }
            this.w("</span> ");
        }
    }

    private String getTypeParamDetails(JavaTypeVariable[] typeParams) {
        StringBuilder sb = new StringBuilder();
        this.getTypeParamDetails(typeParams, sb);
        return sb.toString();
    }

    private void getTypeParamDetails(JavaTypeVariable[] typeParams, StringBuilder sb) {
        sb.append("&lt;");
        TypeNameFormatter.formatHtml(typeParams, ", ", true, (str, t) -> {
            JavaType type;
            JavaType javaType = type = t.isPresent() ? (JavaType)t.get() : null;
            if (type != null && type.isResolved()) {
                sb.append("<a href='").append(this.getTypeHref((JavaType)t.get())).append("'>").append((String)str).append("</a>");
            } else {
                sb.append((String)str);
            }
        });
        sb.append("&gt;");
    }

    private void printTypePart(String str, Optional<JavaType> type) {
        String href = null;
        if (type.isPresent() && type.get().isResolved()) {
            href = this.getTypeHref(type.get());
        }
        if (href != null) {
            this.w("<a href='").w(href).w((Object)"'>").w((Object)str).w((Object)"</a>");
        } else {
            this.w(str);
        }
    }

    private void printType(JavaType type) {
        this.printType(type, false);
    }

    private void printType(JavaType type, boolean varargsParam) {
        if (type.annotations().length > 0) {
            this.printSignatureAnnotations(type.annotations());
        }
        if (type.isPrimitive() || !type.isResolved()) {
            this.w(type.name());
        } else {
            TypeNameFormatter.formatHtml(new JavaType[]{type}, "", false, (str, t) -> this.printTypePart((String)str, (Optional<JavaType>)t));
        }
        if (varargsParam) {
            this.w("...");
        } else if (type.dimension() > 0) {
            this.w(type.dimensionString());
        }
    }

    public void printSummaryTableStart() {
        this.w("<div class='contents-summary'><table>\n");
    }

    public void printSummaryTableEnd() {
        this.w("</table></div>\n");
    }

    public void printTitleBlockStart(Doc doc, String nameLead, String name, String modulePart, String docModule, boolean deprecated, Annotation[] annotations) {
        this.w("<div class='main-item-header'>\n");
        this.printMainItemAnnotations(annotations);
        this.w("<div class='main-item-title'>\n");
        if (deprecated) {
            this.w("<span class='deprecated'>");
        }
        this.w(nameLead);
        this.w(name);
        if (deprecated) {
            this.w("</span>");
        }
        this.w("</div>\n");
        this.w("<ul class='main-item-info'>\n");
        if (!this.options.moduleBased && !(doc instanceof FrameworkDoc)) {
            this.w("<li><dfn>framework</dfn>");
            this.w("<a href='").w((Object)this.options.htmlBaseUri.getFrameworkHref()).w((Object)"'>");
            this.w("Niagara Framework</a></li>\n");
        }
        if (doc instanceof PackageDoc || doc instanceof ClassDoc) {
            this.w("<li><dfn>module part</dfn>");
            this.w("<a href='").w((Object)this.getModuleHref(modulePart, docModule)).w((Object)"'>").w((Object)modulePart).w((Object)"</a></li>\n");
        }
    }

    public void printTitleBlockEnd() {
        this.w("</ul>\n");
        this.w("</div>\n");
    }

    private void printDeprecationNotice(String text) {
        this.w("<div class='deprecation-notice'>\n");
        this.w("<div class='deprecation-warning'>");
        this.printIcon(DEPRECATED_ICON);
        this.w("&nbsp;<strong>Deprecated</strong></div>\n");
        if (text != null && !text.isEmpty()) {
            this.w("<div class='deprecation-text'>").w((Object)text).w((Object)"</div>\n");
        }
        this.w("</div>\n");
    }

    public String descriptionPartsToHtml(DescriptionPart[] parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        if (parts.length == 1 && parts[0].kind() == DescriptionPart.Kind.TEXT) {
            return parts[0].text();
        }
        StringBuilder sb = new StringBuilder();
        for (DescriptionPart p : parts) {
            if (p.kind() == DescriptionPart.Kind.LINK) {
                String ref = p.value();
                if (ref == null || ref.isEmpty()) continue;
                String fragment = null;
                int pos = ref.indexOf(35);
                if (pos > -1) {
                    fragment = ref.substring(pos);
                    ref = ref.substring(0, pos);
                }
                String href = null;
                if (ref.length() == 0 && fragment != null) {
                    href = fragment;
                } else if (ref.length() > 0) {
                    String lowerCaseRef = ref.toLowerCase();
                    href = lowerCaseRef.startsWith("http:") || lowerCaseRef.startsWith("https:") ? ref : this.getTypeHref(new JavaType(ref, 0, Annotation.none));
                }
                if (href != null) {
                    sb.append("<a href='").append(href);
                    if (fragment != null) {
                        sb.append(fragment);
                    }
                    sb.append("'>").append(p.text()).append("</a>");
                    continue;
                }
                if (!p.text().isEmpty()) {
                    sb.append(p.text());
                    continue;
                }
                sb.append(p.value());
                continue;
            }
            sb.append(p.text());
        }
        return sb.toString();
    }

    public void printHeader(String title) {
        this.printHeader(title, null);
    }

    public void printHeader(String title, Doc d) {
        this.w("<!DOCTYPE html>\n<html>\n<head>\n<title>").w((Object)title).w((Object)"</title>\n");
        if (d != null) {
            this.printMeta(d);
        }
        if (this.options.moduleBased) {
            this.w("<link rel='stylesheet' href='module://help/rc/bajadoc.css' type='text/css'>\n");
            this.w("<script type=\"text/javascript\" src=\"module://web/rc/util/activityMonitor.js\"></script>\n");
            this.w("</head>\n<body onload=\"activityMonitor.start()\">\n");
        } else {
            this.w("<link rel='stylesheet' href='" + this.options.htmlBaseUri.getResourceHref(CSS) + "' type='text/css'>\n");
            this.w("<script src='" + this.options.htmlBaseUri.getResourceHref(JQUERY) + "'></script>\n");
            this.w("<script>\n");
            this.w(HtmlCompiler.getDocumentReadyScript(this.options));
            this.w("</script>\n");
            this.w("</head>\n<body>\n");
        }
    }

    public void printMeta(Doc d) {
        if (d instanceof ClassDoc) {
            ClassDoc c = (ClassDoc)d;
            this.w("<meta name='keywords' content='" + c.qualifiedName() + " " + (c.isInterface() ? "interface" : "class") + "'>\n");
            HashSet<String> slots = new HashSet<String>();
            for (PropertyDoc propertyDoc : c.properties()) {
                this.w("<meta name='keywords' content='" + propertyDoc.name() + " property'>\n");
                slots.add(propertyDoc.name());
            }
            for (SlotDoc slotDoc : c.actions()) {
                this.w("<meta name='keywords' content='" + slotDoc.name() + "() action'>\n");
                slots.add(slotDoc.name());
            }
            for (SlotDoc slotDoc : c.topics()) {
                this.w("<meta name='keywords' content='" + slotDoc.name() + " topic'>\n");
                slots.add(slotDoc.name());
            }
            for (MemberDoc memberDoc : c.methods()) {
                if (slots.contains(memberDoc.name())) continue;
                this.w("<meta name='keywords' content='" + memberDoc.name() + "()'>\n");
            }
            for (MemberDoc memberDoc : c.fields()) {
                if (slots.contains(memberDoc.name())) continue;
                this.w("<meta name='keywords' content='" + memberDoc.name() + "'>\n");
            }
        } else if (d instanceof PackageDoc) {
            PackageDoc p = (PackageDoc)d;
            this.w("<meta name='keywords' content='" + p.name() + " package'>\n");
        } else if (d instanceof ModuleDoc) {
            ModuleDoc m = (ModuleDoc)d;
            this.w("<meta name='keywords' content='" + m.name() + " module'>\n");
        } else if (d instanceof FrameworkDoc) {
            FrameworkDoc f = (FrameworkDoc)d;
            this.w("<meta name='keywords' content='Overview, Niagara Framework, " + f.frameworkVersion() + "<br>API Specification'>\n");
        }
    }

    public static String getDocumentReadyScript(BajadocHtmlCompilerOptions opts) {
        StringBuilder sb = new StringBuilder();
        sb.append("if (window.jQuery) {\n$(document).ready(function() {\n");
        if (opts.includeExpansionToggle) {
            sb.append("  $('.doc-description').hide();\n  $('.expanded-member').hide();\n  $('.expand-doc').click(function(e) {\n    $(this).closest('.doc-container').find('.doc-description').toggle();\n    $(this).children('.expanded-member').toggle();\n    $(this).children('.closed-member').toggle();\n    e.preventDefault();\n  });\n  window.niagara = window.niagara || {};\n  window.niagara.bajadoc = window.niagara.bajadoc || {\n    expandAll: function() {\n      $('.doc-description').show();\n      $('.expanded-member').show();\n      $('.closed-member').hide();\n    },\n    collapseAll: function() {\n      $('.doc-description').hide();\n      $('.expanded-member').hide();\n      $('.closed-member').show();\n    }\n  };\n");
        }
        sb.append("  $('.expanded-subclass').hide();\n  $('.subclass').hide().first().show();\n  $('.expand-subclass').click(function(e) {\n    $(this).closest('.subclass').children('.subclass').toggle();\n    $(this).children('.expanded-subclass').toggle();\n    $(this).children('.closed-subclass').toggle();\n    e.preventDefault();\n  });\n});}\n");
        return sb.toString();
    }

    public void printFooter() {
        this.w("</body></html>\n");
    }

    private void printMainItemDocStart() {
        this.w("<div class='doc-container main-item-doc'>\n");
    }

    private void printMainItemDocEnd() {
        this.w("</div>\n");
    }

    private void printMainItemDescriptionStart() {
        this.w("<div class='doc-description main-item-description'>\n");
    }

    private void printMainItemDescriptionEnd() {
        this.w("</div>\n");
    }

    private void printTitleBlockItem(String name, String value) {
        this.printTitleBlockItemStart(name);
        this.w(value);
        this.printTitleBlockItemEnd();
    }

    private void printTitleBlockItemStart(String name) {
        this.w("<li><dfn>").w((Object)name).w((Object)"</dfn>");
    }

    private void printTitleBlockItemEnd() {
        this.w("</li>\n");
    }

    private void printSummaryGroupSeparator(String text) {
        this.w("<div class='summary-group'>").w((Object)text).w((Object)"</div>\n");
    }

    private void printMemberBlockStart() {
        this.w("<div class='doc-container member-doc'>\n");
    }

    private void printItemIcons(String icon) {
        if (this.options.includeIcons || this.options.includeExpansionToggle) {
            this.w("<div class='icon-container'>\n");
            if (this.options.includeExpansionToggle) {
                this.w("<a class='expand-doc'>");
                this.printIcon(CLOSED_ICON, "closed-member");
                this.printIcon(EXPANDED_ICON, "expanded-member");
                this.w("</a>\n");
            }
            if (this.options.includeIcons && icon != null) {
                this.printIcon(icon);
            }
            this.w("</div>\n");
        }
    }

    private void printMemberBlockEnd() {
        this.w("</div>\n");
        if (this.options.includeMemberIndex) {
            this.w("<hr>\n");
        }
    }

    private void printContentBlockStart() {
        this.w("<div class='doc-content-container'>\n");
    }

    private void printContentBlockEnd() {
        this.w("</div>\n");
    }

    private void printIcon(String icon) {
        this.printIcon(icon, null);
    }

    private void printIcon(String icon, String cls) {
        if (icon != null) {
            if (this.options.moduleBased) {
                this.w("<img src='module://icons/").w((Object)icon).w((Object)"' style='vertical-align:middle'");
            } else {
                this.w("<img src='").w((Object)this.options.htmlBaseUri.getResourceHref(icon)).w((Object)"' style='vertical-align:middle'");
            }
            if (cls != null) {
                this.w("class='").w((Object)cls).w('\'');
            }
            this.w("/>\n");
        }
    }

    private void printDeclaringClass(MemberDoc doc) {
        if (doc.declaringClass() != null) {
            this.w(doc.declaringClass().name()).w((Object)".");
        }
    }

    private void printMemberName(String name) {
        this.w("<span class='member-name'>").w((Object)name).w((Object)"</span>");
    }

    private void printSummaryStart(boolean deprecated) {
        this.w("<span class='member-summary");
        if (deprecated) {
            this.w(" deprecated");
        }
        this.w("'>\n");
    }

    private void printSummaryEnd() {
        this.w("</span>");
    }

    private void printMainItemAnnotations(Annotation[] annotations) {
        this.printAnnotationList(annotations, "annotations main-item-annotations");
    }

    private void printMemberAnnotations(Annotation[] annotations) {
        this.printAnnotationList(annotations, "annotations member-annotations");
    }

    private void printAnnotationList(Annotation[] annotations, String style) {
        if (annotations.length > 0) {
            this.w("<ul class='").w((Object)style).w((Object)"'>\n");
            for (int i = 0; i < annotations.length; ++i) {
                this.w("<li>");
                this.printAnnotation(annotations[i]);
                this.w("</li>\n");
            }
            this.w("</ul>\n");
        }
    }

    private void printAnnotation(Annotation annotation) {
        this.printAnnotation(annotation, 0);
    }

    private void printAnnotation(Annotation annotation, int indent) {
        for (int i = 0; i < indent; ++i) {
            this.w("&nbsp;");
        }
        this.w("@");
        this.printType(annotation.type());
        AnnotationElement[] elements = annotation.elements();
        if (elements.length > 0) {
            this.w("(");
            for (int i = 0; i < elements.length; ++i) {
                AnnotationElement elem;
                if (i > 0) {
                    this.w(", ");
                }
                if ((elem = elements[i]).value() == null) continue;
                if (!"value".equals(elem.name())) {
                    this.w(elem.name()).w((Object)" = ");
                }
                this.printAnnotationValue(elem.value(), indent);
            }
            this.w(")");
        }
    }

    private void printAnnotationValue(AnnotationValue value) {
        this.printAnnotationValue(value, 0);
    }

    private void printAnnotationValue(AnnotationValue value, int indent) {
        if (value instanceof AnnotationValue.Enum) {
            AnnotationValue.Enum e = (AnnotationValue.Enum)value;
            this.printType(e.type());
            this.w(".").w((Object)e.field());
        } else if (value instanceof AnnotationValue.Type) {
            this.printType(((AnnotationValue.Type)value).type());
            this.w(".class");
        } else if (value instanceof AnnotationValue.Expression) {
            this.safe(((AnnotationValue.Expression)value).expression());
        } else if (value instanceof AnnotationValue.AnnotationInstance) {
            if (indent > 0) {
                this.w("<br>");
            }
            this.printAnnotation(((AnnotationValue.AnnotationInstance)value).annotation(), indent + 2);
        } else if (value instanceof AnnotationValue.Array) {
            this.w("{ ");
            AnnotationValue[] array = ((AnnotationValue.Array)value).values();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    this.w(", ");
                }
                this.printAnnotationValue(array[i], indent + 2);
            }
            this.w(" }");
        }
    }

    private static boolean isDocAccess(ClassDoc cls, int modifiers) {
        return cls.isInterface() || Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    private String getModuleHref(String modulePart, String docModule) {
        if (this.options.moduleBased) {
            return "local:|module://" + docModule + "/doc/" + modulePart + "/module-index.bajadoc";
        }
        return this.options.htmlBaseUri.getModuleHref(modulePart);
    }

    private String getPackageHref(String modulePart, String pkgName, String docModule) {
        if (this.options.moduleBased) {
            return "local:|module://" + docModule + "/doc/" + modulePart + '/' + pkgName.replace('.', '/') + "/package-index.bajadoc";
        }
        return this.options.htmlBaseUri.getPackageHref(pkgName);
    }

    private String getTypeHref(String modulePart, ClassSummary summary, String docModule) {
        if (this.options.moduleBased) {
            return "local:|module://" + docModule + "/doc/" + modulePart + '/' + summary.packageName().replace('.', '/') + '/' + summary.name() + ".bajadoc";
        }
        return this.options.htmlBaseUri.getTypeHref(summary.packageName(), summary.name());
    }

    private String getTypeHref(JavaType type) {
        if (type == null) {
            return null;
        }
        if (!type.isResolved()) {
            return null;
        }
        return this.getTypeHref(type.packageName(), type.name());
    }

    private String getTypeHref(String packageName, String className) {
        return this.options.moduleBased ? HtmlCompiler.bajadocOrd(packageName, className) : this.options.htmlBaseUri.getTypeHref(packageName, className);
    }

    public static String bajadocOrd(String packageName, String className) {
        BajadocIndex.Entry entry = BajadocIndex.instance().getFirstEntry(packageName + '.' + className, Optional.empty());
        if (entry != null) {
            return entry.ordString();
        }
        return null;
    }

    public UriPath getBase() {
        return this.options.htmlBaseUri;
    }

    protected static Resource[] getResources() {
        return new Resource[]{new Resource("module://help/rc", CSS), new Resource("module://js/rc", JQUERY), new Resource(ICONS_BASE, PROPERTY_ICON), new Resource(ICONS_BASE, ACTION_ICON), new Resource(ICONS_BASE, TOPIC_ICON), new Resource(ICONS_BASE, CONSTRUCTOR_ICON), new Resource(ICONS_BASE, METHOD_ICON), new Resource(ICONS_BASE, FIELD_ICON), new Resource(ICONS_BASE, ENUM_CONSTANT_ICON), new Resource(ICONS_BASE, ANNOTATION_ELEM_ICON), new Resource(ICONS_BASE, FRAMEWORK_ICON), new Resource(ICONS_BASE, MODULE_ICON), new Resource(ICONS_BASE, PACKAGE_ICON), new Resource(ICONS_BASE, CLASS_ICON), new Resource(ICONS_BASE, EXPANDED_ICON), new Resource(ICONS_BASE, CLOSED_ICON), new Resource(ICONS_BASE, DEPRECATED_ICON)};
    }

    protected static class Resource {
        private BOrd ord;
        private String path;

        public Resource(String base, String path) {
            this.path = path;
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            this.ord = BOrd.make((String)(base + path));
        }

        public String getPath() {
            return this.path;
        }

        public BOrd getOrd() {
            return this.ord;
        }
    }

    public static class BajadocHtmlCompilerOptions {
        private final boolean moduleBased;
        private final UriPath htmlBaseUri;
        private final String extension;
        private boolean flattenInheritance;
        private boolean showBajaOnly;
        private boolean includeExpansionToggle;
        private boolean includeMemberIndex;
        private boolean includeSubclassHierarchy;
        private boolean includeIcons;

        public BajadocHtmlCompilerOptions(BBajadocOptions wbOptions) {
            this.flattenInheritance = wbOptions.getFlattenInheritance();
            this.showBajaOnly = wbOptions.getShowBajaOnly();
            this.htmlBaseUri = null;
            this.moduleBased = true;
            this.extension = "bajadoc";
        }

        public BajadocHtmlCompilerOptions() {
            this.htmlBaseUri = null;
            this.moduleBased = true;
            this.extension = "bajadoc";
        }

        public BajadocHtmlCompilerOptions(UriPath htmlBaseUri) {
            this.htmlBaseUri = htmlBaseUri;
            this.moduleBased = false;
            this.extension = "html";
        }

        public void setFlattenInheritance(boolean flatten) {
            this.flattenInheritance = flatten;
        }

        public void setBajaOnly(boolean bajaOnly) {
            this.showBajaOnly = bajaOnly;
        }

        public void setIncludeExpansionToggle(boolean include) {
            this.includeExpansionToggle = include;
        }

        public void setIncludeMemberIndex(boolean include) {
            this.includeMemberIndex = include;
        }

        public void setIncludeSubclassHierarchy(boolean include) {
            this.includeSubclassHierarchy = include;
        }

        public void setIncludeIcons(boolean include) {
            this.includeIcons = include;
        }
    }
}

