/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.Tag;
import com.tridium.help.bajadoc.Throws;

public abstract class ExecutableDoc
extends MemberDoc {
    protected Parameter[] parameters;
    protected Throws[] exceptions;
    protected boolean isVarargs;
    private String anchor;

    protected ExecutableDoc(String name, int modifiers, boolean isVarargs, Parameter[] parameters, Throws[] exceptions, DescriptionPart[] description, Tag[] tags, Annotation[] annotations) {
        super(name, modifiers, description, tags, annotations);
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.isVarargs = isVarargs;
    }

    public Parameter[] parameters() {
        return this.parameters;
    }

    public Throws[] exceptions() {
        return this.exceptions;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    @Override
    public String anchor() {
        if (this.anchor == null) {
            StringBuffer s = new StringBuffer(this.name);
            s.append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                JavaType t = this.parameters[i].type();
                s.append(t.qualifiedName());
                if (t.dimension() <= 0) continue;
                s.append(t.dimensionString());
            }
            s.append(')');
            this.anchor = s.toString();
        }
        return this.anchor;
    }

    public String parametersToString() {
        StringBuffer s = new StringBuffer();
        s.append('(');
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.parameters[i].type).append(' ').append(this.parameters[i].name);
        }
        s.append(')');
        return s.toString();
    }

    public String exceptionsToString() {
        if (this.exceptions.length == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer(" throws ");
        for (int i = 0; i < this.exceptions.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.exceptions[i]);
        }
        return s.toString();
    }
}

