/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.DescriptionPart;
import javax.baja.nre.util.TextUtil;

public abstract class Description {
    public Object pickle;
    protected DescriptionPart[] description;
    protected String summary;

    protected Description(DescriptionPart[] parts) {
        this.description = parts;
        this.summary = Description.parseSummary(parts);
    }

    public DescriptionPart[] description() {
        return this.description;
    }

    public String summary() {
        return this.summary;
    }

    public void setDescription(DescriptionPart[] d) {
        this.description = d;
        this.summary = Description.parseSummary(d);
    }

    public static String parseSummary(DescriptionPart[] pieces) {
        String description;
        if (pieces.length == 0 || pieces.length == 1 && pieces[0].text().isEmpty()) {
            return "";
        }
        String summary = description = Description.getStringForSummary(pieces);
        int dot = 0;
        while ((dot = description.indexOf(46, dot + 1)) >= 0 && dot < description.length() - 1) {
            if (!Character.isWhitespace(description.charAt(dot + 1))) continue;
            summary = description.substring(0, dot + 1);
            break;
        }
        summary = TextUtil.stripMarkup((String)summary);
        char[] buf = summary.toCharArray();
        StringBuffer s = new StringBuffer();
        boolean lastWasSpace = true;
        for (int i = 0; i < buf.length; ++i) {
            char c = buf[i];
            if (Character.isWhitespace(c)) {
                if (!lastWasSpace) {
                    s.append(' ');
                }
                lastWasSpace = true;
                continue;
            }
            s.append(c);
            lastWasSpace = false;
        }
        return s.toString();
    }

    private static String getStringForSummary(DescriptionPart[] description) {
        StringBuilder sb = new StringBuilder();
        for (DescriptionPart p : description) {
            if (p.kind() == DescriptionPart.Kind.TEXT) {
                sb.append(p.text());
                continue;
            }
            if (p.kind() != DescriptionPart.Kind.LINK) continue;
            if (!p.text().isEmpty()) {
                sb.append(p.text());
                continue;
            }
            sb.append(p.value());
        }
        return sb.toString();
    }
}

