/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.Hierarchy;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.JavaType;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HierarchyBuilder {
    private final Map<Hierarchy.Entry, Hierarchy.Entry> upwards = new HashMap<Hierarchy.Entry, Hierarchy.Entry>();
    private final Map<Hierarchy.Entry, List<Hierarchy.Entry>> downwards = new HashMap<Hierarchy.Entry, List<Hierarchy.Entry>>();

    public void loadBajadoc(Doc doc, Map<String, String> qnamesToModulePart) throws Exception {
        if (doc instanceof ClassDoc) {
            ClassDoc c = (ClassDoc)doc;
            JavaType s = c.superClass();
            if (s == null) {
                this.upwards.put(new Hierarchy.Entry(c.modulePart(), c.packageName(), c.name()), new Hierarchy.Entry());
                Hierarchy.Entry root = new Hierarchy.Entry(c.modulePart(), c.packageName(), c.name());
                this.downwardsPut(new Hierarchy.Entry(), root);
            } else {
                String m = qnamesToModulePart.getOrDefault(s.qualifiedName(), "");
                this.upwards.put(new Hierarchy.Entry(c.modulePart(), c.packageName(), c.name()), new Hierarchy.Entry(m, s.packageName(), s.name()));
                this.downwardsPut(new Hierarchy.Entry(m, s.packageName(), s.name()), new Hierarchy.Entry(c.modulePart(), c.packageName(), c.name()));
            }
        }
    }

    private void downwardsPut(Hierarchy.Entry a, Hierarchy.Entry b) {
        List<Hierarchy.Entry> list = this.downwards.get(a);
        if (list == null) {
            list = new ArrayList<Hierarchy.Entry>();
            this.downwards.put(a, list);
        }
        list.add(b);
    }

    private void dump(Writer writer, Hierarchy.Entry key, int indent) throws Exception {
        List<Hierarchy.Entry> list = this.downwards.get(key);
        if (list == null) {
            if (!key.isRoot) {
                for (int i = 0; i < indent; ++i) {
                    writer.write("  ");
                }
                HierarchyBuilder.writeEntryElem(writer, key, true);
            }
        } else {
            int n = indent;
            if (!key.isRoot) {
                ++n;
                for (int i = 0; i < indent; ++i) {
                    writer.write("  ");
                }
                HierarchyBuilder.writeEntryElem(writer, key, false);
            }
            for (Hierarchy.Entry item : list) {
                this.dump(writer, item, n);
            }
            if (!key.isRoot) {
                for (int i = 0; i < indent; ++i) {
                    writer.write("  ");
                }
                writer.write("</c>\n");
            }
        }
    }

    private static void writeEntryElem(Writer writer, Hierarchy.Entry key, boolean empty) throws IOException {
        writer.write("<c m=\"" + key.modulePart + "\" p=\"" + key.pkg + "\" n=\"" + key.name);
        if (empty) {
            writer.write("\"/>\n");
        } else {
            writer.write("\">\n");
        }
    }

    public void persist() throws Exception {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(Hierarchy.FILE));){
            this.persist(writer);
        }
    }

    public void persist(Writer writer) throws Exception {
        for (Hierarchy.Entry key : this.downwards.keySet()) {
            List<Hierarchy.Entry> list = this.downwards.get(key);
            Collections.sort(list);
        }
        HashSet<Hierarchy.Entry> roots = new HashSet<Hierarchy.Entry>(this.upwards.values());
        roots.removeAll(this.upwards.keySet());
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<hierarchy>\n");
        ArrayList<Hierarchy.Entry> rootList = new ArrayList<Hierarchy.Entry>(roots);
        Collections.sort(rootList);
        for (Hierarchy.Entry root : rootList) {
            this.dump(writer, root, 1);
        }
        writer.write("</hierarchy>\n");
    }
}

