/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.HelpSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.PatternFilter;

public final class BajadocIndex {
    private final Map<String, Entry> qnames = new HashMap<String, Entry>();
    private Tag[] tags;
    private static BajadocIndex instance;

    private BajadocIndex() {
    }

    public static synchronized BajadocIndex instance() {
        if (instance == null) {
            instance = new BajadocIndex();
        }
        return instance;
    }

    public Entry getFirstEntry(String pattern, Optional<String> modulePart) {
        Entry[] entries = this.getEntries(pattern, modulePart);
        if (entries != null && entries.length > 0) {
            return entries[0];
        }
        return null;
    }

    public Entry[] getEntries(String pattern, Optional<String> modulePart) {
        if (!this.ensureTagsLoaded()) {
            return null;
        }
        Entry[] entries = this.lookup(pattern);
        if (entries == null || entries.length == 0) {
            return null;
        }
        if (!modulePart.isPresent()) {
            return entries;
        }
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Entry entry : entries) {
            if (!modulePart.get().equals(entry.modulePart)) continue;
            list.add(entry);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Entry[list.size()]);
    }

    public Entry[] getEntries(String pkg, String cls, Optional<String> modulePart) {
        Entry[] entries = this.getEntries(cls, modulePart);
        if (entries == null) {
            return null;
        }
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Entry entry : entries) {
            if (!pkg.equals(entry.pkg)) continue;
            list.add(entry);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Entry[list.size()]);
    }

    private Entry[] lookup(String pattern) {
        if (this.qnames.containsKey(pattern)) {
            return new Entry[]{this.qnames.get(pattern)};
        }
        PatternFilter filter = new PatternFilter(pattern);
        ArrayList arr = new ArrayList();
        for (Tag tag : this.tags) {
            if (!filter.accept(tag.name)) continue;
            Collections.addAll(arr, tag.entries);
        }
        return arr.toArray(new Entry[arr.size()]);
    }

    private synchronized boolean ensureTagsLoaded() {
        if (!HelpSystem.exists()) {
            return false;
        }
        try {
            if (this.tags == null) {
                this.loadAllEntries();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    synchronized void helpCreated() {
        this.tags = null;
        this.qnames.clear();
    }

    private void loadAllEntries() throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                ArrayList<Tag> arr = new ArrayList<Tag>();
                try (BufferedReader in = new BufferedReader(new FileReader(new File(HelpSystem.HELP, "bajadoc.dat")));){
                    String str = in.readLine();
                    while (str != null) {
                        Entry[] entries;
                        int n = str.indexOf(124);
                        for (Entry e : entries = BajadocIndex.loadEntries(TextUtil.split((String)str.substring(n + 1), (char)';'))) {
                            if (e.cls == null) continue;
                            this.qnames.put(e.pkg + '.' + e.cls, e);
                        }
                        arr.add(new Tag(str.substring(0, n), entries));
                        str = in.readLine();
                    }
                    this.tags = arr.toArray(new Tag[arr.size()]);
                    Void void_ = null;
                    return void_;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
            if (pae.getException() instanceof IOException) {
                throw (IOException)pae.getException();
            }
            throw new BajaRuntimeException((Throwable)pae.getException());
        }
    }

    private static Entry[] loadEntries(String[] str) {
        Entry[] entries = new Entry[str.length];
        for (int i = 0; i < str.length; ++i) {
            entries[i] = new Entry(TextUtil.split((String)str[i], (char)':'));
        }
        return entries;
    }

    public static class Entry {
        String docModule;
        String modulePart;
        String pkg;
        String cls;

        Entry(String docModule, String modulePart, String pkg, String cls) {
            if (pkg == null && cls != null) {
                throw new IllegalStateException();
            }
            this.docModule = docModule.intern();
            this.modulePart = modulePart.intern();
            this.pkg = pkg == null ? null : pkg.intern();
            this.cls = cls == null ? null : cls.intern();
        }

        private Entry(String[] tokens) {
            if (tokens.length > 0 && tokens[0] != null && !tokens[0].isEmpty()) {
                this.modulePart = tokens[0].intern();
            }
            if (tokens.length > 1 && tokens[1] != null && !tokens[1].isEmpty()) {
                this.pkg = tokens[1].intern();
            }
            if (tokens.length > 2 && tokens[2] != null && !tokens[2].isEmpty()) {
                this.cls = tokens[2].intern();
            }
            if (tokens.length > 3 && tokens[3] != null && !tokens[3].isEmpty()) {
                this.docModule = tokens[3].intern();
            }
        }

        public String docModule() {
            return this.docModule;
        }

        public BOrd toOrd() {
            return BOrd.make((String)this.ordString());
        }

        public String ordString() {
            if (this.pkg == null) {
                return String.format("local:|module://%s/doc/%s/module-index.bajadoc", this.docModule, this.modulePart);
            }
            String pkgPath = this.pkg.replace('.', '/');
            return this.cls == null ? String.format("local:|module://%s/doc/%s/%s/package-index.bajadoc", this.docModule, this.modulePart, pkgPath) : String.format("local:|module://%s/doc/%s/%s/%s.bajadoc", this.docModule, this.modulePart, pkgPath, this.cls);
        }

        String encodeForIndex() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.modulePart).append(':');
            if (this.pkg != null) {
                sb.append(this.pkg);
            }
            sb.append(':');
            if (this.cls != null) {
                sb.append(this.cls);
            }
            sb.append(':');
            sb.append(this.docModule);
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.modulePart);
            if (this.pkg != null) {
                sb.append(':').append(this.pkg);
                sb.append(':');
                if (this.cls != null) {
                    sb.append(this.cls);
                }
            }
            return sb.toString();
        }
    }

    static class Tag {
        String name;
        Entry[] entries;

        Tag(String name, Entry[] entries) {
            this.name = name;
            this.entries = entries;
        }
    }
}

