/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.basicdriver.util.BBasicWorker;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;

public class BPointLiveScanOptionsPane
extends BEdgePane {
    public static final Property backgroundWorker = BPointLiveScanOptionsPane.newProperty((int)0, (BValue)new BBasicWorker(), null);
    public static final Action updatedScanLimit = BPointLiveScanOptionsPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPointLiveScanOptionsPane.class);
    private Object updateScanLimitTxtLock = new Object();
    private BLabel referToManual = new BLabel();
    private BLabel scanLimit = new BLabel(MbusToolkit.getText((String)"BPointDiscoveryModeSelectPane.scanLimitLabel"));
    private BLabel worstCaseScanTime = new BLabel(MbusToolkit.lex.getText("BPointDiscoveryModeSelectPane.worstCaseScanTime", new Object[]{"???"}));
    private BFacets maxReadsFacets = BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)1000), BInteger.make((int)5)});
    private BIntegerFE maxReadsFE = new BIntegerFE();
    private BLink maxReadsSetModifiedLink = null;
    private BMbusDevice deviceRef = null;

    public BBasicWorker getBackgroundWorker() {
        return (BBasicWorker)this.get(backgroundWorker);
    }

    public void setBackgroundWorker(BBasicWorker v) {
        this.set(backgroundWorker, (BValue)v, null);
    }

    public void updatedScanLimit() {
        this.invoke(updatedScanLimit, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPointLiveScanOptionsPane() {
        this.init();
    }

    private void init() {
        BGridPane coreItems = new BGridPane();
        coreItems.setColumnCount(2);
        coreItems.add(null, (BValue)this.scanLimit);
        this.maxReadsFE.loadValue((BObject)BInteger.make((int)10), (Context)this.maxReadsFacets);
        coreItems.add("maxReadsFE", (BValue)this.maxReadsFE);
        this.maxReadsSetModifiedLink = this.linkTo((BComponent)this.maxReadsFE, (Slot)BIntegerFE.setModified, (Slot)updatedScanLimit);
        this.setTop((BWidget)this.referToManual);
        this.setCenter((BWidget)coreItems);
        this.setBottom((BWidget)this.worstCaseScanTime);
        this.referToManual.setWordWrapEnabled(true);
    }

    public void started() throws Exception {
        BWidget.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BPointLiveScanOptionsPane.this.referToManual.setText(MbusToolkit.getText((String)"BPointDiscoveryModeSelectPane.referToManualForTelegramCount"));
                BPointLiveScanOptionsPane.this.referToManual.relayoutSync();
                BPointLiveScanOptionsPane.this.referToManual.getParentWidget().relayoutSync();
                BPointLiveScanOptionsPane.this.doUpdatedScanLimit();
            }
        });
        super.started();
    }

    protected void setDeviceRef(BOrd deviceRefOrd) {
        if (deviceRefOrd != null && !deviceRefOrd.isNull()) {
            this.deviceRef = (BMbusDevice)deviceRefOrd.get();
        }
    }

    public int getMaximumReadsLimit() {
        try {
            return ((BInteger)this.maxReadsFE.saveValue()).getInt();
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected boolean validate() {
        try {
            this.maxReadsFE.saveValue();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdatedScanLimit() {
        Object object = this.updateScanLimitTxtLock;
        synchronized (object) {
            BInteger maxReadsValue = null;
            try {
                this.maxReadsSetModifiedLink.deactivate();
                maxReadsValue = (BInteger)this.maxReadsFE.saveValue();
                this.maxReadsSetModifiedLink.activate();
            }
            catch (Exception e) {
                this.maxReadsSetModifiedLink.activate();
                this.getBackgroundWorker().post(new Runnable(){

                    @Override
                    public void run() {
                        BPointLiveScanOptionsPane.this.worstCaseScanTime.setText(MbusToolkit.lex.getText("BPointDiscoveryModeSelectPane.worstCaseScanTime", new Object[]{"???"}));
                    }
                });
                return;
            }
            if (maxReadsValue.getInt() == 0 || this.deviceRef == null) {
                this.worstCaseScanTime.setText(MbusToolkit.lex.getText("BPointDiscoveryModeSelectPane.worstCaseScanTime", new Object[]{"???"}));
            } else {
                final BInteger maxReadsValueFinal = maxReadsValue;
                this.getBackgroundWorker().post(new Runnable(){

                    @Override
                    public void run() {
                        BRelTime approxTimeExpected = BPointLiveScanOptionsPane.this.deviceRef.calculateTimeForConcurrentReads(maxReadsValueFinal);
                        BPointLiveScanOptionsPane.this.worstCaseScanTime.setText(MbusToolkit.lex.getText("BPointDiscoveryModeSelectPane.worstCaseScanTime", new Object[]{approxTimeExpected}));
                    }
                });
            }
        }
    }
}

