/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BMbusSecondaryAddressFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BMbusSecondaryAddressFE.class);
    protected BTextField manuField = new BTextField();
    protected BMbusDeviceTypeId deviceIdField = BMbusDeviceTypeId.reserved;
    protected BTextField versionField = new BTextField();
    protected BWbFieldEditor deviceIdEditor = BWbFieldEditor.makeFor((BObject)this.deviceIdField);
    protected BLabel manuText = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.ManId", "Manufacturer ID       "), BHalign.left);
    protected BLabel devIdText = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.DevId", "Device ID or Medium   "), BHalign.left);
    protected BLabel versionText = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.VerNo", "Version Number        "), BHalign.left);
    protected static final Lexicon lex = Lexicon.make(BMbusSecondaryAddressFE.class);

    public Type getType() {
        return TYPE;
    }

    public BMbusSecondaryAddressFE() {
        this(true);
    }

    public BMbusSecondaryAddressFE(boolean setupContent) {
        this.deviceIdEditor.loadValue((BObject)BMbusDeviceTypeId.reserved);
        if (setupContent) {
            BGridPane pane = new BGridPane();
            pane.setColumnAlign(BHalign.left);
            pane.setColumnGap(4.0);
            pane.add(null, (BValue)this.manuText);
            pane.add(null, (BValue)this.manuField);
            pane.add(null, (BValue)this.devIdText);
            pane.add(null, (BValue)this.deviceIdEditor);
            pane.add(null, (BValue)this.versionText);
            pane.add(null, (BValue)this.versionField);
            this.linkTo((BComponent)this.manuField, (Slot)BTextEditor.textModified, (Slot)setModified);
            this.linkTo((BComponent)this.versionField, (Slot)BTextEditor.textModified, (Slot)setModified);
            if (this.deviceIdEditor.getTopic(BTextEditor.textModified.getName()) != null) {
                this.linkTo((BComponent)this.deviceIdEditor, (Slot)BTextEditor.textModified, (Slot)setModified);
            }
            this.setContent((BWidget)pane);
        }
    }

    public void doLoadValue(BObject value, Context context) throws Exception {
        this.manuField.setEditable(!this.isReadonly());
        this.versionField.setEditable(!this.isReadonly());
        BMbusSecondaryAddressFilters filters = (BMbusSecondaryAddressFilters)value;
        this.manuField.setText(filters.getManufacturer());
        this.versionField.setText(String.valueOf(filters.getVersionNumber()));
    }

    public BObject doSaveValue(BObject value, Context context) throws CannotSaveException, Exception {
        String manufacturer = "";
        BMbusDeviceTypeId deviceTypeId = BMbusDeviceTypeId.reserved;
        int versionNumber = 0;
        BMbusSecondaryAddressFilters r = (BMbusSecondaryAddressFilters)value;
        if (r != null) {
            if (this.manuField.getText().length() >= 3) {
                manufacturer = this.manuField.getText().substring(0, 3).toUpperCase();
            }
            deviceTypeId = (BMbusDeviceTypeId)this.deviceIdEditor.saveValue();
            try {
                versionNumber = Integer.parseInt(this.versionField.getText());
            }
            catch (NumberFormatException e) {
                MbusToolkit.error((String)"Error parsing version number", (Throwable)e);
                throw new CannotSaveException(lex.getText("mbusPrimaryAddressRangeFE.invalidVersionNumber"), (Throwable)e);
            }
        }
        r.setManufacturer(manufacturer);
        r.setDeviceTypeId(deviceTypeId);
        r.setVersionNumber(versionNumber);
        return r;
    }

    protected void doSetReadonly(boolean readonly) {
        this.manuField.setEditable(!readonly);
        this.versionField.setEditable(!readonly);
    }
}

