/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BGridPane;

public class BDiscoveryModeSelectPane
extends BGridPane {
    public static final Action modeChanged = BDiscoveryModeSelectPane.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BDiscoveryModeSelectPane.class);
    private DiscoveryModeListener modeListener = null;
    private ToggleCommandGroup<ToggleCommand> selectionGroup = new ToggleCommandGroup();
    private BRadioButton scanDeviceDatabaseButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryModeSelectPane.scanDeviceDatabaseButton"));
    private BRadioButton addressDiscoverButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryModeSelectPane.addressDiscoverButton"));
    private BRadioButton singleDeviceButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryModeSelectPane.singleDeviceButton"));
    private BRadioButton secondaryDiscoverButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryModeSelectPane.secondaryDiscoverButton"));
    private BRadioButton secondaryAddressSetupButton = new BRadioButton(this.selectionGroup, MbusToolkit.getText((String)"BDiscoveryModeSelectPane.secondaryAddressDiscoverButton"));

    public void modeChanged(BWidgetEvent event) {
        this.invoke(modeChanged, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDiscoveryModeSelectPane() {
        this.init();
    }

    public BDiscoveryModeSelectPane(DiscoveryModeListener modeListener) {
        this.modeListener = modeListener;
        this.init();
    }

    private void init() {
        this.setColumnCount(1);
        this.add(null, (BValue)this.scanDeviceDatabaseButton);
        this.add(null, (BValue)this.addressDiscoverButton);
        this.add(null, (BValue)this.singleDeviceButton);
        this.add(null, (BValue)this.secondaryDiscoverButton);
        this.add(null, (BValue)this.secondaryAddressSetupButton);
        this.linkTo("scanDeviceDatabaseModeLink", (BComponent)this.scanDeviceDatabaseButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.linkTo("addressModeLink", (BComponent)this.addressDiscoverButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.linkTo("singleModeLink", (BComponent)this.singleDeviceButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.linkTo("secondaryModeLink", (BComponent)this.secondaryDiscoverButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.linkTo("secondaryDirectModeLink", (BComponent)this.secondaryAddressSetupButton, (Slot)BAbstractButton.actionPerformed, (Slot)modeChanged);
        this.scanDeviceDatabaseButton.setSelected(true);
    }

    public void doModeChanged(BWidgetEvent event) {
        if (this.modeListener != null) {
            this.modeListener.modeChanged();
        }
    }

    boolean isSingleDeviceDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.singleDeviceButton.getText());
    }

    boolean isScanDeviceDatabaseDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.scanDeviceDatabaseButton.getText());
    }

    boolean isAddressDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.addressDiscoverButton.getText());
    }

    boolean isSecondaryDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.secondaryDiscoverButton.getText());
    }

    boolean isSecondaryAddressSetupDiscover() {
        return this.selectionGroup.getSelected().getLabel().equals(this.secondaryAddressSetupButton.getText());
    }

    public static interface DiscoveryModeListener {
        public void modeChanged();
    }
}

