/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.ui.cache;

import com.tridium.nv.cache.BNiagaraVirtualCache;
import com.tridium.ui.theme.Theme;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Tables;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public final class BNiagaraVirtualCacheView
extends BWbComponentView {
    public static final Action stationSelected = BNiagaraVirtualCacheView.newAction((int)0, null);
    public static final Action updateButtons = BNiagaraVirtualCacheView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualCacheView.class);
    private BNiagaraVirtualCache cache;
    private BIRandomAccessTable<?> cacheResult;
    private BListDropDown stationList = new BListDropDown();
    private DynamicTableModel tableModel = new DynamicTableModel((TableModel)new Model());
    private BTable table = new BTable((TableModel)this.tableModel, (TableController)new Controller());
    private static final BImage selectAllImage = BImage.make((BIcon)BIcon.std((String)"selectAll.png"));
    private BButton selectAllButton = new BButton((Command)new ReflectCommand((BWidget)this, lex.getText("niagaraVirtualCache.selectAll"), selectAllImage, "selectAll"));
    private static final BImage removeImage = BImage.make((BIcon)BIcon.std((String)"delete.png"));
    private BButton removeButton = new BButton((Command)new ReflectCommand((BWidget)this, lex.getText("niagaraVirtualCache.remove"), removeImage, "removeSelectedItems"));
    private static final Lexicon lex = Lexicon.make(BNiagaraVirtualCacheView.class);
    private int lastSortCol = -1;
    private boolean lastSortAscending = false;
    private boolean tableFirstLoaded = false;

    public void stationSelected() {
        this.invoke(stationSelected, null, null);
    }

    public void updateButtons() {
        this.invoke(updateButtons, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNiagaraVirtualCacheView() {
        BEdgePane pane = new BEdgePane();
        BGridPane selectPane = new BGridPane(2);
        selectPane.setColumnAlign(BHalign.left);
        selectPane.setHalign(BHalign.left);
        selectPane.add(null, (BValue)new BLabel(lex.getText("niagaraVirtualCacheView.station") + " "));
        selectPane.add(null, (BValue)this.stationList);
        pane.setTop((BWidget)new BBorderPane((BWidget)selectPane, 5.0, 5.0, 5.0, 5.0));
        this.linkTo((BComponent)this.stationList, (Slot)BListDropDown.valueModified, (Slot)stationSelected);
        pane.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("niagaraVirtualCacheView.niagaraVirtualCache"), (BTable)this.table));
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateButtons);
        BGridPane buttonPane = new BGridPane();
        buttonPane.add(null, (BValue)this.selectAllButton);
        buttonPane.add(null, (BValue)this.removeButton);
        pane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 5.0, 5.0));
        this.setContent((BWidget)pane);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.cache = (BNiagaraVirtualCache)value;
        BList list = this.stationList.getList();
        list.removeAllItems();
        String[] stationNames = TextUtil.splitAndTrim((String)this.cache.getStationNames().toString(), (char)',');
        for (int i = 0; i < stationNames.length; ++i) {
            list.addItem((Object)stationNames[i]);
        }
        if (list.getItemCount() > 0) {
            this.stationList.setSelectedIndex(0);
        }
        this.stationList.relayout();
        this.stationSelected();
    }

    public void doStationSelected() {
        try {
            this.enterBusy();
            String stationName = (String)this.stationList.getList().getSelectedItem();
            if (stationName != null) {
                try {
                    this.cacheResult = Tables.slurp((BITable)((BITable)BOrd.make((BOrd)this.cache.getHandleOrd(), (String)("bql:niagaraVirtual:NiagaraVirtualCache.queryCacheInfo(" + BqlQuery.toBqlLiteral((BSimple)BString.make((String)stationName)) + ")")).get((BObject)this.cache)));
                    if (this.lastSortCol > -1) {
                        this.table.getModel().sortByColumn(this.lastSortCol, this.lastSortAscending);
                    }
                    if (!this.tableFirstLoaded) {
                        this.tableModel.setShowColumn(2, false);
                        this.tableModel.setShowColumn(3, false);
                        this.tableFirstLoaded = true;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error updating Cache Result Table...");
                    e.printStackTrace();
                    this.cacheResult = null;
                }
            } else {
                this.cacheResult = null;
            }
            this.table.getSelection().deselectAll();
            this.table.getModel().updateTable();
            this.updateButtons();
        }
        finally {
            this.exitBusy();
        }
    }

    public void doUpdateButtons() {
        this.removeButton.setEnabled(!this.table.getSelection().isEmpty());
    }

    public void selectAll() {
        this.table.getSelection().selectAll();
    }

    public void removeSelectedItems() {
        if (this.cacheResult == null) {
            return;
        }
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        Column ordCol = null;
        Column[] cols = this.cacheResult.getColumns().list();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getName().equals("path")) continue;
            ordCol = cols[i];
            break;
        }
        if (ordCol == null) {
            return;
        }
        if (BDialog.confirm((BWidget)this, (Object)lex.getText("niagaraVirtualCache.removeMsg")) == 4) {
            BOrd[] ords = new BOrd[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                ords[i] = BOrd.make((String)this.cacheResult.get(rows[i]).cell(ordCol).toString());
            }
            BComponent removeData = new BComponent();
            removeData.add("stationName", (BValue)BString.make((String)this.stationList.getSelectedItem().toString()));
            removeData.add("vOrds", (BValue)BOrdList.make((BOrd[])ords));
            this.cache.removeFromCache(removeData);
            this.stationSelected();
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (BNiagaraVirtualCacheView.this.cacheResult != null) {
                BGridPane pane = new BGridPane(2);
                pane.setColumnGap(8.0);
                Column[] cols = BNiagaraVirtualCacheView.this.cacheResult.getColumns().list();
                int size = cols.length * 2;
                BFont boldFont = Theme.label().getBoldText();
                for (int i = 0; i < size; ++i) {
                    if (i % 2 == 0) {
                        pane.add(null, (BValue)new BLabel(cols[i / 2].getDisplayName(null), boldFont));
                        continue;
                    }
                    pane.add(null, (BValue)new BLabel(BNiagaraVirtualCacheView.this.cacheResult.get(row).cell(cols[i / 2]).toString()));
                }
                BDialog.message((BWidget)BNiagaraVirtualCacheView.this, (Object)new BBorderPane((BWidget)pane));
            }
        }
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getColumnCount() {
            if (BNiagaraVirtualCacheView.this.cacheResult == null) {
                return 0;
            }
            return BNiagaraVirtualCacheView.this.cacheResult.getColumns().size();
        }

        public String getColumnName(int col) {
            if (BNiagaraVirtualCacheView.this.cacheResult == null) {
                return "";
            }
            return lex.getText(BNiagaraVirtualCacheView.this.cacheResult.getColumns().get(col).getName());
        }

        public int getRowCount() {
            if (BNiagaraVirtualCacheView.this.cacheResult == null) {
                return 0;
            }
            return BNiagaraVirtualCacheView.this.cacheResult.size();
        }

        public Object getValueAt(int row, int col) {
            if (BNiagaraVirtualCacheView.this.cacheResult == null) {
                return "";
            }
            Column column = BNiagaraVirtualCacheView.this.cacheResult.getColumns().get(col);
            return BNiagaraVirtualCacheView.this.cacheResult.get(row).cell(column);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (BNiagaraVirtualCacheView.this.cacheResult != null) {
                BNiagaraVirtualCacheView.this.cacheResult = Tables.slurp((BITable)BNiagaraVirtualCacheView.this.cacheResult).sort(BNiagaraVirtualCacheView.this.cacheResult.getColumns().list()[col], ascending);
                BNiagaraVirtualCacheView.this.table.getModel().updateTable();
            }
            BNiagaraVirtualCacheView.this.lastSortCol = col;
            BNiagaraVirtualCacheView.this.lastSortAscending = ascending;
        }
    }
}

