/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.gx.awt.BImageDecoder;
import com.tridium.raster.viewer.ImageUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BColorChooser;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BImageViewer
extends BWbView {
    public static final Property content = BImageViewer.newProperty((int)0, (BValue)new BEdgePane());
    public static final Type TYPE = Sys.loadType(BImageViewer.class);
    static final String FACETS_PATH = "/com/tridium/raster/viewer/rasterViewer.facets";
    static Lexicon lex = Lexicon.make((String)"raster");
    static BImage errorIcon = BImage.make((String)"module://icons/x32/error.png");
    static boolean lastFit = true;
    static BColor lastColor = BColor.NULL;
    Command prev = new PrevImage((BWidget)this);
    Command next = new NextImage((BWidget)this);
    ToggleCommand fit = new FitToWindow((BWidget)this);
    Command background = new Background((BWidget)this);
    Command rotateLeft = new RotateLeft((BWidget)this);
    Command rotateRight = new RotateRight((BWidget)this);
    Command resize = new Resize((BWidget)this);
    BImage actual;
    BLabel display = new BLabel();
    BScrollPane scrollPane = new BScrollPane();
    double lastw;
    double lasth;
    boolean firstPaint = true;

    public Type getType() {
        return TYPE;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(this.getType().getDisplayName(null));
        menu.add("prev", this.prev);
        menu.add("next", this.next);
        menu.add(null, (BValue)new BSeparator());
        menu.add("fit", (Command)this.fit);
        menu.add("bg", this.background);
        menu.add(null, (BValue)new BSeparator());
        menu.add("rotl", this.rotateLeft);
        menu.add("rotr", this.rotateRight);
        menu.add("resize", this.resize);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        bar.add("prev", this.prev);
        bar.add("next", this.next);
        bar.add(null, (BValue)new BSeparator());
        bar.add("fit", (Command)this.fit);
        bar.add(null, (BValue)new BSeparator());
        bar.add("rotl", this.rotateLeft);
        bar.add("rotr", this.rotateRight);
        bar.add("resize", this.resize);
        return bar;
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        BIFile file = (BIFile)value;
        BIFile dir = (BIFile)file.getNavParent();
        BImage img = null;
        try {
            img = file.getType().is(ImageUtil.gifFileType) ? BImage.make((BOrd)file.getNavOrd()).sync() : (((BObject)file).getAgents().filter(AgentFilter.is((Type)BImageDecoder.TYPE)).size() > 0 ? BImage.make((BOrd)file.getNavOrd()).sync() : ImageUtil.toBImage(ImageUtil.read(file)));
            this.actual = img;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        boolean invalid = img == null || img.getWidth() <= 0.0 || img.getHeight() <= 0.0;
        boolean editable = !file.isReadonly() && !dir.isReadonly() && !invalid;
        this.setCommandEnabled(4, editable);
        this.rotateLeft.setEnabled(editable);
        this.rotateRight.setEnabled(editable);
        this.resize.setEnabled(editable);
        if (invalid) {
            BScrollPane scrollPane = new BScrollPane();
            String label = lex.getText("viewer.brokenImage");
            scrollPane.setContent((BWidget)new BBorderPane((BWidget)new BLabel(errorIcon, label), 5.0, 5.0, 5.0, 5.0));
            this.setContent((BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT));
            return;
        }
        this.scrollPane.setViewportBackground(lastColor.toBrush());
        this.scrollPane.setContent((BWidget)this.display);
        String mod = file.getLastModified().toString(null);
        String size = (int)img.getWidth() + " x " + (int)img.getHeight() + " (" + Math.max(1L, file.getSize() / 1024L) + "kb)";
        BGridPane grid = new BGridPane(1);
        grid.setRowGap(2.0);
        grid.setHalign(BHalign.left);
        BFont font = Theme.widget().getBoldText();
        BLabel label = new BLabel(file.getFileName(), font, BHalign.left);
        grid.add("name", (BValue)label);
        label.setForeground(BColor.white.toBrush());
        label = new BLabel(mod, BHalign.left);
        grid.add("mod", (BValue)label);
        label.setForeground(BColor.white.toBrush());
        label = new BLabel(size, BHalign.left);
        grid.add("size", (BValue)label);
        label.setForeground(BColor.white.toBrush());
        BScrollPane info = new BScrollPane();
        info.setViewportBackground(Theme.widget().getControlShadow());
        info.setContent((BWidget)new BBorderPane((BWidget)grid));
        BEdgePane content = (BEdgePane)this.getContent();
        content.setCenter((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        content.setBottom((BWidget)new BBorderPane((BWidget)info, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.updateImage();
    }

    public void doLayout(BWidget[] kids) {
        super.doLayout(kids);
        if (this.getWidth() != this.lastw || this.getHeight() != this.lasth) {
            this.lastw = this.getWidth();
            this.lasth = this.getHeight();
            if (this.fit.isSelected()) {
                this.updateImage();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.firstPaint) {
            this.updateImage();
            this.firstPaint = false;
        } else {
            super.paint(g);
        }
    }

    void updateImage() {
        if (this.actual == null) {
            return;
        }
        BImage view = this.actual;
        if (this.fit.isSelected()) {
            double vw = this.scrollPane.getWidth() - 10.0;
            double vh = this.scrollPane.getHeight() - 10.0;
            if (vw > 0.0 && vh > 0.0) {
                double iw = this.actual.getWidth();
                double ih = this.actual.getHeight();
                if (iw > vw || ih > vh) {
                    double rw = vw / iw;
                    double rh = vh / ih;
                    double r = Math.min(rw, rh);
                    view = this.actual.transform(BTransform.makeScale((double)r, (double)r));
                }
            }
        }
        this.display.setImage(view);
        this.scrollPane.relayout();
    }

    public void delete() throws IOException {
        BWbShell shell = this.getWbShell();
        BIFile file = (BIFile)this.getCurrentValue();
        this.advance(shell, 1, true);
        file.delete();
    }

    void background() {
        BColor c = BColorChooser.openInDialog((BWidget)this, (BColor)lastColor);
        if (c == null) {
            return;
        }
        lastColor = c;
        this.scrollPane.setViewportBackground(c.toBrush());
        this.scrollPane.repaint();
    }

    void rotate(int angle) {
        BIFile file = (BIFile)this.getCurrentValue();
        ImageUtil.process((BWidget)this, new BIFile[]{file}, new ImageUtil.Rotate(angle));
        this.getWbShell().getRefreshCommand().invoke();
    }

    void resize() {
        BIFile file = (BIFile)this.getCurrentValue();
        ImageUtil.ResizeInput in = new ImageUtil.ResizeInput((int)this.actual.getWidth(), (int)this.actual.getHeight());
        int r = BDialog.open((BWidget)this, (String)"Resize", (Object)in.getContent(), (int)3);
        if (r != 1) {
            return;
        }
        int w = in.getWidth();
        int h = in.getHeight();
        ImageUtil.process((BWidget)this, new BIFile[]{file}, new ImageUtil.Resize(w, h));
        this.getWbShell().getRefreshCommand().invoke();
    }

    void advance(BWbShell shell, int count, boolean silent) {
        BIFile file = (BIFile)this.getCurrentValue();
        BIDirectory dir = (BIDirectory)file.getNavParent();
        Object[] list = dir.listFiles();
        list = (BIFile[])new Array(list).filter(new IFilter(){

            public boolean accept(Object f) {
                return ((BIFile)f).getType().is(ImageUtil.imageFileType);
            }
        }).trim();
        int myIndex = -1;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getFileName().equals(file.getFileName())) continue;
            myIndex = i;
            break;
        }
        if (myIndex < 0 || list.length < 2) {
            if (!silent) {
                BDialog.error((BWidget)this, (Object)"No prev/next file found");
            }
            return;
        }
        int index = myIndex + count;
        if (index < 0) {
            index = list.length - 1;
        }
        if (index >= list.length) {
            index = 0;
        }
        BOrd ord = BOrd.make((BOrd)list[index].getAbsoluteOrd(), (String)("view:" + this.getType().toString()));
        shell.hyperlink(ord);
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 4: {
                this.delete();
                return null;
            }
        }
        return super.invokeCommand(id);
    }

    class Resize
    extends Command {
        public Resize(BWidget owner) {
            super(owner, lex, "resize");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.resize();
            return null;
        }
    }

    class RotateRight
    extends Command {
        public RotateRight(BWidget owner) {
            super(owner, lex, "rotateRight");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.rotate(90);
            return null;
        }
    }

    class RotateLeft
    extends Command {
        public RotateLeft(BWidget owner) {
            super(owner, lex, "rotateLeft");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.rotate(270);
            return null;
        }
    }

    class Background
    extends Command {
        Background(BWidget owner) {
            super(owner, lex, "background");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.background();
            return null;
        }
    }

    class FitToWindow
    extends ToggleCommand {
        FitToWindow(BWidget owner) {
            super(owner, lex, "fitToWindow");
            this.setSelected(lastFit);
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            lastFit = sel;
            BImageViewer.this.updateImage();
        }
    }

    class NextImage
    extends Command {
        NextImage(BWidget owner) {
            super(owner, lex, "nextImage");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.advance(BImageViewer.this.getWbShell(), 1, false);
            return null;
        }
    }

    class PrevImage
    extends Command {
        PrevImage(BWidget owner) {
            super(owner, lex, "prevImage");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.advance(BImageViewer.this.getWbShell(), -1, false);
            return null;
        }
    }
}

