/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.req.util.DdfReadRequestUtil;
import com.tridium.ddf.comm.req.util.DdfRequestLexicon;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.point.BIDdfWritable;
import com.tridium.ddf.point.DdfPointLexicon;
import javax.baja.status.BStatusValue;

public class DdfWriteRequestUtil
implements IDdfFacetConst {
    public static void processResponse(BIDdfWriteRequest ddfReq, BIDdfResponse ddfRsp) {
        IDdfWritable[] writableSource;
        if (ddfReq.getAutoWriteOk() && (writableSource = ddfReq.getWritableSource()) != null) {
            DdfWriteRequestUtil.updateWritables(ddfRsp, writableSource);
        }
    }

    public static void processTimeout(BIDdfWriteRequest ddfReq) {
        IDdfWritable[] writableSource;
        if (ddfReq.getAutoWriteFailOnTimeout() && (writableSource = ddfReq.getWritableSource()) != null) {
            for (int i = 0; i < writableSource.length; ++i) {
                writableSource[i].writeFail(DdfRequestLexicon.requestTimeout);
            }
        }
    }

    public static void processLateResponse(BIDdfWriteRequest ddfReq, BIDdfResponse ddfRsp) {
        IDdfWritable[] writableSource;
        if (ddfReq.getAutoWriteOkLate() && (writableSource = ddfReq.getWritableSource()) != null) {
            DdfWriteRequestUtil.updateWritables(ddfRsp, writableSource);
        }
    }

    public static void processErrorResponse(BIDdfWriteRequest ddfReq, DdfResponseException errorRsp) {
        IDdfWritable[] writableSource;
        if (ddfReq.getAutoWriteFailOnError() && (writableSource = ddfReq.getWritableSource()) != null) {
            for (int i = 0; i < writableSource.length; ++i) {
                writableSource[i].writeFail(DdfDefaultCommLexicon.responseError(errorRsp));
            }
        }
    }

    private static void updateReadValues(BIDdfReadResponse ddfReadRsp, IDdfWritable[] writableSource) {
        if (writableSource != null) {
            for (int i = 0; i < writableSource.length; ++i) {
                if (!(writableSource[i] instanceof IDdfReadable)) continue;
                DdfReadRequestUtil.callReadOk((IDdfReadable)((Object)writableSource[i]), ddfReadRsp);
            }
        }
    }

    private static void updateWriteValues(IDdfWritable[] writableSource) {
        for (int i = 0; i < writableSource.length; ++i) {
            BStatusValue writableSourceValue = writableSource[i].getWriteValue();
            writableSource[i].writeOk(writableSourceValue);
        }
    }

    private static void updateWritables(BIDdfResponse ddfRsp, IDdfWritable[] writableSource) {
        DdfWriteRequestUtil.updateWriteValues(writableSource);
        if (ddfRsp instanceof BIDdfReadResponse) {
            DdfWriteRequestUtil.updateReadValues((BIDdfReadResponse)ddfRsp, writableSource);
        }
    }

    public static void doWrite(BIDdfWritable writable, BStatusValue out) {
        BIDdfWriteRequest writeReq = writable.makeWriteRequest();
        if (writeReq == null) {
            String writeFailReason = DdfPointLexicon.writeNotImplemented(writable.toString());
            writable.writeFail(writeFailReason);
            writable.getDdfCommunicator().getLog().error(writeFailReason);
        } else {
            writable.getDdfCommunicator().communicate(writeReq);
        }
    }

    public static void doAuto(BIDdfWritable writable) {
        BIDdfWriteRequest autoReq = writable.makeAutoRequest();
        if (autoReq == null) {
            if (writable.getDdfCommunicator().getLog().isTraceOn()) {
                writable.getDdfCommunicator().getLog().trace(DdfPointLexicon.noAutoRequestDefined(writable.toString()));
            }
        } else {
            writable.getDdfCommunicator().communicate(autoReq);
        }
    }
}

