/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.DdfLexicon;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfNullCommunicator;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfDiscoverRequest;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.util.DdfDiscoveryRequestUtil;
import com.tridium.ddf.comm.req.util.DdfPingRequestUtil;
import com.tridium.ddf.comm.req.util.DdfReadRequestUtil;
import com.tridium.ddf.comm.req.util.DdfWriteRequestUtil;
import com.tridium.ddf.comm.rsp.BIDdfDiscoverResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.fox.sys.broker.BFoxStationSpace;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;

public abstract class DdfRequestUtil
implements IDdfFacetConst {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processResponse(BIDdfRequest ddfReq, BIDdfResponse ddfRsp) {
        try {
            if (ddfRsp.getDeviceId().getType() == BDdfIdParams.TYPE) {
                ddfRsp.setDeviceId((BDdfIdParams)ddfReq.getDeviceId().newCopy());
            }
            if (ddfReq instanceof BIDdfReadRequest) {
                DdfReadRequestUtil.processResponse((BIDdfReadRequest)ddfReq, (BIDdfReadResponse)ddfRsp);
            }
            if (ddfReq instanceof BIDdfPingRequest) {
                DdfPingRequestUtil.processResponse((BIDdfPingRequest)ddfReq, ddfRsp);
            }
            if (ddfReq instanceof BIDdfWriteRequest) {
                DdfWriteRequestUtil.processResponse((BIDdfWriteRequest)ddfReq, ddfRsp);
            }
            if (ddfReq instanceof BIDdfDiscoverRequest && ddfRsp instanceof BIDdfDiscoverResponse) {
                DdfDiscoveryRequestUtil.processResponse((BIDdfDiscoverRequest)ddfReq, (BIDdfDiscoverResponse)ddfRsp);
            }
            if (ddfReq instanceof BIDdfCustomRequest) {
                ((BIDdfCustomRequest)((Object)ddfReq)).processResponse(ddfRsp);
            }
        }
        finally {
            BIDdfRequest bIDdfRequest = ddfReq;
            synchronized (bIDdfRequest) {
                ddfReq.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processTimeout(BIDdfRequest ddfReq) {
        try {
            if (ddfReq instanceof BIDdfCustomRequest) {
                ((BIDdfCustomRequest)((Object)ddfReq)).processTimeout();
            }
            if (ddfReq instanceof BIDdfReadRequest) {
                DdfReadRequestUtil.processTimeout((BIDdfReadRequest)ddfReq);
            }
            if (ddfReq instanceof BIDdfPingRequest) {
                DdfPingRequestUtil.processTimeout((BIDdfPingRequest)ddfReq);
            }
            if (ddfReq instanceof BIDdfWriteRequest) {
                DdfWriteRequestUtil.processTimeout((BIDdfWriteRequest)ddfReq);
            }
            if (ddfReq instanceof BIDdfDiscoverRequest) {
                DdfDiscoveryRequestUtil.processTimeout((BIDdfDiscoverRequest)ddfReq);
            }
        }
        finally {
            BIDdfRequest bIDdfRequest = ddfReq;
            synchronized (bIDdfRequest) {
                ddfReq.notifyAll();
            }
        }
    }

    public static void processLateResponse(BIDdfRequest ddfReq, BIDdfResponse ddfRsp) {
        if (ddfRsp.getDeviceId().getType() == BDdfIdParams.TYPE) {
            ddfRsp.setDeviceId((BDdfIdParams)ddfReq.getDeviceId().newCopy());
        }
        if (ddfReq instanceof BIDdfReadRequest) {
            DdfReadRequestUtil.processLateResponse((BIDdfReadRequest)ddfReq, (BIDdfReadResponse)ddfRsp);
        }
        if (ddfReq instanceof BIDdfPingRequest) {
            DdfPingRequestUtil.processLateResponse((BIDdfPingRequest)ddfReq, ddfRsp);
        }
        if (ddfReq instanceof BIDdfWriteRequest) {
            DdfWriteRequestUtil.processLateResponse((BIDdfWriteRequest)ddfReq, ddfRsp);
        }
        if (ddfReq instanceof BIDdfDiscoverRequest && ddfRsp instanceof BIDdfDiscoverResponse) {
            DdfDiscoveryRequestUtil.processLateResponse((BIDdfDiscoverRequest)ddfReq, (BIDdfDiscoverResponse)ddfRsp);
        }
        if (ddfReq instanceof BIDdfCustomRequest) {
            ((BIDdfCustomRequest)((Object)ddfReq)).processLateResponse(ddfRsp);
        }
    }

    public static BIDdfResponse processReceive(BIDdfRequest ddfReq, IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        if (ddfReq instanceof BIDdfReadRequest) {
            return DdfReadRequestUtil.processReceive((BIDdfReadRequest)ddfReq, iDdfDataFrame);
        }
        return ddfReq.processReceive(iDdfDataFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processErrorResponse(BIDdfRequest ddfReq, DdfResponseException errorRsp) {
        try {
            if (ddfReq instanceof BIDdfReadRequest) {
                DdfReadRequestUtil.processErrorResponse((BIDdfReadRequest)ddfReq, errorRsp);
            }
            if (ddfReq instanceof BIDdfPingRequest) {
                DdfPingRequestUtil.processErrorResponse((BIDdfPingRequest)ddfReq, errorRsp);
            }
            if (ddfReq instanceof BIDdfWriteRequest) {
                DdfWriteRequestUtil.processErrorResponse((BIDdfWriteRequest)ddfReq, errorRsp);
            }
            if (ddfReq instanceof BIDdfDiscoverRequest) {
                DdfDiscoveryRequestUtil.processErrorResponse((BIDdfDiscoverRequest)ddfReq, errorRsp);
            }
            if (ddfReq instanceof BIDdfCustomRequest) {
                ((BIDdfCustomRequest)((Object)ddfReq)).processErrorResponse(errorRsp);
            }
        }
        finally {
            BIDdfRequest bIDdfRequest = ddfReq;
            synchronized (bIDdfRequest) {
                ddfReq.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void communicateSync(BIDdfCommunicator communicator, BIDdfRequest req) {
        BIDdfRequest bIDdfRequest = req;
        synchronized (bIDdfRequest) {
            block11: {
                try {
                    communicator.communicate(req);
                    if (communicator instanceof BComponent) {
                        BComponent realCommComponent = (BComponent)communicator;
                        BComponentSpace realCommComponentSpace = realCommComponent.getComponentSpace();
                        if (realCommComponentSpace == null || realCommComponentSpace instanceof BFoxStationSpace || realCommComponent.isRunning()) {
                            req.wait();
                        }
                    } else if (communicator instanceof BDdfNullCommunicator) {
                        BComponent realCommComponent;
                        BComponentSpace realCommComponentSpace;
                        BIDdfCommunicating commParent = ((BDdfNullCommunicator)communicator).getDdfCommunicatingComponent();
                        BIDdfCommunicator realComm = commParent.getDdfCommunicator();
                        if (realComm instanceof BComponent && ((realCommComponentSpace = (realCommComponent = (BComponent)realComm).getComponentSpace()) == null || realCommComponentSpace instanceof BFoxStationSpace || realCommComponent.isRunning())) {
                            req.wait();
                        }
                    } else {
                        req.wait();
                    }
                }
                catch (InterruptedException ie) {
                    if (!communicator.getLog().isTraceOn()) break block11;
                    communicator.getLog().trace(DdfLexicon.ddfCommunicateSyncError, (Throwable)ie);
                }
            }
        }
    }
}

