/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.comm.rsp.IDdfTransmitAckResponse;
import javax.baja.util.Lexicon;

public class DdfDefaultCommLexicon {
    public static final Lexicon LEX = Lexicon.make(DdfDefaultCommLexicon.class);
    public static final String RESPONSE_ERROR = "ResponseError";
    public static final String PARSE_ERROR = "ParseError";
    public static final String BEGIN_TRANSACTION = "BeginTransaction";
    public static final String SEND_ONLY_TRANSACTION_NOTIFICATION = "SendOnlyTransactionNotification";
    public static final String sendOnlyTransactionNotification = LEX.getText("SendOnlyTransactionNotification");
    public static final String REQUEST_TIMED_OUT = "RequestTimedOut";
    public static final String REQUEST_TIME_OUT = "RequestTimeOut";
    public static final String requestTimeOut = LEX.getText("RequestTimeOut");
    public static final String RECEIVED_RESPONSE_FOR_REQEUST = "ReceivedResponseForRequest";
    public static final String RECEIVED_LATE_RESPONSE_FOR_REQEUST = "ReceivedLateResponseForRequest";
    public static final String RECEIVED_ERROR_RESPONSE_FOR_REQEUST = "ReceivedErrorResponseForRequest";
    public static final String UNSUPPORTED_STRING_FORMAT = "UnsupportedStringFormat";
    public static final String ACK_REPLY_TRANSMIT = "AckReplyTransmit";
    public static final String ACK_REPLY_TRANSMIT_ERROR = "AckReplyTransmitError";
    public static final String MUT_TAG_CANNOT_BE_NULL = "MutTagCannotBeNull";
    public static final String RECEIVE_ERROR = "ReceiveError";
    public static final String receiveError = LEX.getText("ReceiveError");
    public static final String INTERRUPTED = "Interrupted";
    public static final String INTERNAL_DEV_TRANSMIT_ACK_REQUEST_KEY = "InternalDdfTransmitActRequest";
    public static final String internalDdfTransmitAckRequest = LEX.getText("internalDdfTransmitActRequest");
    public static final String NO_COMM_AVAILABLE_WHILE_INVALID_STATUS = "NoCommunicationsWhileInvalidStatus";
    public static final String noCommunicationsAvailableWhileInvaldStatus = LEX.getText("NoCommunicationsWhileInvalidStatus");

    private DdfDefaultCommLexicon() {
    }

    public static final String responseError(DdfResponseException ere) {
        return LEX.getText(RESPONSE_ERROR, new Object[]{ere.getLocalizedMessage()});
    }

    public static final String parseError(Exception e) {
        return LEX.getText(PARSE_ERROR, new Object[]{e.getLocalizedMessage()});
    }

    public static final String beginTransaction(BIDdfRequest ddfReq) {
        return LEX.getText(BEGIN_TRANSACTION, new Object[]{Integer.toString(ddfReq.hashCode())});
    }

    public static String requestTimedOut(BIDdfRequest ddfReq) {
        return LEX.getText(REQUEST_TIMED_OUT, new Object[]{Integer.toString(ddfReq.hashCode())});
    }

    public static final String receivedResponseForRequest(BIDdfRequest req) {
        return LEX.getText(RECEIVED_RESPONSE_FOR_REQEUST, new Object[]{Integer.toString(req.hashCode())});
    }

    public static final String receivedLateResponseForRequest(BIDdfRequest req) {
        return LEX.getText(RECEIVED_LATE_RESPONSE_FOR_REQEUST, new Object[]{Integer.toString(req.hashCode())});
    }

    public static final String receivedErrorResponseForRequest(BIDdfRequest req, DdfResponseException ere) {
        return LEX.getText(RECEIVED_ERROR_RESPONSE_FOR_REQEUST, new Object[]{Integer.toString(req.hashCode()), ere.getLocalizedMessage()});
    }

    public static String unsupportedStringFormat(String point, String value) {
        return LEX.getText(UNSUPPORTED_STRING_FORMAT, new Object[]{point, value});
    }

    public static String ackReplyTransmit(IDdfTransmitAckResponse ackResponse) {
        return LEX.getText(ACK_REPLY_TRANSMIT);
    }

    public static String ackReplyTransmitError(IDdfTransmitAckResponse ackResponse) {
        return LEX.getText(ACK_REPLY_TRANSMIT_ERROR);
    }

    public static String mutTagCannotBeNull(BIDdfRequest requestWithNullTag) {
        return LEX.getText(MUT_TAG_CANNOT_BE_NULL, new Object[]{requestWithNullTag.getType().getTypeSpec()});
    }

    public static String interrupted() {
        return LEX.getText(INTERRUPTED, new Object[]{Thread.currentThread().getName()});
    }
}

