/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.clock.BDdfScheduler;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfTransactionMgr;
import com.tridium.ddf.comm.BIDdfUnsolicitedMgr;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfRawTransmitRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfMultiFrameResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.IDdfTransmitAckResponse;
import java.util.Hashtable;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public abstract class BDdfTransactionMgr
extends BComponent
implements BIDdfTransactionMgr {
    public static final Action checkOutstandingTimeout = BDdfTransactionMgr.newAction((int)4, (BValue)BString.make((String)"OverridePlease"), null);
    public static final Type TYPE = Sys.loadType(BDdfTransactionMgr.class);
    private BIDdfCommunicator ddfCommunicator;
    boolean stopped = true;
    ReceiveThread receiveThread;
    TransactionProcessor transactionProcessor;
    Hashtable<BIDdfRequest, Clock.Ticket> requestTickets = new Hashtable();

    public Type getType() {
        return TYPE;
    }

    public void checkOutstandingTimeout(BValue ddfRequest) {
        this.invoke(checkOutstandingTimeout, ddfRequest, Context.commit);
    }

    public final void started() throws Exception {
        this.transactionMgrStarted();
        super.started();
    }

    public final void stopped() throws Exception {
        this.transactionMgrStopped();
    }

    @Override
    public void processTransaction(BIDdfRequest req) {
        block6: {
            try {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.beginTransaction(req));
                }
                this.beginTransaction(req);
                if (req.getResponseTimeout().equals((Object)BRelTime.DEFAULT)) {
                    if (this.getDdfCommunicator().getLog().isTraceOn()) {
                        this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.sendOnlyTransactionNotification + ": " + req.toString());
                    }
                } else {
                    this.scheduleToCheckForTimeout(req);
                }
            }
            catch (Exception e) {
                if (!this.getDdfCommunicator().getLog().isTraceOn()) break block6;
                this.getDdfCommunicator().getLog().trace("TransactionError", (Throwable)e);
            }
        }
    }

    @Override
    public BIDdfCommunicator getDdfCommunicator() {
        if (this.ddfCommunicator == null) {
            this.ddfCommunicator = (BIDdfCommunicator)this.getParent();
        }
        return this.ddfCommunicator;
    }

    @Override
    public void startTransactionMgr() {
        if (this.stopped) {
            this.stopped = false;
            this.transactionProcessor = new TransactionProcessor();
            this.transactionProcessor.start();
            this.receiveThread = new ReceiveThread();
            this.receiveThread.start();
            this.getDdfCommunicator().getDdfReceiver().startReceiver();
        }
    }

    @Override
    public void stopTransactionMgr() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.receiveThread != null) {
                this.getDdfCommunicator().getDdfReceiver().stopReceiver();
                this.receiveThread.stopReceiving();
                this.receiveThread.interrupt();
                try {
                    this.receiveThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.transactionProcessor != null) {
                this.transactionProcessor.interrupt();
                this.transactionProcessor.stopProcessing();
                try {
                    this.transactionProcessor.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.ddfCommunicator = null;
        }
        if (this.receiveThread != null && this.receiveThread.isAlive() || this.transactionProcessor != null && this.transactionProcessor.isAlive()) {
            new ReceiverAndTransactionMgrKiller(this.receiveThread, this.transactionProcessor).start();
        }
    }

    protected abstract void beginTransaction(BIDdfRequest var1) throws Exception;

    protected abstract void doCheckOutstandingTimeout(BIDdfRequest var1);

    protected abstract void frameReceived(IDdfDataFrame var1);

    protected void transactionMgrStarted() {
    }

    protected void transactionMgrStopped() {
    }

    public void resetStatistics() {
    }

    public final void doCheckOutstandingTimeout(BValue arg) {
        this.transactionProcessor.enqueue((BIDdfRequest)arg);
    }

    protected void scheduleToCheckForTimeout(BIDdfRequest req) {
        Clock.Ticket requestTicket = BDdfScheduler.INSTANCE.schedule((BComponent)this, req.getResponseTimeout(), checkOutstandingTimeout, (BValue)req);
        this.requestTickets.put(req, requestTicket);
    }

    protected void routeToUnsolicited(IDdfDataFrame ddfReceiveFrame) {
        BIDdfUnsolicitedMgr unsolicitedMgr = this.getDdfCommunicator().getDdfUnsolicitedMgr();
        if (unsolicitedMgr != null) {
            unsolicitedMgr.enqueueUnsolicitedFrame(ddfReceiveFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reScheduleToCheckForTimeout(BIDdfRequest req) {
        BIDdfRequest bIDdfRequest = req;
        synchronized (bIDdfRequest) {
            if (req.getResponseTimeout().getMillis() >= 0L) {
                Clock.Ticket requestTicket = this.requestTickets.get(req);
                if (requestTicket != null) {
                    requestTicket.cancel();
                }
                requestTicket = BDdfScheduler.INSTANCE.schedule((BComponent)this, req.getResponseTimeout(), checkOutstandingTimeout, (BValue)req);
                this.requestTickets.put(req, requestTicket);
            }
        }
    }

    protected boolean isCompletedResponse(BIDdfResponse ddfResponse) {
        if (ddfResponse instanceof BIDdfMultiFrameResponse) {
            return ((BIDdfMultiFrameResponse)ddfResponse).isComplete();
        }
        return true;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIDdfCommunicator;
    }

    protected void transmitRspAckBytes(IDdfTransmitAckResponse xmitAckRsp) {
        try {
            byte[] xmitAckBytes = xmitAckRsp.getBytes();
            if (xmitAckBytes != null) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.ackReplyTransmit(xmitAckRsp));
                }
                this.getDdfCommunicator().getDdfTransmitter().forceTransmit(new BDdfRawTransmitRequest(xmitAckBytes));
            }
        }
        catch (Exception e) {
            this.getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.ackReplyTransmitError(xmitAckRsp), (Throwable)e);
        }
    }

    protected String getThreadSuffix() {
        BIDdfCommunicator ddfCommunicator = this.getDdfCommunicator();
        if (ddfCommunicator instanceof BDdfCommunicator) {
            return ((BDdfCommunicator)ddfCommunicator).getWorkerThreadName();
        }
        return "";
    }

    private class TransactionProcessor
    extends Thread {
        boolean isRunning;
        boolean isTransactionProcessorStopped;
        Queue itemsToProcess;

        TransactionProcessor() {
            super("Transaction:" + BDdfTransactionMgr.this.getThreadSuffix());
            this.isRunning = false;
            this.isTransactionProcessorStopped = false;
            this.itemsToProcess = new Queue();
            this.isTransactionProcessorStopped = false;
        }

        void enqueue(IDdfDataFrame receivedFrame) {
            this.itemsToProcess.enqueue((Object)receivedFrame);
        }

        void enqueue(BIDdfRequest checkOutstandingTimeoutArg) {
            this.itemsToProcess.enqueue((Object)checkOutstandingTimeoutArg);
        }

        private void process(IDdfDataFrame processReceivedFrame) {
            BDdfTransactionMgr.this.frameReceived(processReceivedFrame);
        }

        private void process(BIDdfRequest processRequestCheckForTimeout) {
            Clock.Ticket requestTicket = BDdfTransactionMgr.this.requestTickets.get(processRequestCheckForTimeout);
            if (requestTicket == null) {
                BDdfTransactionMgr.this.doCheckOutstandingTimeout(processRequestCheckForTimeout);
            } else if (requestTicket.isExpired()) {
                BDdfTransactionMgr.this.requestTickets.remove(processRequestCheckForTimeout);
                BDdfTransactionMgr.this.doCheckOutstandingTimeout(processRequestCheckForTimeout);
            }
        }

        void stopProcessing() {
            this.isTransactionProcessorStopped = true;
        }

        @Override
        public void run() {
            try {
                this.isRunning = true;
                while (!this.isTransactionProcessorStopped) {
                    try {
                        Object nextItemToProcess = this.itemsToProcess.dequeue(-1);
                        if (nextItemToProcess instanceof IDdfDataFrame) {
                            this.process((IDdfDataFrame)nextItemToProcess);
                            continue;
                        }
                        if (!(nextItemToProcess instanceof BIDdfRequest)) continue;
                        this.process((BIDdfRequest)nextItemToProcess);
                    }
                    catch (InterruptedException nextItemToProcess) {
                    }
                    catch (Throwable t) {
                        if (this.isTransactionProcessorStopped) continue;
                        BDdfTransactionMgr.this.getDdfCommunicator().getLog().error(t.toString(), t);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                }
                BDdfTransactionMgr.this.getDdfCommunicator().getLog().message("Transaction mgr thread successfully stopped");
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    private class ReceiveThread
    extends Thread {
        boolean isReceiveThreadStopped;
        boolean isRunning;

        ReceiveThread() {
            super("Receive:" + BDdfTransactionMgr.this.getThreadSuffix());
            this.isReceiveThreadStopped = false;
            this.isRunning = false;
            this.isReceiveThreadStopped = false;
            this.isRunning = false;
        }

        void stopReceiving() {
            this.isReceiveThreadStopped = true;
        }

        @Override
        public void run() {
            try {
                this.isRunning = true;
                while (!this.isReceiveThreadStopped) {
                    try {
                        IDdfDataFrame receivedFrame = BDdfTransactionMgr.this.getDdfCommunicator().getDdfReceiver().receiveFrame();
                        if (receivedFrame == null) continue;
                        BDdfTransactionMgr.this.transactionProcessor.enqueue(receivedFrame.getFrameCopy());
                    }
                    catch (Throwable t) {
                        if (this.isReceiveThreadStopped) continue;
                        BDdfTransactionMgr.this.getDdfCommunicator().getLog().error(t.toString(), t);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {}
                    }
                }
                BDdfTransactionMgr.this.getDdfCommunicator().getLog().message("Receive thread successfully stopped");
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    private class ReceiverAndTransactionMgrKiller
    extends Thread {
        ReceiveThread receiveThread;
        TransactionProcessor transactionProcessor;

        ReceiverAndTransactionMgrKiller(ReceiveThread receiveThread, TransactionProcessor transactionProcessor) {
            this.receiveThread = receiveThread;
            this.transactionProcessor = transactionProcessor;
        }

        @Override
        public void run() {
            while (this.receiveThread != null && this.receiveThread.isRunning || this.transactionProcessor != null && this.transactionProcessor.isRunning) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.receiveThread != null && this.receiveThread.isRunning) {
                    this.receiveThread.interrupt();
                }
                if (this.transactionProcessor == null || !this.transactionProcessor.isRunning) continue;
                this.transactionProcessor.interrupt();
            }
        }
    }
}

