/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfReceiver;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BDdfReceiver
extends BStruct
implements BIDdfReceiver {
    public static final Property responseTimeout = BDdfReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)DdfFacets.combine(DdfFacets.MGR_INCLUDE, BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L))));
    public static final Property numFramesReceived = BDdfReceiver.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE = Sys.loadType(BDdfReceiver.class);
    private BIDdfCommunicator ddfCommunicator;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int MAYBE = 2;
    private static final int DEV_RX_STATE_SOH = 0;
    private static final int DEV_RX_STATE_DATA = 1;
    private static final int DEV_RX_STATE_DONE = 2;
    protected boolean stopped = false;
    DdfReceiveFrame receiveFrame = new DdfReceiveFrame();
    boolean receiving = false;
    int rxState = 0;
    Method doTraceMethod;

    @Override
    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    public long getNumFramesReceived() {
        return this.getLong(numFramesReceived);
    }

    public void setNumFramesReceived(long v) {
        this.setLong(numFramesReceived, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDdfReceiver() {
        Class<?> clazz = this.getClass();
        try {
            this.doTraceMethod = clazz.getMethod("doTrace", IDdfDataFrame.class);
        }
        catch (NoSuchMethodException nsme) {
            this.doTraceMethod = null;
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Ddf Receiver");
        this.spyImpl(out);
        out.endProps();
        super.spy(out);
    }

    private void spyImpl(SpyWriter out) {
        out.prop((Object)"Receiving", this.receiving);
        out.prop((Object)"Rx State", (Object)this.getStateTextForSpy());
        out.prop((Object)"Rx Buffer", (Object)this.spyBuffer());
    }

    private String spyBuffer() {
        StringBuffer spyBuffer = new StringBuffer();
        DdfReceiveFrame internalBuffer = this.getInternalBuffer();
        if (internalBuffer != null) {
            IDdfDataFrame spyFrameCopy = this.getInternalBuffer().getFrameCopy();
            int bufferSize = spyFrameCopy.getFrameSize();
            byte[] internalBufferBytes = this.getInternalBuffer().getFrameBytes();
            for (int i = 0; i < bufferSize; ++i) {
                spyBuffer.append(TextUtil.byteToHexString((int)internalBufferBytes[i]));
                if (i + 1 < bufferSize) {
                    spyBuffer.append(' ');
                }
                if (i % 16 != 0) continue;
                spyBuffer.append('\n');
            }
            return spyBuffer.toString();
        }
        return "null";
    }

    @Override
    public IDdfDataFrame receiveFrame() {
        try {
            IDdfDataFrame ddfDataFrame = this.doReceiveFrame();
            if (ddfDataFrame != null) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.trace(ddfDataFrame);
                }
                this.setNumFramesReceived(this.getNumFramesReceived() + 1L);
            }
            IDdfDataFrame iDdfDataFrame = ddfDataFrame;
            return iDdfDataFrame;
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException || e instanceof InterruptedException) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfDefaultCommLexicon.interrupted(), (Throwable)e);
                }
            } else {
                BIDdfCommunicator communicator = this.getDdfCommunicator();
                if (communicator instanceof BDdfCommunicator) {
                    if (((BDdfCommunicator)communicator).isCommEnabled()) {
                        this.getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.receiveError, (Throwable)e);
                    }
                } else {
                    this.getDdfCommunicator().getLog().error(DdfDefaultCommLexicon.receiveError, (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IDdfDataFrame iDdfDataFrame = null;
            return iDdfDataFrame;
        }
    }

    @Override
    public void startReceiver() {
        this.stopped = false;
    }

    @Override
    public void stopReceiver() {
        this.stopped = true;
        this.ddfCommunicator = null;
    }

    protected abstract int isStartOfFrame(IDdfDataFrame var1);

    protected abstract boolean isCompleteFrame(IDdfDataFrame var1);

    protected abstract boolean checkFrame(IDdfDataFrame var1);

    protected abstract int readByte() throws Exception;

    protected IDdfDataFrame doReceiveFrame() throws Exception {
        try {
            this.receiving = true;
            this.resetReceiveBuffer();
            this.rxState = 0;
            while (this.rxState != 2) {
                this.readByteToBuffer();
                if (this.rxState == 0) {
                    int isStartOfFrame = this.isStartOfFrame(this.receiveFrame);
                    if (isStartOfFrame == 0) {
                        this.rxState = 1;
                        continue;
                    }
                    if (isStartOfFrame != 1) continue;
                    this.resetReceiveBuffer();
                    continue;
                }
                if (this.rxState != 1 || !this.isCompleteFrame(this.receiveFrame)) continue;
                if (this.checkFrame(this.receiveFrame)) {
                    this.rxState = 2;
                    continue;
                }
                this.resetReceiveBuffer();
                this.rxState = 0;
            }
            DdfReceiveFrame ddfReceiveFrame = this.getInternalBuffer();
            return ddfReceiveFrame;
        }
        finally {
            this.receiving = false;
        }
    }

    public void resetStatistics() {
        this.setNumFramesReceived(0L);
    }

    @Override
    public BIDdfCommunicator getDdfCommunicator() {
        if (this.ddfCommunicator == null) {
            this.ddfCommunicator = (BIDdfCommunicator)this.getParent();
        }
        return this.ddfCommunicator;
    }

    protected void readByteToBuffer() throws Exception {
        this.receiveFrame.write(this.readByte());
    }

    public BRelTime getResponseTimeout(BIDdfRequest ddfRequest) {
        if (ddfRequest.getResponseTimeout().equals((Object)BDdfRequest.responseTimeout.getDefaultValue())) {
            return this.getResponseTimeout();
        }
        return ddfRequest.getResponseTimeout();
    }

    protected void resetReceiveBuffer() {
        this.receiveFrame.reset();
    }

    protected DdfReceiveFrame getInternalBuffer() {
        return this.receiveFrame;
    }

    protected BSimple computeTag(IDdfDataFrame iDdfDataFrame) {
        return BString.DEFAULT;
    }

    private void trace(IDdfDataFrame ddfDataFrame) {
        if (this.doTraceMethod != null) {
            try {
                this.doTraceMethod.invoke((Object)this, ddfDataFrame);
                return;
            }
            catch (Exception e) {
                this.doTraceMethod = null;
            }
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("RX:");
        ByteArrayUtil.hexDump((PrintWriter)pw, (byte[])ddfDataFrame.getFrameBytes(), (int)0, (int)ddfDataFrame.getFrameSize());
        pw.flush();
        pw.close();
        this.getDdfCommunicator().getLog().trace(sw.toString());
    }

    private String getStateTextForSpy() {
        switch (this.rxState) {
            case 0: {
                return "DEV_RX_STATE_SOH";
            }
            case 1: {
                return "DEV_RX_STATE_DATA";
            }
            case 2: {
                return "DEV_RX_STATE_DONE";
            }
        }
        return "" + this.rxState;
    }

    protected class DdfReceiveFrame
    extends ByteBuffer
    implements IDdfDataFrame {
        DdfReceiveFrame() {
            super(512);
        }

        @Override
        public byte[] getFrameBytes() {
            return this.getBytes();
        }

        @Override
        public int getFrameSize() {
            return this.getLength();
        }

        @Override
        public BSimple getFrameTag() {
            return BDdfReceiver.this.computeTag(this);
        }

        @Override
        public IDdfDataFrame getFrameCopy() {
            DdfReceiveFrame retVal = new DdfReceiveFrame();
            retVal.write(this.toByteArray());
            return retVal;
        }
    }
}

