/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf;

import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BPxView;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class DdfAgentInfo
implements AgentInfo {
    protected AgentInfo nAgentInfo;
    protected String driverModuleName;
    protected String displayNameKey;
    protected String displayNameDefault;

    public DdfAgentInfo(AgentInfo nAgentInfo, String driverModuleName, String displayNameKey, String displayNameDefault) {
        this.nAgentInfo = nAgentInfo;
        this.driverModuleName = driverModuleName;
        this.displayNameKey = displayNameKey;
        this.displayNameDefault = displayNameDefault;
    }

    public String getAgentId() {
        return this.nAgentInfo.getAgentId();
    }

    public TypeInfo[] getAgentOn() {
        return this.nAgentInfo.getAgentOn();
    }

    public TypeInfo getAgentType() {
        return this.nAgentInfo.getAgentType();
    }

    public String getDisplayName(Context cx) {
        String driverDisplayName;
        if (this.driverModuleName != null && (driverDisplayName = TextUtil.toFriendly((String)this.driverModuleName)) != null) {
            Lexicon driverLex = Lexicon.make((String)this.driverModuleName);
            String suffix = this.displayNameDefault;
            if (driverLex != null) {
                suffix = driverLex.get(this.displayNameKey, this.displayNameDefault);
            }
            return driverDisplayName + ' ' + suffix;
        }
        return this.nAgentInfo.getDisplayName(cx);
    }

    public BIcon getIcon(Context cx) {
        return this.nAgentInfo.getIcon(cx);
    }

    public BObject getInstance() {
        return this.nAgentInfo.getInstance();
    }

    public BPermissions getRequiredPermissions() {
        return this.nAgentInfo.getRequiredPermissions();
    }

    public static AgentList getAgentsHelp(AgentList agents, String driverModuleName, String mgrTypeSpec, String mgrSuffixKey, String mgrSuffixDefault) {
        int i;
        TypeInfo ddfManagerTypeInfo = Sys.getRegistry().getType(mgrTypeSpec);
        DdfAgentInfo ddfManagerAgentInfo = new DdfAgentInfo(ddfManagerTypeInfo.getAgentInfo(), driverModuleName, mgrSuffixKey, mgrSuffixDefault);
        boolean containsExtendedVersionOfMgr = false;
        boolean renamedAgent = false;
        for (i = 0; i < agents.size(); ++i) {
            AgentInfo agentInfo = agents.get(i);
            TypeInfo agentTypeInfo = agentInfo.getAgentType();
            if (!agentTypeInfo.is(ddfManagerTypeInfo) || agentTypeInfo.equals(ddfManagerTypeInfo)) continue;
            containsExtendedVersionOfMgr = true;
        }
        for (i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().equals(ddfManagerTypeInfo)) continue;
            agents.remove(i);
            if (containsExtendedVersionOfMgr) continue;
            agents.add((AgentInfo)ddfManagerAgentInfo);
            renamedAgent = true;
        }
        if (!renamedAgent && !containsExtendedVersionOfMgr) {
            agents.add((AgentInfo)ddfManagerAgentInfo);
        }
        for (i = agents.size() - 1; i >= 0; --i) {
            if (!agents.get(i).getAgentType().is(BPxView.TYPE)) continue;
            agents.toTop(i);
        }
        return agents;
    }

    public String getAppName() {
        return null;
    }
}

