/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf;

import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.DdfLexicon;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfNullCommunicator;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfPingParams;
import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BLoadableDevice;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BDdfDevice
extends BLoadableDevice
implements IDdfPingable,
IDdfFacetConst {
    public static final Property communicator = BDdfDevice.newProperty((int)4, (BValue)new BDdfNullCommunicator(), null);
    public static final Property deviceId = BDdfDevice.newProperty((int)0, (BValue)new BDdfIdParams(), null);
    public static final Property pingParameters = BDdfDevice.newProperty((int)0, (BValue)new BDdfIdParams(), null);
    public static final Type TYPE = Sys.loadType(BDdfDevice.class);

    public BValue getCommunicator() {
        return this.get(communicator);
    }

    public void setCommunicator(BValue v) {
        this.set(communicator, v, null);
    }

    @Override
    public BDdfIdParams getDeviceId() {
        return (BDdfIdParams)this.get(deviceId);
    }

    @Override
    public void setDeviceId(BDdfIdParams v) {
        this.set(deviceId, (BValue)v, null);
    }

    public BDdfIdParams getPingParameters() {
        return (BDdfIdParams)this.get(pingParameters);
    }

    public void setPingParameters(BDdfIdParams v) {
        this.set(pingParameters, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return null;
    }

    public BIDdfCommunicator getDdfCommunicator() {
        return (BIDdfCommunicator)this.getCommunicator();
    }

    public Type getDdfPingRequestType() {
        BDdfIdParams deviceId = this.getDeviceId();
        if (deviceId instanceof BIDdfPingParams) {
            return ((BIDdfPingParams)((Object)deviceId)).getPingRequestType();
        }
        if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.getDdfCommunicator().getLog().trace(DdfLexicon.ddfPingIdNeedsImplemented(deviceId.getType()));
        }
        this.pingFail(DdfLexicon.ddfPingIdNeedsImplemented(deviceId.getType()));
        return null;
    }

    public BIDdfPingRequest makePingRequest() {
        Type ddfPingRequestType = this.getDdfPingRequestType();
        if (ddfPingRequestType != null) {
            BIDdfPingRequest ddfPingRequest = (BIDdfPingRequest)ddfPingRequestType.getInstance();
            ddfPingRequest.setResponseTimeout(this.getDdfCommunicator().getDdfReceiver().getResponseTimeout());
            ddfPingRequest.setRemainingRetryCount(this.getDdfCommunicator().getDdfTransmitter().getMaxRetryCount());
            ddfPingRequest.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
            ddfPingRequest.setReadParameters((BDdfIdParams)this.getPingParameters().newCopy());
            return ddfPingRequest;
        }
        return null;
    }

    public void doPing() throws Exception {
        BIDdfPingRequest pingRequest = this.makePingRequest();
        if (pingRequest != null) {
            Array pingableSource = new Array(IDdfPingable.class);
            BDdfNetwork network = (BDdfNetwork)this.getNetwork();
            BDevice[] dbDevices = network.getDevices();
            for (int i = 0; i < dbDevices.length; ++i) {
                BDdfDevice ddfDevice;
                if (!(dbDevices[i] instanceof BDdfDevice) || (ddfDevice = (BDdfDevice)dbDevices[i]) != this && !ddfDevice.getDeviceId().equivalent(this.getDeviceId()) || pingableSource.contains((Object)ddfDevice)) continue;
                pingableSource.add((Object)ddfDevice);
            }
            pingRequest.setPingableSource((IDdfPingable[])pingableSource.trim());
            DdfRequestUtil.communicateSync(this.getDdfCommunicator(), pingRequest);
        }
    }
}

