/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.mux;

import com.tridium.box.BoxOp;
import com.tridium.box.mux.BoxEnvelope;
import com.tridium.nre.ConsumerWithException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Clock;

public class BoxEnvelopeDemux {
    private final String sessionId;
    private final int maxMessageSize;
    private final int maxEnvelopeSize;
    private final ConsumerWithException<BoxEnvelope, ? extends Exception> onComplete;
    private final Map<Long, BoxEnvelope> pendingEnvelopes;
    private static final Logger LOG = Logger.getLogger(BoxEnvelopeDemux.class.getName());

    public BoxEnvelopeDemux(String sessionId, int maxMessageSize, int maxEnvelopeSize, ConsumerWithException<BoxEnvelope, ? extends Exception> onComplete) {
        this.sessionId = sessionId;
        this.maxMessageSize = maxMessageSize;
        this.maxEnvelopeSize = maxEnvelopeSize;
        this.onComplete = onComplete;
        this.pendingEnvelopes = new HashMap<Long, BoxEnvelope>();
    }

    public BoxEnvelope openEnvelope(long envelopeId, BoxOp op) {
        return this.openEnvelope(envelopeId, Clock.ticks(), op);
    }

    private BoxEnvelope openEnvelope(long envelopeId, long birthDate, BoxOp op) {
        return this.pendingEnvelopes.computeIfAbsent(envelopeId, k -> BoxEnvelope.collecting(this.sessionId, envelopeId, birthDate, this.maxMessageSize, this.maxEnvelopeSize, op));
    }

    public BoxEnvelope getPendingEnvelope(long envelopeId) {
        return this.pendingEnvelopes.get(envelopeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFragment(long envelopeId, int fragmentIndex, int fragmentCount, byte[] payload, BoxOp op) {
        BoxEnvelope envelope = this.openEnvelope(envelopeId, op);
        if (envelope == null) {
            return;
        }
        envelope.setFragmentCount(fragmentCount);
        envelope.receiveFragment(payload, fragmentIndex);
        if (envelope.isComplete()) {
            try {
                this.onComplete.accept((Object)envelope);
            }
            catch (Throwable th) {
                BoxEnvelopeDemux.logSevere("onComplete callback failed", th);
            }
            finally {
                this.pendingEnvelopes.remove(envelopeId);
            }
        }
    }

    private static void logSevere(String msg, Throwable th) {
        LOG.log(Level.SEVERE, msg, th);
    }
}

