/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.mux;

import com.tridium.box.BBoxService;
import com.tridium.box.BoxOp;
import com.tridium.box.IBoxEventHandler;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.nre.ConsumerWithException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;

public class BoxEnvelope {
    private final String serverSessionId;
    private final long envelopeId;
    private int fragmentCount;
    private final int maxMessageSize;
    private final int maxEnvelopeSize;
    private final long birthDate;
    private final int fragmentOverhead;
    private final boolean unsolicited;
    private final List<byte[]> fragments;
    private final BoxOp op;
    public static final boolean MUX_ENABLED = AccessController.doPrivileged(() -> !"false".equals(System.getProperty("box.mux.muxEnabled")));
    public static final int MIN_DELAY = AccessController.doPrivileged(() -> Integer.getInteger("box.mux.minDelay", 0));
    public static final int MAX_DELAY = AccessController.doPrivileged(() -> Integer.getInteger("box.mux.maxDelay", 200));
    public static final int MAX_ENVELOPE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.mux.maxEnvelopeSize", 0x100000));
    private static final byte[] NO_BYTES = new byte[0];
    private static final byte[][] NO_BYTE_ARRAYS = new byte[0][];

    public static BoxEnvelope unsolicited(String serverSessionId, long envelopeId, int maxMessageSize, int maxEnvelopeSize) {
        return new BoxEnvelope(serverSessionId, envelopeId, Clock.ticks(), maxMessageSize, maxEnvelopeSize, true, null);
    }

    public static BoxEnvelope response(BoxEnvelope envelopeFromClient, byte[] payload) {
        BoxEnvelope env = new BoxEnvelope(envelopeFromClient.serverSessionId, envelopeFromClient.envelopeId, Clock.ticks(), envelopeFromClient.maxMessageSize, envelopeFromClient.maxEnvelopeSize, false, envelopeFromClient.op);
        env.append(payload);
        return env;
    }

    public static BoxEnvelope collecting(String serverSessionId, long envelopeId, long birthDate, int maxMessageSize, int maxEnvelopeSize, BoxOp op) {
        return new BoxEnvelope(serverSessionId, envelopeId, birthDate, maxMessageSize, maxEnvelopeSize, false, op);
    }

    private BoxEnvelope(String serverSessionId, long envelopeId, long birthDate, int maxMessageSize, int maxEnvelopeSize, boolean unsolicited, BoxOp op) {
        this.serverSessionId = serverSessionId;
        this.envelopeId = envelopeId;
        this.birthDate = birthDate;
        this.maxMessageSize = maxMessageSize;
        this.maxEnvelopeSize = maxEnvelopeSize;
        this.unsolicited = unsolicited;
        this.op = op;
        this.fragments = new ArrayList<byte[]>();
        this.fragmentOverhead = this.toBoxFragmentBytes(99, 99, NO_BYTES).length;
    }

    public String getServerSessionId() {
        return this.serverSessionId;
    }

    public long getEnvelopeId() {
        return this.envelopeId;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxEnvelopeSize() {
        return this.maxEnvelopeSize;
    }

    public long getBirthDate() {
        return this.birthDate;
    }

    public int getFragmentCount() {
        return this.fragmentCount;
    }

    public void setFragmentCount(int fragmentCount) {
        this.fragmentCount = fragmentCount;
        this.ensureCapacity();
    }

    public List<byte[]> getFragments() {
        return Collections.unmodifiableList(this.fragments);
    }

    public byte[] getPayload() {
        if (!this.isComplete()) {
            throw new IllegalStateException("payload is not yet complete");
        }
        return BoxEnvelope.concat((byte[][])this.fragments.toArray((T[])NO_BYTE_ARRAYS));
    }

    public boolean isUnsolicited() {
        return this.unsolicited;
    }

    public BoxOp getOp() {
        return this.op;
    }

    public void append(byte[] data) {
        int maxFragmentLength = this.maxMessageSize - this.fragmentOverhead;
        if (!this.fragments.isEmpty()) {
            int lastIndex = this.fragments.size() - 1;
            byte[] lastFragment = this.fragments.get(lastIndex);
            int freeSpace = maxFragmentLength - lastFragment.length;
            int endIndex = Math.min(freeSpace, data.length);
            this.fragments.set(lastIndex, BoxEnvelope.concat(lastFragment, BoxEnvelope.slice(data, 0, endIndex)));
            data = BoxEnvelope.slice(data, endIndex, data.length);
        }
        while (data.length > 0) {
            int endIndex = Math.min(maxFragmentLength, data.length);
            this.fragments.add(BoxEnvelope.slice(data, 0, endIndex));
            ++this.fragmentCount;
            data = BoxEnvelope.slice(data, endIndex, data.length);
        }
        this.ensureCapacity();
    }

    public void receiveFragment(byte[] fragment, int index) {
        if (index < 0 || index >= this.fragmentCount) {
            throw new IndexOutOfBoundsException("invalid fragment index");
        }
        this.fragments.set(index, fragment);
    }

    public boolean isComplete() {
        if (this.fragments.isEmpty()) {
            return false;
        }
        for (byte[] fragment : this.fragments) {
            if (fragment != null) continue;
            return false;
        }
        return true;
    }

    public int maxPayloadSize() {
        int maxFragments = (int)Math.ceil((double)this.maxEnvelopeSize / (double)this.maxMessageSize);
        return this.maxEnvelopeSize - maxFragments * this.fragmentOverhead;
    }

    public int expectedMessageSizeForPayload(String payload) {
        return this.fragmentOverhead + BoxEnvelope.byteLength(payload);
    }

    public boolean willFit(int payloadSize) {
        int existingData = 0;
        for (byte[] fragment : this.fragments) {
            existingData += fragment.length;
        }
        return existingData + payloadSize <= this.maxPayloadSize();
    }

    public BoxEnvelope respond(BBoxService service) throws Exception {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(this.getPayload()));
        JSONArray arr = new JSONArray(new JSONTokener((Reader)reader));
        String serverSessionId = this.getServerSessionId();
        byte[] responseData = BoxEnvelope.writeStrings((ConsumerWithException<Writer, ? extends Exception>)((ConsumerWithException)writer -> {
            writer.append('[');
            int len = arr.length();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.append(',');
                }
                JSONObject frame = arr.getJSONObject(i);
                frame.put("p", (Object)"box");
                frame.put("v", (Object)"2.2");
                frame.put("id", (Object)serverSessionId);
                service.handleBoxFrame(frame, (Writer)writer, this.op);
            }
            writer.append(']');
        }));
        return BoxEnvelope.response(this, responseData);
    }

    public void respond(BBoxService service, IBoxEventHandler handler, Context cx) throws Exception {
        this.respond(service).writeBoxFragments(handler, cx);
    }

    public void writeBoxFragments(IBoxEventHandler handler, Context cx) {
        for (int i = 0; i < this.fragmentCount; ++i) {
            byte[] payload = this.fragments.get(i);
            handler.writeBoxEvents(this.serverSessionId, this.toBoxFragmentBytes(i, this.fragmentCount, payload), cx);
        }
    }

    public static byte[] writeStrings(ConsumerWithException<Writer, ? extends Exception> consumer) {
        return BoxEnvelope.writeBytes((ConsumerWithException<OutputStream, ? extends Exception>)((ConsumerWithException)out -> {
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)out);){
                consumer.accept((Object)w);
                ((Writer)w).flush();
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] writeBytes(ConsumerWithException<OutputStream, ? extends Exception> consumer) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            consumer.accept((Object)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] toBoxFragmentBytes(int fragmentIndex, int fragmentCount, byte[] payload) {
        return BoxEnvelope.writeBytes((ConsumerWithException<OutputStream, ? extends Exception>)((ConsumerWithException)out -> {
            out.write(70);
            out.write(59);
            out.write("2.2".getBytes());
            out.write(59);
            out.write(this.serverSessionId.getBytes());
            out.write(59);
            out.write(String.valueOf(this.envelopeId).getBytes());
            out.write(59);
            out.write(String.valueOf(fragmentIndex).getBytes());
            out.write(59);
            out.write(String.valueOf(fragmentCount).getBytes());
            out.write(59);
            out.write(this.unsolicited ? 117 : 114);
            out.write(59);
            out.write(payload);
        }));
    }

    private void ensureCapacity() {
        for (int i = this.fragments.size(); i < this.fragmentCount; ++i) {
            this.fragments.add(null);
        }
    }

    public static int byteLength(String s) {
        return s.getBytes(StandardCharsets.UTF_8).length;
    }

    private static byte[] concat(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] a : arrays) {
            totalLength += a.length;
        }
        int start = 0;
        byte[] result = new byte[totalLength];
        for (byte[] a : arrays) {
            System.arraycopy(a, 0, result, start, a.length);
            start += a.length;
        }
        return result;
    }

    private static byte[] slice(byte[] array, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(array, start, result, 0, result.length);
        return result;
    }
}

