/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.nre.util.IElement;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;

public final class BsonDecoderPlugin
implements ValueDocDecoder.IDecoderPlugin {
    private final Array<BsonElement> elems = new Array(BsonElement.class);
    private int index = -1;
    private ValueDocDecoder.ITypeResolver typeResolver = new BsonTypeResolver();
    public static final ValueDocDecoder.ITypeResolver defaultTypeResolver = new BsonTypeResolver();
    private static final Logger defaultLog = Logger.getLogger("sys.json");
    private Logger log = defaultLog;
    private int warningCount;

    public BsonDecoderPlugin(InputStream in) throws Exception {
        JSONTokener tok = new JSONTokener((Reader)new InputStreamReader(new BufferedInputStream(in)));
        JSONObject root = new JSONObject(tok);
        this.add(root, 0);
    }

    public BsonDecoderPlugin(JSONObject obj) throws Exception {
        this.add(obj, 0);
    }

    public BValue decodeDocument(ValueDocDecoder decoder) throws Exception {
        this.next();
        return decoder.decode();
    }

    public int next() throws Exception {
        if (this.index >= this.elems.size()) {
            return -1;
        }
        ++this.index;
        return this.type();
    }

    public IElement elem() {
        if (this.index >= this.elems.size()) {
            return null;
        }
        if (this.index < 0) {
            return null;
        }
        return (IElement)this.elems.get(this.index);
    }

    public void skip() throws Exception {
        this.skip(this.depth());
    }

    public void skip(int toDepth) throws Exception {
        do {
            if (this.type() == 2 && this.depth() == toDepth) {
                return;
            }
            this.next();
        } while (this.type() != -1);
        throw new EOFException();
    }

    public int type() {
        if (this.index >= this.elems.size()) {
            return -1;
        }
        if (this.elem() != null) {
            return ((BsonElement)this.elem()).isEnd() ? 2 : 1;
        }
        return -1;
    }

    public int line() {
        return -1;
    }

    public int column() {
        return -1;
    }

    public void close() {
    }

    public int depth() {
        if (this.index < 0) {
            return 0;
        }
        if (this.index >= this.elems.size()) {
            return 0;
        }
        return ((BsonElement)this.elems.get(this.index)).depth;
    }

    private void add(JSONObject obj, int depth) throws Exception {
        BsonElement elem = new BsonElement(obj, depth);
        this.elems.add((Object)elem);
        ++depth;
        Iterator it = obj.keys();
        while (it.hasNext()) {
            Object val = obj.get(it.next().toString());
            if (val instanceof JSONObject) {
                this.add((JSONObject)val, depth);
                continue;
            }
            if (!(val instanceof JSONArray)) continue;
            JSONArray a = (JSONArray)val;
            for (int i = 0; i < a.length(); ++i) {
                if (!(a.get(i) instanceof JSONObject)) continue;
                this.add((JSONObject)a.get(i), depth);
            }
        }
        BsonElement endElem = (BsonElement)elem.copy();
        endElem.end = true;
        this.elems.add((Object)endElem);
    }

    public String getEncoding() throws IOException {
        return "";
    }

    public boolean isZipped() throws IOException {
        return false;
    }

    public IElement parse() throws Exception {
        return this.parse(true);
    }

    public IElement parse(boolean close) throws Exception {
        if (this.next() != 1) {
            if (close) {
                this.close();
            }
            throw this.err("Expecting element start");
        }
        return this.parseCurrent(close);
    }

    public IElement parseCurrent() throws Exception {
        return this.parseCurrent(false);
    }

    public IElement parseCurrent(boolean close) throws Exception {
        return this.elem();
    }

    public ValueDocDecoder.ITypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void setTypeResolver(ValueDocDecoder.ITypeResolver typeResolver) {
        this.typeResolver = typeResolver == null ? defaultTypeResolver : typeResolver;
    }

    public RuntimeException err(String msg, Throwable cause) {
        return new BsonException(msg, (BsonElement)this.elem(), cause);
    }

    public RuntimeException err(String msg) {
        return new BsonException(msg, (BsonElement)this.elem());
    }

    public void warningAndSkip(String msg) throws RuntimeException {
        this.warning(msg);
        try {
            this.skip();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BsonException(e);
        }
    }

    public void warning(String msg) throws RuntimeException {
        this.log.warning(msg);
        ++this.warningCount;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public static final BValue unmarshal(String json) throws Exception {
        BsonDecoderPlugin plugin = new BsonDecoderPlugin(new ByteArrayInputStream(json.getBytes()));
        ValueDocDecoder decoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)plugin);
        decoder.next();
        return decoder.decode();
    }

    public static final BValue unmarshal(String json, ValueDocDecoder.ITypeResolver typeResolver) throws Exception {
        BsonDecoderPlugin plugin = new BsonDecoderPlugin(new ByteArrayInputStream(json.getBytes()));
        ValueDocDecoder decoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)plugin);
        decoder.setTypeResolver(typeResolver);
        decoder.next();
        return decoder.decode();
    }

    public static final BValue unmarshal(JSONObject obj) throws Exception {
        BsonDecoderPlugin plugin = new BsonDecoderPlugin(obj);
        ValueDocDecoder decoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)plugin);
        decoder.next();
        return decoder.decode();
    }

    public static final BValue unmarshal(JSONObject obj, ValueDocDecoder.ITypeResolver typeResolver) throws Exception {
        BsonDecoderPlugin plugin = new BsonDecoderPlugin(obj);
        ValueDocDecoder decoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)plugin);
        decoder.setTypeResolver(typeResolver);
        decoder.next();
        return decoder.decode();
    }

    public static class BsonException
    extends RuntimeException {
        public BsonException(Throwable cause) {
            super(cause);
        }

        public BsonException(String msg, BsonElement elem) {
            super(BsonException.format(msg, elem));
        }

        public BsonException(String msg, BsonElement elem, Throwable cause) {
            super(BsonException.format(msg, elem), cause);
        }

        private static String format(String msg, BsonElement elem) {
            if (elem != null) {
                try {
                    return msg + " -> " + elem.obj.toString(2);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return msg;
        }
    }

    public static class BsonTypeResolver
    implements ValueDocDecoder.ITypeResolver {
        public BModule loadModule(ValueDocDecoder decoder, BComplex parent, String propName, String moduleStr, String typeStr) {
            try {
                return Sys.loadModule((String)moduleStr);
            }
            catch (ModuleException e) {
                throw decoder.err("Cannot load module '" + typeStr + "'", (Throwable)e);
            }
            catch (Exception e) {
                throw decoder.err("Invalid Type '" + typeStr + "'");
            }
        }

        public BValue newInstance(ValueDocDecoder decoder, BComplex parent, String propName, Property prop, String typeStr) {
            if (typeStr == null) {
                if (prop != null) {
                    return prop.getDefaultValue();
                }
                decoder.warningAndSkip("Missing frozen property: " + propName);
                return null;
            }
            try {
                return (BValue)Sys.getType((String)typeStr).getInstance();
            }
            catch (TypeNotFoundException e) {
                decoder.warningAndSkip("Type \"" + e.getMessage() + "\" not found: " + propName);
                return null;
            }
            catch (Throwable e) {
                throw decoder.err("Cannot instantiate type '" + typeStr + "'", e);
            }
        }
    }

    public static final class BsonElement
    implements IElement {
        private final JSONObject obj;
        private final int depth;
        private final String[] keys;
        private boolean end = false;

        private BsonElement(JSONObject obj, int depth) {
            this.obj = obj;
            this.depth = depth;
            this.keys = JSONObject.getNames((JSONObject)obj);
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = this.keys[i].intern();
            }
        }

        public String name() {
            try {
                return JSONUtil.getString((JSONObject)this.obj, (String)"nm");
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public String get(String attrName) {
            try {
                return JSONUtil.getString((JSONObject)this.obj, (String)attrName);
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public String get(String attrName, String def) {
            try {
                if (this.obj.has(attrName)) {
                    return JSONUtil.getString((JSONObject)this.obj, (String)attrName);
                }
                return def;
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public int geti(String attrName) {
            try {
                return this.obj.getInt(attrName);
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public int geti(String attrName, int def) {
            try {
                if (this.obj.has(attrName)) {
                    return this.obj.getInt(attrName);
                }
                return def;
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public double getd(String attrName) {
            try {
                return this.obj.getDouble(attrName);
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public double getd(String attrName, double def) {
            try {
                if (this.obj.has(attrName)) {
                    return this.obj.getDouble(attrName);
                }
                return def;
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public float getf(String attrName) {
            return (float)this.getd(attrName);
        }

        public float getf(String attrName, float def) {
            return (float)this.getd(attrName, def);
        }

        public long getl(String attrName) {
            try {
                return this.obj.getInt(attrName);
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public long getl(String attrName, long def) {
            try {
                if (this.obj.has(attrName)) {
                    return this.obj.getLong(attrName);
                }
                return def;
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public int attrSize() {
            return this.keys.length;
        }

        public String attrName(int index) {
            return this.keys[index];
        }

        public String attrValue(int index) {
            try {
                return JSONUtil.getString((JSONObject)this.obj, (String)this.keys[index]);
            }
            catch (JSONException e) {
                throw new BsonException(e);
            }
        }

        public IElement copy() {
            return new BsonElement(this.obj, this.depth);
        }

        public String toString() {
            try {
                return this.obj.toString(2);
            }
            catch (JSONException e) {
                return "error in generating BSON";
            }
        }

        public JSONObject getJsonObject() {
            return this.obj;
        }

        public boolean isEnd() {
            return this.end;
        }
    }
}

