/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import java.security.AccessController;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BlackListedTypes {
    private static final String[] typeSpecs = new String[]{"baja:Blob", "baja:Password"};
    private static Type[] types;

    private BlackListedTypes() {
    }

    public static boolean isTypeBlackListed(Type type) {
        for (int i = 0; i < types.length; ++i) {
            if (!type.is(types[i])) continue;
            return true;
        }
        return false;
    }

    public static Type[] getBlacklistedTypes() {
        return types;
    }

    static {
        Array a = new Array(Type.class);
        for (int i = 0; i < typeSpecs.length; ++i) {
            try {
                Type t = Sys.getType((String)typeSpecs[i]);
                if (!t.is(BSimple.TYPE)) {
                    throw new BajaRuntimeException("Cannot black list non-Simple Type: " + t);
                }
                a.add((Object)t);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        String[] userTypeSpecs = TextUtil.splitAndTrim((String)AccessController.doPrivileged(() -> System.getProperty("box.blackListedTypes", "")), (char)';');
        for (int i = 0; i < userTypeSpecs.length; ++i) {
            try {
                Type t = Sys.getType((String)userTypeSpecs[i]);
                if (!t.is(BSimple.TYPE)) {
                    throw new BajaRuntimeException("Cannot black list non-Simple User Type: " + t);
                }
                a.add((Object)t);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        types = (Type[])a.trim();
    }
}

