/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONObject;
import java.io.IOException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

public class BTimeZoneChannel
extends BBoxChannel {
    public static final Type TYPE = Sys.loadType(BTimeZoneChannel.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "getTimeZoneDatabase": {
                this.getTimeZoneDatabase(body, out, (Context)op);
                return true;
            }
        }
        return false;
    }

    private void getTimeZoneDatabase(Object body, BoxWriter out, Context cx) throws IOException {
        long regBuildTime = Sys.getRegistry().getLastBuildTime().getMillis();
        Long modifiedSince = BTimeZoneChannel.getOnlyIfModifiedSince(body);
        out.object();
        out.key("buildTime").value(regBuildTime);
        if (modifiedSince == null || modifiedSince < regBuildTime) {
            out.key("db").object();
            for (String id : TimeZoneDatabase.getAllSupportedZoneIds()) {
                BTimeZone zone = TimeZoneDatabase.getTimeZone((String)id);
                out.key(id).object();
                out.key("v").value((Object)zone.encodeToString());
                out.key("dn").value((Object)zone.getDisplayName(false, cx));
                out.key("ddn").value((Object)zone.getDisplayName(true, cx));
                out.key("sdn").value((Object)zone.getShortDisplayName(false, cx));
                out.key("dsdn").value((Object)zone.getShortDisplayName(true, cx));
                out.endObject();
            }
            out.endObject();
        }
        out.endObject();
    }

    private static Long getOnlyIfModifiedSince(Object body) {
        JSONObject obj;
        if (body instanceof JSONObject && (obj = (JSONObject)body).has("ifModifiedSince")) {
            return obj.getLong("ifModifiedSince");
        }
        return null;
    }

    @Override
    public String getChannelName() {
        return "timeZone";
    }
}

