/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxService;
import com.tridium.box.BServerCacheConfig;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.typenode.ContractEncoderVisitor;
import com.tridium.box.typenode.RegistryEncoderVisitor;
import com.tridium.box.typenode.TypeNode;
import com.tridium.box.typenode.TypeNodeBuilder;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XWriter;

public final class BRegistryChannel
extends BBoxChannel {
    public static final Type TYPE = Sys.loadType(BRegistryChannel.class);
    private final TypeNodeBuilder typeNodeBuilder = TypeNodeBuilder.make();
    private static final Logger log = Logger.getLogger("box.reg");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getChannelName() {
        return "reg";
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        boolean handled = true;
        long t0 = 0L;
        boolean logTraceOn = log.isLoggable(Level.FINE);
        if (logTraceOn) {
            t0 = Clock.ticks();
        }
        switch (key) {
            case "loadTypes": {
                this.loadTypes((JSONObject)body, out, op);
                break;
            }
            case "loadContract": {
                this.loadContract(body.toString(), out, op);
                break;
            }
            case "getConcreteTypes": {
                this.getConcreteTypes(body.toString(), out, op);
                break;
            }
            case "getAgents": {
                this.getAgents((JSONObject)body, out, op);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled && logTraceOn) {
            log.fine("BOX Registry: " + key + " -> " + (Clock.ticks() - t0) + "ms");
        }
        return handled;
    }

    private void loadTypes(JSONObject data, BoxWriter out, BoxOp op) throws Exception {
        this.encodeTypes(JSONUtil.toUnmodifiableList((JSONArray)data.getJSONArray("t")), data.getBoolean("ec"), out, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeTypes(List<String> types, boolean useContractEncoder, BoxWriter out, BoxOp op) throws Exception {
        BServerCacheConfig config = this.getBoxService().getServerCacheConfig();
        Object[] nodes = new Object[types.size()];
        ContractEncoderVisitor contractEncoder = useContractEncoder ? new ContractEncoderVisitor(out, (Context)op) : null;
        RegistryEncoderVisitor registerEncoder = new RegistryEncoderVisitor(out, contractEncoder, (Context)op, op.getClientEnv(), config.isHigh(), false);
        out.object();
        TypeNodeBuilder typeNodeBuilder = this.typeNodeBuilder;
        synchronized (typeNodeBuilder) {
            int i;
            for (i = 0; i < types.size(); ++i) {
                try {
                    nodes[i] = this.typeNodeBuilder.get(types.get(i));
                    continue;
                }
                catch (Exception e) {
                    nodes[i] = e;
                }
            }
            this.clearBuilder(config);
            for (i = 0; i < nodes.length; ++i) {
                Object o = nodes[i];
                if (o instanceof TypeNode) {
                    ((TypeNode)o).visit(registerEncoder);
                    continue;
                }
                if (!(o instanceof Exception)) continue;
                Exception e = (Exception)o;
                String typeSpec = XWriter.safeToString((String)types.get(i), (boolean)false);
                BBoxService.encodeException((JSONWriter)out.key(typeSpec), e, (Context)op);
            }
        }
        out.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContract(String typeSpec, BoxWriter out, BoxOp op) throws Exception {
        BServerCacheConfig config = this.getBoxService().getServerCacheConfig();
        ContractEncoderVisitor contractEncoder = new ContractEncoderVisitor(out, (Context)op);
        out.object();
        TypeNodeBuilder typeNodeBuilder = this.typeNodeBuilder;
        synchronized (typeNodeBuilder) {
            TypeNode node = this.typeNodeBuilder.get(typeSpec);
            this.clearBuilder(config);
            node.visit(contractEncoder);
        }
        out.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConcreteTypes(String typeSpec, BoxWriter out, BoxOp op) throws Exception {
        BServerCacheConfig config = this.getBoxService().getServerCacheConfig();
        TypeInfo[] typeInfos = Sys.getRegistry().getConcreteTypes(Sys.getRegistry().getType(typeSpec));
        TypeNode[] nodes = new TypeNode[typeInfos.length];
        RegistryEncoderVisitor registerEncoder = new RegistryEncoderVisitor(out, null, (Context)op, op.getClientEnv(), config.isHigh(), false);
        out.object();
        out.key("t");
        out.object();
        TypeInfo[] typeInfoArray = this.typeNodeBuilder;
        synchronized (this.typeNodeBuilder) {
            for (int i = 0; i < typeInfos.length; ++i) {
                nodes[i] = this.typeNodeBuilder.get(typeInfos[i].toString());
            }
            this.clearBuilder(config);
            TypeNode[] typeNodeArray = nodes;
            int n = typeNodeArray.length;
            for (int i = 0; i < n; ++i) {
                TypeNode n2 = typeNodeArray[i];
                n2.visit(registerEncoder);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            out.endObject();
            out.key("s");
            out.array();
            for (TypeInfo info : typeInfos) {
                out.value(info.toString());
            }
            out.endArray();
            out.endObject();
            return;
        }
    }

    private void getAgents(JSONObject data, BoxWriter out, BoxOp op) throws Exception {
        out.object();
        ArrayList<String> types = new ArrayList<String>();
        JSONArray ords = data.getJSONArray("ords");
        AgentFilter filter = AgentFilter.all;
        if (data.has("is")) {
            JSONArray is = data.getJSONArray("is");
            for (int x = 0; x < is.length(); ++x) {
                filter = AgentFilter.and((AgentFilter)filter, (AgentFilter)AgentFilter.is((String)JSONUtil.getString((JSONArray)is, (int)x)));
            }
        }
        out.key("rp").object();
        for (int i = 0; i < ords.length(); ++i) {
            OrdTarget target = BOrd.make((String)JSONUtil.getString((JSONArray)ords, (int)i)).resolve((BObject)BLocalHost.INSTANCE, (Context)op);
            BObject targetObj = target.get();
            AgentList list = targetObj instanceof BTypeSpec ? Sys.getRegistry().getAgents(Sys.getRegistry().getType(targetObj.toString())) : target.get().getAgents((Context)op);
            list = list.filter(filter);
            list = list.filter(AgentFilter.has((BPermissions)target.getPermissionsForTarget()));
            out.key(JSONUtil.getString((JSONArray)ords, (int)i)).array();
            for (AgentInfo agentInfo : list) {
                String ts = agentInfo.getAgentType().toString();
                types.add(ts);
                out.object().key("typeSpec").value((Object)ts).key("id").value((Object)agentInfo.getAgentId()).key("displayName").value((Object)agentInfo.getDisplayName((Context)op)).key("icon").value((Object)agentInfo.getIcon((Context)op)).endObject();
            }
            out.endArray();
        }
        out.endObject();
        out.key("t");
        this.encodeTypes(types, true, out, op);
        out.endObject();
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Type Node Cache");
        out.prop((Object)"Size", this.typeNodeBuilder.getSize());
        out.endProps();
        super.spy(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBuilder(BServerCacheConfig config) {
        TypeNodeBuilder typeNodeBuilder = this.typeNodeBuilder;
        synchronized (typeNodeBuilder) {
            if (config.isLow()) {
                this.typeNodeBuilder.clear();
            }
        }
    }
}

