/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BServerSessionHandler;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="spaceOrd", type="baja:Ord", defaultValue="BOrd.DEFAULT")})
public class BNavNodeSessionHandler
extends BServerSessionHandler
implements NavListener {
    public static final Property spaceOrd = BNavNodeSessionHandler.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNavNodeSessionHandler.class);
    private Context cx;
    private BINavNode targetNode;
    private static final BOrd[] supportedTargetNodes = new BOrd[]{BOrd.make((String)"history:"), BOrd.make((String)"file:^"), BOrd.make((String)"alarm:")};
    private static final Logger log = Logger.getLogger("box.spacenode");
    private final ArrayList<JSONObject> navEvents = new ArrayList();

    public BOrd getSpaceOrd() {
        return (BOrd)this.get(spaceOrd);
    }

    public void setSpaceOrd(BOrd v) {
        this.set(spaceOrd, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object init(Object arg, BoxOp op) throws Exception {
        BOrd ord = BOrd.make((String)arg.toString());
        BOrd relativized = ord.relativizeToSession();
        boolean found = false;
        for (BOrd o : supportedTargetNodes) {
            if (!o.equals((Object)relativized)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Target Nav Node unsupported: " + ord);
        }
        this.targetNode = (BINavNode)ord.get(null, (Context)op);
        this.cx = new BasicContext(op.getUser(), op.getLanguage());
        if (this.targetNode instanceof BIProtected) {
            BNavNodeSessionHandler.checkReadPermissions((BIProtected)this.targetNode, (Context)op);
        }
        this.setSpaceOrd(ord);
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        return null;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "navChildren": {
                this.navChildren((String)body, out, op);
                return true;
            }
        }
        return false;
    }

    private void navChildren(String navOrdStr, BoxWriter out, BoxOp op) throws IOException {
        BINavNode node = (BINavNode)BOrd.make((String)navOrdStr).get((BObject)BLocalHost.INSTANCE, (Context)op);
        if (!this.isNavNodeSupported(node)) {
            throw new IOException("Nav Node isn't supported");
        }
        if (node instanceof BIProtected) {
            BNavNodeSessionHandler.checkReadPermissions((BIProtected)node, (Context)op);
        }
        out.array();
        for (BINavNode navNode : BNavContainer.filter((BINavNode[])node.getNavChildren(), (Context)op)) {
            if (!this.isNavNodeSupported(navNode) || navNode instanceof BIProtected && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)navNode, (Context)op)) continue;
            out.value(this.encodeNavNode(navNode, (Context)op));
        }
        out.endArray();
    }

    private JSONObject encodeNavNode(BINavNode node, Context cx) throws IOException {
        BOrd ord = node.getNavOrd().normalize();
        JSONObject obj = new JSONObject();
        obj.put("navName", (Object)node.getNavName());
        obj.put("displayName", (Object)node.getNavDisplayName(cx));
        obj.put("ord", (Object)ord.toString());
        obj.put("icon", (Object)node.getNavIcon().encodeToString());
        obj.put("typeSpec", (Object)node.getType().toString());
        return obj;
    }

    public void stopped() {
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object detachEvents(BoxOp op) throws Exception {
        ArrayList<JSONObject> arrayList = this.navEvents;
        synchronized (arrayList) {
            if (this.navEvents.isEmpty()) {
                return null;
            }
            JSONArray navEventArray = new JSONArray();
            this.navEvents.forEach(arg_0 -> ((JSONArray)navEventArray).put(arg_0));
            this.navEvents.clear();
            return navEventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navEvent(NavEvent event) {
        String id;
        BOrd parentOrd = event.getParentOrd();
        BINavNode parent = event.getParent();
        if ((parentOrd == null || parentOrd.isNull()) && parent != null) {
            parentOrd = parent.getNavOrd();
        }
        if (parentOrd == null || parentOrd.isNull()) {
            return;
        }
        parentOrd = parentOrd.normalize();
        BOrd spaceOrd = this.getSpaceOrd();
        if (spaceOrd.isNull()) {
            return;
        }
        if (parent == null) {
            parent = (BINavNode)parentOrd.get((BObject)BLocalHost.INSTANCE, this.cx);
        }
        if (!this.isNavNodeSupported(parent)) {
            return;
        }
        switch (event.getId()) {
            case 1: {
                id = "added";
                break;
            }
            case 2: {
                id = "removed";
                break;
            }
            case 3: {
                id = "renamed";
                break;
            }
            case 5: {
                id = "replaced";
                break;
            }
            case 4: {
                id = "reordered";
                break;
            }
            default: {
                id = null;
            }
        }
        if (id == null) {
            return;
        }
        if (parent instanceof BIProtected && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)parent, this.cx)) {
            return;
        }
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)id);
        obj.put("ord", (Object)parentOrd.toString());
        if (event.getNewChildName() != null) {
            BINavNode child = parent.getNavChild(event.getNewChildName());
            if (child == null) {
                return;
            }
            if (child instanceof BIProtected && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)child, this.cx)) {
                return;
            }
            try {
                obj.put("newNode", (Object)this.encodeNavNode(child, this.cx));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not encode Nav Node", e);
                return;
            }
        }
        if (event.getOldChildName() != null) {
            obj.put("oldName", (Object)event.getOldChildName());
        }
        ArrayList<JSONObject> arrayList = this.navEvents;
        synchronized (arrayList) {
            this.navEvents.add(obj);
        }
        this.getServerSession().newEvents(this);
    }

    private boolean isNavNodeSupported(BINavNode node) {
        if (node instanceof BIFile && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)((BIFile)node), null)) {
            return false;
        }
        return AccessController.doPrivileged(() -> {
            for (BINavNode n = node; n != null; n = n.getNavParent()) {
                if (n != this.targetNode) continue;
                return true;
            }
            return false;
        });
    }
}

