/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxService;
import com.tridium.box.BFoxBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.IBoxEventHandler;
import com.tridium.fox.sys.BFoxChannelRegistry;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BFoxBoxAcceptor
extends BComponent {
    public static final Type TYPE = Sys.loadType(BFoxBoxAcceptor.class);
    private static final BIcon icon;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBoxService;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isNavChild() {
        return false;
    }

    String newMessage(String data, String addr, int port, boolean useFoxs, IBoxEventHandler eventHandler, Context cx) throws Exception {
        BBoxService service = this.getBoxService();
        try {
            BFacets facets = BFacets.make((String)"remoteHost", (BIDataValue)BString.make((String)((useFoxs ? "foxs://" : "fox://") + addr)), (String)"remotePort", (BIDataValue)BInteger.make((int)port), (String)"isWorkbench", (BIDataValue)BBoolean.TRUE);
            StringWriter writer = new StringWriter();
            BoxOp op = new BoxOp((Context)new BasicContext(cx, facets), useFoxs, addr);
            op.put("boxEventHandler", eventHandler);
            service.handleRequest(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), writer, op);
            writer.flush();
            return writer.toString();
        }
        catch (Exception e) {
            if (service.hasListeners()) {
                service.notifyListeners(cx, e);
            }
            BBoxService.log.log(Level.SEVERE, BBoxService.makeLogMsg("Processing Fox BOX Message", cx), e);
            throw e;
        }
    }

    private BBoxService getBoxService() {
        return (BBoxService)this.getParent();
    }

    static {
        BFoxChannelRegistry prototype = BFoxChannelRegistry.getPrototype();
        if (prototype.get("box") == null) {
            prototype.add("box", (BValue)new BFoxBoxChannel());
        }
        icon = BIcon.std((String)"fox.png");
    }
}

