/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BServerSessionHandler;
import com.tridium.box.BoxOp;
import com.tridium.box.json.AllPermissionsContext;
import com.tridium.box.json.BlackListedTypes;
import com.tridium.box.json.BoxString;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.sys.schema.NProperty;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.file.BSubSpaceFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.space.LoadCallbacks;
import javax.baja.status.BStatusValue;
import javax.baja.sync.AddOp;
import javax.baja.sync.FireTopicOp;
import javax.baja.sync.ProxyBroker;
import javax.baja.sync.RenameOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Relations;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.Tags;
import javax.baja.tag.util.RelationSet;
import javax.baja.tag.util.TagSet;
import javax.baja.user.BUser;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;

public final class BComponentSpaceSessionHandler
extends BServerSessionHandler
implements ProxyBroker.IProxyBrokerPlugin {
    public static final Property spaceOrd = BComponentSpaceSessionHandler.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BComponentSpaceSessionHandler.class);
    private static final Type boxAnalyzerType;
    private BComponentSpace space;
    private ProxyBroker broker;
    private final Object eventCounterMon = new Object();
    private volatile int eventCounter;
    private static final Logger log;
    private static final Logger skipValueLog;

    public BOrd getSpaceOrd() {
        return (BOrd)this.get(spaceOrd);
    }

    public void setSpaceOrd(BOrd v) {
        this.set(spaceOrd, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object init(Object arg, BoxOp op) {
        BOrd ord = BOrd.make((String)arg.toString());
        this.space = (BComponentSpace)ord.get(null, (Context)op);
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)this.space, (Context)op);
        this.setSpaceOrd(ord);
        this.broker = new ProxyBroker(this.space, (ProxyBroker.IProxyBrokerPlugin)this);
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("ComponentSpace Server Session Broker Started");
        }
        this.broker.start();
        JSONObject props = new JSONObject();
        props.put("isReadonly", this.space.isSpaceReadonly());
        return props;
    }

    @Override
    public Object detachEvents(BoxOp op) throws Exception {
        return this.syncFromMaster(op);
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        boolean handled = true;
        switch (key) {
            case "syncTo": {
                this.syncToMaster((JSONObject)body, out, op);
                break;
            }
            case "sub": {
                this.subscribe((JSONArray)body, out, op);
                break;
            }
            case "unsub": {
                this.unsubscribe((JSONArray)body, out);
                break;
            }
            case "loadSlots": {
                this.loadSlots((JSONObject)body, out, op);
                break;
            }
            case "loadSlotPath": {
                this.loadSlotPath((JSONObject)body, out, op);
                break;
            }
            case "loadRoot": {
                this.loadRoot(out, op);
                break;
            }
            case "handleToPath": {
                this.handleToPath((String)body, out, op);
                break;
            }
            case "serviceToPath": {
                this.serviceToPath((String)body, out, op);
                break;
            }
            case "invokeAction": {
                this.invokeAction((JSONObject)body, out, op);
                break;
            }
            case "serverSideCall": {
                this.serverSideCall((JSONObject)body, out, op);
                break;
            }
            case "getActionParameterDefault": {
                this.getActionParameterDefault((JSONObject)body, out, op);
                break;
            }
            case "makeLink": {
                this.makeLink((JSONObject)body, out, op);
                break;
            }
            case "checkLink": {
                this.checkLink((JSONObject)body, out, op);
                break;
            }
            case "navChildren": {
                this.getNavChildren((String)body, out, op);
                break;
            }
            case "impliedTags": {
                this.getImpliedTags((String)body, out, op);
                break;
            }
            case "impliedRelations": {
                this.getImpliedRelations((String)body, out, op);
                break;
            }
            case "enabledMixIns": {
                this.enabledMixIns(out);
                break;
            }
            case "save": {
                this.save(out);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void stopped() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private void subscribe(JSONArray ordsArray, BoxWriter out, BoxOp op) throws Exception {
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("Subscribe : " + ordsArray.join(","));
        }
        JSONArray handles = new JSONArray();
        ArrayList<BComponent> compArray = new ArrayList<BComponent>();
        for (int i = 0; i < ordsArray.length(); ++i) {
            OrdTarget target = BOrd.make((String)JSONUtil.getString((JSONArray)ordsArray, (int)i)).resolve((BObject)this.space);
            BComponent comp = target.getComponent();
            if (comp == null) continue;
            comp.loadSlots();
            BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
            compArray.add(comp);
        }
        for (BComponent comp : compArray) {
            this.broker.subscribeOp(comp, 0, comp instanceof BVirtualComponent);
            handles.put(comp.getHandle());
        }
        out.object();
        out.key("e").value(this.detachEvents(op));
        out.key("h").value((Object)handles);
        out.key("ts").value((Object)BAbsTime.now().encodeToString());
        out.endObject();
    }

    private void unsubscribe(JSONArray ordsArray, BoxWriter out) throws Exception {
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("Unsubscribe: " + ordsArray.join(","));
        }
        for (int i = 0; i < ordsArray.length(); ++i) {
            OrdTarget target = BOrd.make((String)JSONUtil.getString((JSONArray)ordsArray, (int)i)).resolve((BObject)this.space);
            BComponent comp = target.getComponent();
            if (comp == null) continue;
            this.broker.unsubscribe(comp);
        }
        out.value(null);
    }

    private void loadSlots(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        OrdTarget target = BOrd.make((String)JSONUtil.getString((JSONObject)body, (String)"o")).resolve((BObject)this.space, (Context)op);
        BComponent comp = target.getComponent();
        if (comp != null) {
            BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
            int depth = body.getInt("d");
            if (BComponentSpaceSessionHandler.isTraceOn()) {
                this.trace("Load: " + comp.toPathString() + " depth: " + depth);
            }
            this.broker.loadOp(comp, depth, comp instanceof BVirtualComponent);
        }
        out.value(null);
    }

    private void loadSlotPath(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BVirtualGateway gateway;
        BVirtualComponentSpace virtualSpace;
        boolean isVirtualSpace;
        JSONArray slotPathInfo = body.getJSONArray("spi");
        OrdTarget baseTarget = BOrd.make((String)JSONUtil.getString((JSONObject)body, (String)"bo")).resolve((BObject)this.space, (Context)op);
        BObject base = baseTarget.get();
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace(String.format("Load Slot Path: %s\nBase Ord: %s", slotPathInfo.join(","), JSONUtil.getString((JSONObject)body, (String)"bo")));
        }
        if (((isVirtualSpace = base instanceof BVirtualComponentSpace) || base instanceof BVirtualComponent) && (virtualSpace = isVirtualSpace ? (BVirtualComponentSpace)base : (BVirtualComponentSpace)((BComponent)base).getComponentSpace()) != null && (gateway = virtualSpace.getVirtualGateway()) != null) {
            LinkedHashSet<BOrd> ords = new LinkedHashSet<BOrd>(slotPathInfo.length() * 2);
            for (int i = 0; i < slotPathInfo.length(); ++i) {
                JSONObject slotInfo = slotPathInfo.getJSONObject(i);
                String slotPath = JSONUtil.getString((JSONObject)slotInfo, (String)"o");
                ords.add(BOrd.make((String)slotPath));
                if (!slotPath.endsWith("/")) {
                    slotPath = slotPath + "/";
                }
                ords.add(BOrd.make((String)(slotPath + JSONUtil.getString((JSONObject)slotInfo, (String)"sn"))));
            }
            gateway.ensureVirtualsLoaded(ords.toArray(new BOrd[0]));
        }
        out.array();
        for (int i = 0; i < slotPathInfo.length(); ++i) {
            BFacets facets;
            LoadCallbacks loadCallbacks;
            BComponentSpace space;
            JSONObject info = (JSONObject)slotPathInfo.get(i);
            BObject obj = BOrd.make((String)JSONUtil.getString((JSONObject)info, (String)"o")).get(base, (Context)op);
            if (!obj.isComponent()) continue;
            BComponent comp = obj.asComponent();
            BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
            String slotName = JSONUtil.getString((JSONObject)info, (String)"sn");
            Slot slot = comp.getSlot(slotName);
            if (slot == null && (space = comp.getComponentSpace()) != null && (loadCallbacks = space.getLoadCallbacks()) != null) {
                slot = loadCallbacks.loadSlot(comp, slotName);
            }
            if (slot == null) {
                comp.loadSlots();
                slot = comp.getSlot(slotName);
            }
            if (slot == null) {
                throw new Exception("Slot doesn't exist: " + slotName + " at " + comp.getNavOrd());
            }
            if (!slot.isProperty()) continue;
            Property prop = slot.asProperty();
            BValue value = comp.get(prop);
            if (value instanceof BComponent) {
                BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)((BComponent)value), (Context)op);
            }
            out.object();
            out.key("h").value(comp.getHandle());
            BsonSyncEncoder syncEncoder = new BsonSyncEncoder(new BsonEncoderPlugin((JSONWriter)out), (Context)op);
            out.key("n").value((Object)prop.getName());
            out.key("dn").value((Object)BsonEncoderPlugin.getSlotDisplayName((BComplex)comp, (Slot)prop, (Context)op));
            out.key("d").value((Object)BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)syncEncoder, (BComplex)comp, prop, (Context)op));
            int flags = comp.getFlags((Slot)prop);
            if (flags > 0) {
                out.key("f").value((Object)Flags.encodeToString((int)flags));
            }
            if (!(facets = comp.getSlotFacets((Slot)prop)).isNull()) {
                out.key("x").value((Object)facets.encodeToString());
            }
            out.key("v");
            syncEncoder.encode(null, value, -1);
            syncEncoder.flush();
            out.endObject();
        }
        out.endArray();
    }

    private void loadRoot(BoxWriter out, BoxOp op) throws Exception {
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("Load Root");
        }
        BComponent root = this.space.getRootComponent();
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)root, (Context)op);
        out.object();
        out.key("h").value(root.getHandle());
        out.key("t").value((Object)root.getType().toString());
        out.endObject();
    }

    private void handleToPath(String handle, BoxWriter out, BoxOp op) throws Exception {
        BComponent comp = (BComponent)BOrd.make((String)("h:" + handle)).get((BObject)this.space, (Context)op);
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
        out.value(comp.getSlotPath().getBody());
    }

    private void serviceToPath(String typeSpec, BoxWriter out, BoxOp op) throws Exception {
        BComponent service = (BComponent)BOrd.make((String)("service:" + typeSpec)).get((BObject)this.space, (Context)op);
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)service, (Context)op);
        out.value(service.getSlotPath().getBody());
    }

    private void invokeAction(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BValue retVal;
        BComponent comp = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"h"));
        comp.loadSlots();
        Action action = comp.getAction(JSONUtil.getString((JSONObject)body, (String)"a"));
        if (action == null) {
            throw new Exception("Could not find Action for Invocation: " + JSONUtil.getString((JSONObject)body, (String)"a") + " on " + comp.getNavOrd());
        }
        JSONObject argJson = null;
        if (body.has("b")) {
            argJson = body.getJSONObject("b");
        }
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            if (argJson != null) {
                this.trace("Invoke Action arg: " + argJson.toString(2));
            }
            this.trace("Invoking Action: " + comp.toPathString() + '.' + action.getName());
        }
        BValue arg = null;
        if (argJson != null) {
            arg = BComponentSpaceSessionHandler.unmarshal(argJson);
        }
        try {
            String remoteAddr = Objects.toString(op.getRemoteAddr(), "");
            BasicContext cx = new BasicContext((Context)op, BFacets.make((String)"remoteAddr", (BIDataValue)BString.make((String)remoteAddr)));
            retVal = comp.invoke(action, arg, (Context)cx);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Invoking Action: " + comp.toPathString() + ' ' + action.getName(), e);
            throw e;
        }
        out.value(retVal == null ? null : new BoxString(BsonEncoderPlugin.marshal(retVal, (Context)new AllPermissionsContext((Context)op))));
    }

    private void getActionParameterDefault(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BValue retVal;
        BComponent comp = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"h"));
        comp.loadSlots();
        Action action = comp.getAction(JSONUtil.getString((JSONObject)body, (String)"a"));
        if (action == null) {
            throw new Exception("Could not find Action for parameter default: " + JSONUtil.getString((JSONObject)body, (String)"a") + " on " + comp.getNavOrd());
        }
        BUser user = op.getUser();
        if (user != null) {
            user.checkInvoke(comp, (Slot)action);
        }
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("getActionParameterDefault: " + comp.toPathString() + '.' + action.getName());
        }
        try {
            retVal = comp.getActionParameterDefault(action);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "getActionParameterDefault: " + comp.toPathString() + ' ' + action.getName(), e);
            throw e;
        }
        out.value(retVal == null ? null : new BoxString(BsonEncoderPlugin.marshal(retVal, (Context)new AllPermissionsContext((Context)op))));
    }

    public void serverSideCall(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BComponent comp = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"h"));
        comp.loadSlots();
        String typeSpec = JSONUtil.getString((JSONObject)body, (String)"ts");
        String methodName = JSONUtil.getString((JSONObject)body, (String)"m");
        JSONObject argJson = null;
        if (body.has("b")) {
            argJson = body.getJSONObject("b");
        }
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            if (argJson != null) {
                this.trace("Server Side Call arg: " + argJson.toString(2));
            }
            this.trace("Invoking Server Side Call: " + comp.toPathString() + " -> " + typeSpec + " - " + methodName);
        }
        BValue arg = null;
        if (argJson != null) {
            arg = BComponentSpaceSessionHandler.unmarshal(argJson);
        }
        BValue retVal = null;
        try {
            AgentInfo info = comp.getAgents((Context)op).filter(AgentFilter.is((String)typeSpec)).getDefault();
            if (!info.getAgentType().is(BIServerSideCallHandler.TYPE)) {
                throw new Exception(typeSpec + " must implement BIServerSideCallHandler!");
            }
            BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
            BIServerSideCallHandler handler = (BIServerSideCallHandler)info.getAgentType().getInstance();
            boolean invoked = false;
            for (Method method : handler.getClass().getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 2 && paramTypes[0].equals(BComponent.class) && paramTypes[1].equals(Context.class)) {
                    retVal = (BValue)method.invoke((Object)handler, new Object[]{comp, op});
                    invoked = true;
                    break;
                }
                if (paramTypes.length != 3 || !paramTypes[0].equals(BComponent.class) || !paramTypes[1].equals(BValue.class) || !paramTypes[2].equals(Context.class)) continue;
                retVal = (BValue)method.invoke((Object)handler, new Object[]{comp, arg, op});
                invoked = true;
                break;
            }
            if (!invoked) {
                throw new UnsupportedOperationException("Could not find valid Server Side Call: " + methodName);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Invoking Server Side Call: " + comp.toPathString() + " -> " + typeSpec + " - " + methodName, e);
            throw e;
        }
        BasicContext encodeCx = retVal != null && retVal.isComponent() && retVal.asComponent().isMounted() ? op : new AllPermissionsContext((Context)op);
        out.value(retVal == null ? null : new BoxString(BsonEncoderPlugin.marshal(retVal, (Context)encodeCx)));
    }

    private void makeLink(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BComponent source = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"s"));
        if (source == null) {
            throw new Exception("Could not find Source: " + JSONUtil.getString((JSONObject)body, (String)"s"));
        }
        source.loadSlots();
        Slot sourceSlot = source.getSlot(JSONUtil.getString((JSONObject)body, (String)"ss"));
        if (sourceSlot == null) {
            throw new Exception("Could not find Source Slot: " + JSONUtil.getString((JSONObject)body, (String)"ss"));
        }
        BComponent target = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"t"));
        if (target == null) {
            throw new Exception("Could not find Target: " + JSONUtil.getString((JSONObject)body, (String)"t"));
        }
        target.loadSlots();
        Slot targetSlot = target.getSlot(JSONUtil.getString((JSONObject)body, (String)"ts"));
        if (targetSlot == null) {
            throw new Exception("Could not find Target Slot: " + JSONUtil.getString((JSONObject)body, (String)"ts"));
        }
        BLink link = target.makeLink(source, sourceSlot, targetSlot, (Context)op);
        out.value(new BoxString(BsonEncoderPlugin.marshal((BValue)link, (Context)new AllPermissionsContext((Context)op))));
    }

    private void checkLink(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BComponent source = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"s"));
        if (source == null) {
            throw new Exception("Could not find Source: " + JSONUtil.getString((JSONObject)body, (String)"s"));
        }
        source.loadSlots();
        Slot sourceSlot = source.getSlot(JSONUtil.getString((JSONObject)body, (String)"ss"));
        if (sourceSlot == null) {
            throw new Exception("Could not find Source Slot: " + JSONUtil.getString((JSONObject)body, (String)"ss"));
        }
        BComponent target = this.space.findByHandle((Object)JSONUtil.getString((JSONObject)body, (String)"t"));
        if (target == null) {
            throw new Exception("Could not find Target: " + JSONUtil.getString((JSONObject)body, (String)"t"));
        }
        target.loadSlots();
        Slot targetSlot = target.getSlot(JSONUtil.getString((JSONObject)body, (String)"ts"));
        if (targetSlot == null) {
            throw new Exception("Could not find Target Slot: " + JSONUtil.getString((JSONObject)body, (String)"ts"));
        }
        LinkCheck linkCheck = target.checkLink(source, sourceSlot, targetSlot, (Context)op);
        out.object();
        out.key("v").value(linkCheck.isValid());
        out.key("r").value((Object)linkCheck.getInvalidReason());
        out.endObject();
    }

    public void getNavChildren(String handle, BoxWriter out, BoxOp op) throws Exception {
        BComponent comp = this.space.findByHandle((Object)handle);
        if (comp == null) {
            throw new Exception("Could not find Component: " + handle);
        }
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
        out.array();
        for (BINavNode node : BNavContainer.filter((BINavNode[])comp.getNavChildren(), (Context)op)) {
            boolean add = false;
            if (node instanceof BIProtected) {
                if (BComponentSpaceSessionHandler.hasReadPermissions((BIProtected)node, (Context)op)) {
                    add = true;
                }
            } else {
                add = true;
            }
            if (!add) continue;
            out.value(node.getNavOrd());
        }
        out.endArray();
    }

    private void getImpliedTags(String handle, BoxWriter out, BoxOp op) throws Exception {
        BComponent comp = this.space.findByHandle((Object)handle);
        if (comp == null) {
            throw new Exception("Could not find Component: " + handle);
        }
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
        TagSet tagSet = new TagSet();
        TagDictionaryService service = comp.getTagDictionaryService();
        if (service != null) {
            service.getImpliedTags((Entity)comp).forEach(arg_0 -> ((TagSet)tagSet).set(arg_0));
        }
        JsonEntityEncoder.encodeTags((JSONWriter)out, (Tags)tagSet);
    }

    private void getImpliedRelations(String handle, BoxWriter out, BoxOp op) throws Exception {
        BComponent comp = this.space.findByHandle((Object)handle);
        if (comp == null) {
            throw new Exception("Could not find Component: " + handle);
        }
        BComponentSpaceSessionHandler.checkReadPermissions((BIProtected)comp, (Context)op);
        RelationSet relationSet = new RelationSet();
        TagDictionaryService service = comp.getTagDictionaryService();
        if (service != null) {
            service.getAllImpliedRelations((Entity)comp).forEach(arg_0 -> ((RelationSet)relationSet).add(arg_0));
        }
        JsonEntityEncoder.encodeRelations((JSONWriter)out, (Relations)relationSet);
    }

    private void enabledMixIns(BoxWriter out) throws Exception {
        out.array();
        for (Type type : this.space.getEnabledMixIns()) {
            out.value(type.toString());
        }
        out.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncFromMaster(BoxOp op) throws Exception {
        int id;
        Object object = this.eventCounterMon;
        synchronized (object) {
            id = ++this.eventCounter;
        }
        SyncBuffer buf = this.broker.detachBuffer();
        StringWriter strWtr = new StringWriter();
        JSONWriter writer = QuickJSONWriter.make((Appendable)strWtr);
        BsonSyncEncoder syncEncoder = new BsonSyncEncoder(new BsonEncoderPlugin(writer), (Context)op);
        buf.setId(id);
        buf.encode((SyncEncoder)syncEncoder);
        syncEncoder.flush();
        strWtr.flush();
        BoxString bsonBuff = new BoxString(strWtr.toString());
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("syncFromMaster: " + bsonBuff.toDebugString());
        }
        return bsonBuff;
    }

    private void syncToMaster(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        if (BComponentSpaceSessionHandler.isTraceOn()) {
            this.trace("syncToMaster: " + body.toString(2));
        }
        BsonSyncDecoder in = new BsonSyncDecoder(new BsonDecoderPlugin(body));
        BsonSyncBuffer buf = new BsonSyncBuffer(this.space, false);
        buf.decode(in);
        buf.commit((Context)op);
        out.array();
        for (int i = 0; i < buf.commitOps.length; ++i) {
            String newName;
            SyncOp syncOp = buf.commitOps[i];
            out.object();
            out.key("id").value((Object)String.valueOf((char)syncOp.getId()));
            if (syncOp instanceof AddOp && (newName = ((AddOp)syncOp).getNewSlotName()) != null) {
                out.key("nn").value((Object)newName);
            }
            out.endObject();
        }
        out.endArray();
    }

    private void save(BoxWriter out) throws Exception {
        if (this.space.getNavParent() instanceof BSubSpaceFile) {
            if (this.space.isSpaceReadonly()) {
                throw new Exception("Cannot save readonly space.");
            }
        } else {
            throw new IllegalStateException("Cannot save a non-BOG Space!");
        }
        BSubSpaceFile file = (BSubSpaceFile)this.space.getNavParent();
        file.save();
        out.value(null);
    }

    private static String getDisplay(ValueDocEncoder encoder, BComplex comp, Property prop, Context cx) {
        BValue value = comp.get(prop);
        if (encoder.isTypeBlackListed(value.getType())) {
            return "";
        }
        Context mergedCx = ValueDocEncoder.getMergedContext((BComplex)comp, (Slot)prop, (Context)cx);
        return value.toString(mergedCx);
    }

    private static BValue unmarshal(JSONObject argJson) throws Exception {
        BsonDecoderPlugin plugin = new BsonDecoderPlugin(argJson);
        BsonValueDecoder decoder = new BsonValueDecoder(plugin);
        decoder.next();
        return decoder.decode();
    }

    public void newSyncOp(SyncOp op) {
        this.getServerSession().newEvents(this);
    }

    public boolean isValidSyncOp(SyncOp op) {
        return boxAnalyzerType == null || !op.getComponent().getType().is(boxAnalyzerType) || !(op instanceof FireTopicOp);
    }

    private static boolean isTraceOn() {
        return log.isLoggable(Level.FINE);
    }

    private void trace(String msg) {
        log.fine(this.space.getNavOrd().toString() + " -> " + msg);
    }

    static {
        Type t = null;
        try {
            t = Sys.getType((String)"boxAnalyzer:BoxAnalyzer");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boxAnalyzerType = t;
        log = Logger.getLogger("box.compSpaceHandler");
        skipValueLog = Logger.getLogger("box.compSpaceHandler.skipValues");
    }

    private static final class BsonSyncBuffer
    extends SyncBuffer {
        private SyncOp[] commitOps;

        private BsonSyncBuffer(BComponentSpace space, boolean coalesce) {
            super(space, coalesce);
        }

        protected SyncOp[] startCommit(SyncOp[] ops, Context cx) {
            this.commitOps = super.startCommit(ops, cx);
            return this.commitOps;
        }
    }

    private static final class BsonValueDecoder
    extends ValueDocDecoder {
        public BsonValueDecoder(ValueDocDecoder.IDecoderPlugin plugin) throws Exception {
            super(plugin);
        }

        public boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }
    }

    private static final class BsonSyncDecoder
    extends SyncDecoder {
        private BsonSyncDecoder(ValueDocDecoder.IDecoderPlugin plugin) throws Exception {
            super(plugin);
        }

        public boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }
    }

    public static final class BsonSyncEncoder
    extends SyncEncoder {
        public BsonSyncEncoder(ValueDocEncoder.IEncoderPlugin plugin, Context cx) throws Exception {
            super(plugin, cx);
        }

        protected void encodingSlot(BComplex parent, Slot slot) throws IOException {
            BsonEncoderPlugin.encodingSlotBson((ValueDocEncoder)this, parent, slot);
        }

        protected void encodingValue(BValue val, Context cx) throws IOException {
            BsonEncoderPlugin.encodingValueBson((ValueDocEncoder)this, val, cx);
        }

        protected void encodingComponent(BComponent c) throws IOException {
            super.encodingComponent(c);
            BsonEncoderPlugin.encodeIsNavChild((ValueDocEncoder)this, c);
        }

        protected void encodingComponentStub(BComponent c) throws IOException {
            super.encodingComponentStub(c);
            BsonEncoderPlugin.encodeIsNavChild((ValueDocEncoder)this, c);
        }

        protected void encodingFacets(BFacets facets) throws IOException {
            BsonEncoderPlugin.encodingFacetsBson((ValueDocEncoder)this, facets);
        }

        protected void encodingSyncOp(SyncOp op) throws IOException {
            BComponent comp = op.getComponent();
            if (comp != null) {
                this.plugin.attr("cd", comp.toString(this.getContext()));
                this.plugin.attr("cdn", comp.getDisplayName(this.getContext()));
                if (op instanceof SetOp) {
                    SetOp setOp = (SetOp)op;
                    Property prop = comp.getProperty(setOp.getSlotName());
                    if (prop == null) {
                        return;
                    }
                    if ("out".equals(prop.getName())) {
                        this.plugin.attr("ts", setOp.getTimestamp().encodeToString());
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)comp, (Slot)prop, this.getContext()));
                } else if (op instanceof AddOp) {
                    AddOp addOp = (AddOp)op;
                    Property prop = comp.getProperty(addOp.getSlotName());
                    if (prop == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)comp, (Slot)prop, this.getContext()));
                    BsonEncoderPlugin.encodingFacetsBson((ValueDocEncoder)this, addOp.getFacets());
                } else if (op instanceof RenameOp) {
                    RenameOp renameOp = (RenameOp)op;
                    Property prop = comp.getProperty(renameOp.getNewName());
                    if (prop == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)comp, (Slot)prop, this.getContext()));
                    this.plugin.attr("d", BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)this, (BComplex)comp, prop, this.getContext()));
                } else if (op instanceof SetFacetsOp) {
                    SetFacetsOp setFacetsOp = (SetFacetsOp)op;
                    Slot slot = comp.getSlot(setFacetsOp.getSlotName());
                    if (slot == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)comp, (Slot)slot.asProperty(), this.getContext()));
                    if (slot.isProperty()) {
                        this.plugin.attr("d", BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)this, (BComplex)comp, slot.asProperty(), this.getContext()));
                    }
                    BsonEncoderPlugin.encodingFacetsBson((ValueDocEncoder)this, setFacetsOp.getFacets());
                } else if (op instanceof SetFlagsOp) {
                    SetFlagsOp setFlagsOp = (SetFlagsOp)op;
                    Slot slot = comp.getSlot(setFlagsOp.getSlotName());
                    if (slot == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)comp, slot, this.getContext()));
                    if (slot.isProperty()) {
                        this.plugin.attr("d", BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)this, (BComplex)comp, slot.asProperty(), this.getContext()));
                    }
                }
            }
        }

        public boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }

        protected boolean canSkipEncodingProperty(BComplex complex, Property prop, BValue value, BPermissions permissions) {
            boolean canSkip = super.canSkipEncodingProperty(complex, prop, value, permissions);
            if (!canSkip || value.isComponent()) {
                return canSkip;
            }
            String optimization = "none";
            boolean newCanSkip = true;
            if (complex instanceof BControlPoint) {
                if (value instanceof BStatusValue) {
                    BControlPoint point = (BControlPoint)complex;
                    BFacets facets = point.getFacets();
                    BFacets defaultPointFacets = (BFacets)((NProperty)point.getProperty((String)"facets")).value;
                    newCanSkip = facets.equals((Object)defaultPointFacets);
                    optimization = "control point";
                }
            } else {
                BFacets facets = prop.getFacets();
                BFacets complexFacets = BFacets.DEFAULT;
                if (complex instanceof BComponent) {
                    complexFacets = complex.getSlotFacets((Slot)prop);
                    optimization = "component";
                } else {
                    Property p = prop;
                    for (BComplex c = complex; c != null && p != null; c = c.getParent()) {
                        complexFacets = BFacets.make((BFacets)complexFacets, (BFacets)BFacets.makePickle((BFacets)c.getSlotFacets((Slot)p), (Object)BFacets.SKIP_INTERN_PICKLE));
                        if (c instanceof BComponent) break;
                        p = c.getPropertyInParent();
                    }
                }
                newCanSkip = facets.equals((Object)complexFacets);
            }
            if (!newCanSkip) {
                BComponent comp;
                canSkip = false;
                if (skipValueLog.isLoggable(Level.FINE) && (comp = complex.getParentComponent()) != null) {
                    skipValueLog.fine("Not skipping encoding: " + comp.toPathString() + " -> " + prop.getName() + " -> Optimization: " + optimization);
                }
            }
            return canSkip;
        }
    }
}

