/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BAlarmChannel;
import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxServlet;
import com.tridium.box.BBoxWebSocketAcceptor;
import com.tridium.box.BFoxBoxAcceptor;
import com.tridium.box.BHistoryChannel;
import com.tridium.box.BOrdChannel;
import com.tridium.box.BRegistryChannel;
import com.tridium.box.BServerCacheConfig;
import com.tridium.box.BServerSession;
import com.tridium.box.BServerSessionChannel;
import com.tridium.box.BSysChannel;
import com.tridium.box.BTimeZoneChannel;
import com.tridium.box.BTransferChannel;
import com.tridium.box.BUnitChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.ServerSessionException;
import com.tridium.box.env.BBajaScriptClientEnv;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.box.BBoxClientEnv;
import javax.baja.license.Feature;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.xml.XWriter;

public final class BBoxService
extends BAbstractService
implements BIRestrictedComponent {
    public static final Property servlet = BBoxService.newProperty((int)4, (BValue)new BBoxServlet(), null);
    public static final Property webSocketAcceptor = BBoxService.newProperty((int)0, (BValue)new BBoxWebSocketAcceptor(), null);
    public static final Property foxAcceptor = BBoxService.newProperty((int)0, (BValue)new BFoxBoxAcceptor(), null);
    public static final Property sys = BBoxService.newProperty((int)0, (BValue)new BSysChannel(), null);
    public static final Property reg = BBoxService.newProperty((int)0, (BValue)new BRegistryChannel(), null);
    public static final Property timeZone = BBoxService.newProperty((int)0, (BValue)new BTimeZoneChannel(), null);
    public static final Property unit = BBoxService.newProperty((int)0, (BValue)new BUnitChannel(), null);
    public static final Property history = BBoxService.newProperty((int)0, (BValue)new BHistoryChannel(), null);
    public static final Property alarm = BBoxService.newProperty((int)0, (BValue)new BAlarmChannel(), null);
    public static final Property ssession = BBoxService.newProperty((int)0, (BValue)new BServerSessionChannel(), null);
    public static final Property ord = BBoxService.newProperty((int)0, (BValue)new BOrdChannel(), null);
    public static final Property transfer = BBoxService.newProperty((int)0, (BValue)new BTransferChannel(), null);
    public static final Property serverCacheConfig = BBoxService.newProperty((int)0, (BValue)BServerCacheConfig.medium, null);
    public static final Property enableWebStorage = BBoxService.newProperty((int)0, (boolean)true, null);
    public static final Property logClientErrors = BBoxService.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BBoxService.class);
    private static final String FRAME_CLIENT_ENV = "c";
    private static final String FRAME_MESSAGES = "m";
    private static final String FRAME_PROTOCOL = "p";
    private static final String FRAME_SEQUENCE_NUMBER = "n";
    private static final String FRAME_VERSION = "v";
    private static final String MESSAGE_BODY = "b";
    private static final String MESSAGE_CHANNEL_NAME = "c";
    private static final String MESSAGE_COMMS_FAIL = "cf";
    private static final String MESSAGE_ERROR_TYPE = "et";
    private static final String MESSAGE_KEY = "k";
    private static final String MESSAGE_REQUEST_NUMBER = "r";
    private static final String MESSAGE_TYPE = "t";
    private static final String MESSAGE_TYPE_REQUEST = "rt";
    private static final String MESSAGE_TYPE_RESPONSE_ERROR = "e";
    private static final String MESSAGE_TYPE_RESPONSE_OK = "rp";
    public static final String BOX_VERSION = "2.2";
    public static final Logger log = Logger.getLogger("box");
    private static final BIcon icon = BIcon.std((String)"navOnly/boxService.png");
    private final Set<IBoxListener> listeners = new HashSet<IBoxListener>();
    private volatile boolean hasListeners;
    private static final Object sessionMonitor = new Object();
    private volatile int sessionLimit = -1;
    private volatile int sessionCount;
    public static final BBoxClientEnv defaultClientEnv = BBajaScriptClientEnv.INSTANCE;

    public BBoxServlet getServlet() {
        return (BBoxServlet)this.get(servlet);
    }

    public void setServlet(BBoxServlet v) {
        this.set(servlet, (BValue)v, null);
    }

    public BBoxWebSocketAcceptor getWebSocketAcceptor() {
        return (BBoxWebSocketAcceptor)this.get(webSocketAcceptor);
    }

    public void setWebSocketAcceptor(BBoxWebSocketAcceptor v) {
        this.set(webSocketAcceptor, (BValue)v, null);
    }

    public BFoxBoxAcceptor getFoxAcceptor() {
        return (BFoxBoxAcceptor)this.get(foxAcceptor);
    }

    public void setFoxAcceptor(BFoxBoxAcceptor v) {
        this.set(foxAcceptor, (BValue)v, null);
    }

    public BSysChannel getSys() {
        return (BSysChannel)this.get(sys);
    }

    public void setSys(BSysChannel v) {
        this.set(sys, (BValue)v, null);
    }

    public BRegistryChannel getReg() {
        return (BRegistryChannel)this.get(reg);
    }

    public void setReg(BRegistryChannel v) {
        this.set(reg, (BValue)v, null);
    }

    public BTimeZoneChannel getTimeZone() {
        return (BTimeZoneChannel)this.get(timeZone);
    }

    public void setTimeZone(BTimeZoneChannel v) {
        this.set(timeZone, (BValue)v, null);
    }

    public BUnitChannel getUnit() {
        return (BUnitChannel)this.get(unit);
    }

    public void setUnit(BUnitChannel v) {
        this.set(unit, (BValue)v, null);
    }

    public BHistoryChannel getHistory() {
        return (BHistoryChannel)this.get(history);
    }

    public void setHistory(BHistoryChannel v) {
        this.set(history, (BValue)v, null);
    }

    public BAlarmChannel getAlarm() {
        return (BAlarmChannel)this.get(alarm);
    }

    public void setAlarm(BAlarmChannel v) {
        this.set(alarm, (BValue)v, null);
    }

    public BServerSessionChannel getSsession() {
        return (BServerSessionChannel)this.get(ssession);
    }

    public void setSsession(BServerSessionChannel v) {
        this.set(ssession, (BValue)v, null);
    }

    public BOrdChannel getOrd() {
        return (BOrdChannel)this.get(ord);
    }

    public void setOrd(BOrdChannel v) {
        this.set(ord, (BValue)v, null);
    }

    public BTransferChannel getTransfer() {
        return (BTransferChannel)this.get(transfer);
    }

    public void setTransfer(BTransferChannel v) {
        this.set(transfer, (BValue)v, null);
    }

    public BServerCacheConfig getServerCacheConfig() {
        return (BServerCacheConfig)this.get(serverCacheConfig);
    }

    public void setServerCacheConfig(BServerCacheConfig v) {
        this.set(serverCacheConfig, (BValue)v, null);
    }

    public boolean getEnableWebStorage() {
        return this.getBoolean(enableWebStorage);
    }

    public void setEnableWebStorage(boolean v) {
        this.setBoolean(enableWebStorage, v, null);
    }

    public boolean getLogClientErrors() {
        return this.getBoolean(logClientErrors);
    }

    public void setLogClientErrors(boolean v) {
        this.setBoolean(logClientErrors, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void serviceStarted() throws Exception {
        this.setFlags((Slot)enabled, this.getFlags((Slot)enabled) | 4);
        for (TypeInfo t : Sys.getRegistry().getConcreteTypes(BBoxChannel.TYPE.getTypeInfo())) {
            BBoxChannel channel = (BBoxChannel)t.getInstance();
            if (this.get(channel.getChannelName()) != null) continue;
            this.add(channel.getChannelName(), (BValue)channel);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        if (property == serverCacheConfig && this.isRunning()) {
            this.getReg().clearBuilder(this.getServerCacheConfig());
        }
    }

    public void handleRequest(InputStream in, Writer writer, BoxOp op) throws Exception {
        if (BBoxService.peekFirst(in = BBoxService.toMarkableInputStream(in)) == 70) {
            this.handleBoxFragment(in, writer, op);
        } else {
            JSONObject obj = new JSONObject(new JSONTokener((Reader)new InputStreamReader(in)));
            this.handleBoxFrame(obj, writer, op);
        }
    }

    private void handleBoxFragment(InputStream in, Writer writer, BoxOp op) throws Exception {
        try {
            Scanner s = new Scanner(in);
            s.useDelimiter(";");
            String fragmentMarker = s.next();
            String boxVersion = s.next();
            String sessionId = s.next();
            long envelopeId = s.nextLong();
            int fragmentIndex = s.nextInt();
            int fragmentCount = s.nextInt();
            boolean unsolicited = "u".equals(s.next());
            s.skip(";");
            s.useDelimiter("\\A");
            byte[] payload = s.next().getBytes(StandardCharsets.UTF_8);
            BServerSession serverSession = this.validateFragmentServerSession(sessionId, op);
            serverSession.handleFragment(envelopeId, fragmentIndex, fragmentCount, payload, op);
        }
        catch (Exception e) {
            this.logAndThrowRequestError(e, op);
        }
    }

    public void handleBoxFrame(JSONObject frame, Writer writer, BoxOp op) throws Exception {
        block11: {
            try {
                Writer writ;
                BBoxService.validateBoxFrame(frame, op);
                boolean traceOn = log.isLoggable(Level.FINE);
                ByteArrayOutputStream baos = null;
                if (traceOn || this.hasListeners) {
                    if (traceOn) {
                        log.fine(BBoxService.makeLogMsg("BOX Request - " + frame.toString(2), (Context)op));
                    }
                    if (this.hasListeners) {
                        this.notifyListeners((Context)op, BBoxRecordType.request, frame.toString());
                    }
                    baos = new ByteArrayOutputStream();
                    writ = new OutputStreamWriter(baos);
                } else {
                    writ = writer;
                }
                BoxWriter out = new BoxWriter(writ);
                out.object().key(FRAME_VERSION).value((Object)BOX_VERSION).key(FRAME_PROTOCOL).value((Object)"box");
                if (frame.has(FRAME_SEQUENCE_NUMBER)) {
                    out.key(FRAME_SEQUENCE_NUMBER).value(frame.getLong(FRAME_SEQUENCE_NUMBER));
                }
                out.key(FRAME_MESSAGES).array();
                this.handleMessages(frame, out, op);
                out.endArray();
                out.endObject();
                writ.flush();
                if (!traceOn && !this.hasListeners) break block11;
                byte[] respData = baos.toByteArray();
                String respStr = new String(respData, StandardCharsets.UTF_8);
                if (traceOn) {
                    try {
                        log.fine(BBoxService.makeLogMsg("Response - " + new JSONObject(respStr).toString(2), (Context)op));
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, BBoxService.makeLogMsg("Response - " + respStr, (Context)op), e);
                    }
                }
                if (this.hasListeners) {
                    this.notifyListeners((Context)op, BBoxRecordType.response, respData);
                }
                writer.write(respStr);
                writer.flush();
            }
            catch (Exception e) {
                this.logAndThrowRequestError(e, op);
            }
        }
    }

    private void logAndThrowRequestError(Exception e, BoxOp op) throws Exception {
        if (this.hasListeners) {
            this.notifyListeners((Context)op, e);
        }
        log.log(Level.SEVERE, BBoxService.makeLogMsg("Processing Request", (Context)op), e);
        throw e;
    }

    private static String escapeXSS(String str) {
        if (str == null) {
            return null;
        }
        return XWriter.safeToString((String)str, (boolean)false);
    }

    private static void validateBoxFrame(JSONObject frame, BoxOp op) throws Exception {
        String protocol = BBoxService.getProtocol(frame);
        String clientEnvTypeSpec = BBoxService.getClientEnvironment(frame);
        String version = BBoxService.getVersion(frame);
        if (!"box".equals(protocol)) {
            throw new Exception("Unsupported JSON Protocol: " + protocol);
        }
        if (clientEnvTypeSpec != null) {
            op.setClientEnv((BBoxClientEnv)Sys.getType((String)clientEnvTypeSpec).getInstance());
        }
        if (version != null) {
            op.setVersion(version);
        }
    }

    private void handleMessages(JSONObject frame, BoxWriter out, BoxOp op) {
        JSONArray messages = frame.getJSONArray(FRAME_MESSAGES);
        try {
            this.validateFrameServerSession(frame, op);
        }
        catch (Exception e) {
            int len = messages.length();
            for (int i = 0; i < len; ++i) {
                out.value((Object)this.handleMessageError(op, e, messages.getJSONObject(i)));
            }
            return;
        }
        HashMap<BServerSession, List> messagesForSessions = new HashMap<BServerSession, List>();
        for (int i = 0; i < messages.length(); ++i) {
            JSONObject m = messages.getJSONObject(i);
            try {
                BServerSession serverSession = this.getServerSession(m, op);
                messagesForSessions.computeIfAbsent(serverSession, k -> new ArrayList()).add(m);
                continue;
            }
            catch (ServerSessionException e) {
                this.handleMessage(m, out, op);
            }
        }
        messagesForSessions.forEach((session, msgList) -> session.synchronizedOnEventBroker(() -> msgList.forEach(m -> this.handleMessage((JSONObject)m, out, op))));
    }

    private BServerSession getServerSession(JSONObject boxObject, BoxOp op) throws ServerSessionException {
        return this.getSsession().getServerSession(boxObject, op);
    }

    private void validateFrameServerSession(JSONObject frame, BoxOp op) throws ServerSessionException {
        try {
            this.getServerSession(frame, op).renew();
        }
        catch (ServerSessionException e) {
            JSONArray messages = BBoxService.getMessages(frame);
            int len = messages.length();
            for (int i = 0; i < len; ++i) {
                if (!BBoxService.requiresServerSession(messages.getJSONObject(i))) continue;
                throw e;
            }
        }
    }

    private BServerSession validateFragmentServerSession(String sessionId, BoxOp op) throws ServerSessionException {
        BServerSession session = this.getSsession().getServerSession(sessionId, op);
        session.renew();
        return session;
    }

    private static boolean requiresServerSession(JSONObject boxMessage) {
        String channelName = BBoxService.getChannelName(boxMessage);
        String key = BBoxService.getKeyName(boxMessage);
        return !"ssession".equals(channelName) || !"make".equals(key);
    }

    private void handleMessage(JSONObject boxMessage, BoxWriter out, BoxOp op) {
        String messageType = BBoxService.getMessageType(boxMessage);
        String channelName = BBoxService.getChannelName(boxMessage);
        String keyName = BBoxService.getKeyName(boxMessage);
        long requestNumber = BBoxService.getRequestNumber(boxMessage);
        if (!MESSAGE_TYPE_REQUEST.equals(messageType)) {
            return;
        }
        BoxWriter messageOut = BBoxService.makeMessageWriter(channelName, keyName, requestNumber);
        try {
            if (this.isFatalFault()) {
                throw new BoxServiceFatalFaultException((Context)op);
            }
            if (!this.isOperational()) {
                throw new BoxServiceNonOperationalException((Context)op);
            }
            BBoxChannel channel = (BBoxChannel)this.get(channelName);
            if (channel == null) {
                throw new Exception("Could not find Box Channel to service request: " + channelName);
            }
            messageOut.key(MESSAGE_BODY);
            boolean handled = channel.service(keyName, boxMessage.get(MESSAGE_BODY), messageOut, op);
            if (!handled) {
                throw new Exception("Unsupported Key: " + keyName + " for Box Channel: " + channelName);
            }
            messageOut.key(MESSAGE_TYPE).value((Object)MESSAGE_TYPE_RESPONSE_OK);
            messageOut.endObject();
        }
        catch (Throwable e) {
            messageOut = this.handleMessageError(op, e, channelName, keyName, requestNumber);
        }
        out.value((Object)messageOut);
    }

    private BoxWriter handleMessageError(BoxOp op, Throwable e, JSONObject boxMessage) {
        String channelName = BBoxService.getChannelName(boxMessage);
        String keyName = BBoxService.getKeyName(boxMessage);
        long requestNumber = BBoxService.getRequestNumber(boxMessage);
        return this.handleMessageError(op, e, channelName, keyName, requestNumber);
    }

    private BoxWriter handleMessageError(BoxOp op, Throwable e, String channelName, String keyName, long requestNumber) {
        BoxWriter messageOut = BBoxService.makeMessageWriter(channelName, keyName, requestNumber);
        if (e instanceof BoxCommsFailed) {
            BoxCommsFailed commsErr = (BoxCommsFailed)e;
            messageOut.key(MESSAGE_ERROR_TYPE).value((Object)commsErr.getBsonErrorType());
            messageOut.key(MESSAGE_COMMS_FAIL).value(true);
        } else {
            messageOut.key(MESSAGE_ERROR_TYPE).value((Object)"BoxError");
        }
        log.log(Level.SEVERE, BBoxService.makeLogMsg("Request", (Context)op), e);
        if (this.hasListeners) {
            this.notifyListeners((Context)op, e);
        }
        messageOut.key(MESSAGE_TYPE).value((Object)MESSAGE_TYPE_RESPONSE_ERROR);
        BBoxService.encodeException((JSONWriter)messageOut.key(MESSAGE_BODY), e, (Context)op);
        messageOut.endObject();
        return messageOut;
    }

    public static void encodeException(JSONWriter writer, Throwable e, Context cx) {
        String message;
        StringWriter stackWriter = new StringWriter();
        if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
            message = Lexicon.make((String)"baja").getText("niagaraRpc.securityMessage");
        } else {
            if (BBoxService.shouldShowStackTrace()) {
                e.printStackTrace(new PrintWriter(stackWriter));
            }
            message = e instanceof BsonDecoderPlugin.BsonException ? Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getHtmlSafeText("decoder.bsonException.message") : (e instanceof Localizable ? ((Localizable)e).toString(cx) : e.getLocalizedMessage());
        }
        writer.object().key("isErr").value(true).key("c").value((Object)e.getClass().getName()).key(FRAME_MESSAGES).value((Object)BBoxService.escapeXSS(message)).key("s").value((Object)BBoxService.escapeXSS(stackWriter.toString())).endObject();
    }

    private static boolean shouldShowStackTrace() {
        try {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            return webService.getShowStackTrace();
        }
        catch (ServiceNotFoundException svcEx) {
            return true;
        }
    }

    private static BoxWriter makeMessageWriter(String channelName, String keyName, long requestNumber) throws JSONException {
        BoxWriter out = new BoxWriter();
        out.object();
        out.key("c").value((Object)channelName);
        out.key(MESSAGE_KEY).value((Object)keyName);
        out.key(MESSAGE_REQUEST_NUMBER).value(requestNumber);
        return out;
    }

    private static InputStream toMarkableInputStream(InputStream in) {
        return in.markSupported() ? in : new BufferedInputStream(in);
    }

    private static int peekFirst(InputStream in) throws IOException {
        in.mark(1);
        int c = in.read();
        in.reset();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IBoxListener listener) {
        Set<IBoxListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            this.hasListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IBoxListener listener) {
        Set<IBoxListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            this.hasListeners = !this.listeners.isEmpty();
        }
    }

    void notifyListeners(Context cx, Throwable th) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        th.printStackTrace(new PrintWriter(baos));
        this.notifyListeners(cx, BBoxRecordType.error, baos.toByteArray());
    }

    void notifyListeners(Context cx, BBoxRecordType recordType, String data) {
        this.notifyListeners(cx, recordType, data.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(Context cx, BBoxRecordType recordType, byte[] data) {
        Set<IBoxListener> set = this.listeners;
        synchronized (set) {
            if (this.hasListeners) {
                String userName = cx.getUser() != null ? cx.getUser().getName() : "";
                BAbsTime timestamp = BAbsTime.now();
                String host = cx.getFacets().gets("remoteHost", "");
                int port = cx.getFacets().geti("remotePort", -1);
                for (IBoxListener listener : this.listeners) {
                    try {
                        listener.newRecord(timestamp, recordType, userName, host, port, data);
                    }
                    catch (Throwable err) {
                        log.log(Level.SEVERE, "Error notifying Listeners", err);
                    }
                }
            }
        }
    }

    boolean hasListeners() {
        return this.hasListeners;
    }

    static String makeLogMsg(String title, Context cx) {
        if (cx != null) {
            return String.format("%s: %s @ %s ( %s )", title, cx.getUser() != null ? cx.getUser().getName() : "", cx.getFacets().gets("remoteHost", ""), cx.getFacets().gets("remotePort", ""));
        }
        return String.format("%s: null Context", title);
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "box");
        String limit = feature.get("session.limit", "none");
        this.sessionLimit = limit.equals("none") ? -1 : Integer.parseInt(limit);
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void incrementSessionCount() {
        Object object = sessionMonitor;
        synchronized (object) {
            ++this.sessionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void decrementSessionCount() {
        Object object = sessionMonitor;
        synchronized (object) {
            --this.sessionCount;
        }
    }

    final int getSessionCount() {
        return this.sessionCount;
    }

    final int getSessionLimit() {
        return this.sessionLimit;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Session Limit");
        out.prop((Object)"Limit", (Object)(this.sessionLimit == -1 ? "none" : String.valueOf(this.sessionLimit)));
        out.prop((Object)"Active Count", this.sessionCount);
        out.endProps();
        super.spy(out);
    }

    private static String getClientEnvironment(JSONObject boxFrame) {
        return boxFrame.has("c") ? BBoxService.escapeXSS(JSONUtil.getString((JSONObject)boxFrame, (String)"c")) : null;
    }

    private static String getChannelName(JSONObject boxMessage) {
        return SlotPath.escape((String)JSONUtil.getString((JSONObject)boxMessage, (String)"c"));
    }

    private static String getKeyName(JSONObject boxMessage) {
        return BBoxService.escapeXSS(JSONUtil.getString((JSONObject)boxMessage, (String)MESSAGE_KEY)).intern();
    }

    private static JSONArray getMessages(JSONObject boxFrame) {
        return boxFrame.getJSONArray(FRAME_MESSAGES);
    }

    private static String getMessageType(JSONObject boxMessage) {
        return JSONUtil.getString((JSONObject)boxMessage, (String)MESSAGE_TYPE);
    }

    private static String getProtocol(JSONObject boxFrame) {
        return BBoxService.escapeXSS(JSONUtil.getString((JSONObject)boxFrame, (String)FRAME_PROTOCOL));
    }

    private static long getRequestNumber(JSONObject boxMessage) {
        return boxMessage.getLong(MESSAGE_REQUEST_NUMBER);
    }

    private static String getVersion(JSONObject boxFrame) {
        return boxFrame.has(FRAME_VERSION) ? BBoxService.escapeXSS(JSONUtil.getString((JSONObject)boxFrame, (String)FRAME_VERSION)) : null;
    }

    private class BoxServiceNonOperationalException
    extends BoxCommsFailed {
        public BoxServiceNonOperationalException(Context cx) {
            super(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("service.notOperational"));
        }

        @Override
        String getBsonErrorType() {
            return "BoxNonOperationalError";
        }
    }

    private class BoxServiceFatalFaultException
    extends BoxCommsFailed {
        public BoxServiceFatalFaultException(Context cx) {
            super(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("service.fatalFault", new Object[]{BBoxService.this.getFaultCause()}));
        }

        @Override
        String getBsonErrorType() {
            return "BoxFatalFaultError";
        }
    }

    static abstract class BoxCommsFailed
    extends Exception {
        protected BoxCommsFailed(String msg) {
            super(msg);
        }

        abstract String getBsonErrorType();
    }

    public static interface IBoxListener {
        public void newRecord(BAbsTime var1, BBoxRecordType var2, String var3, String var4, int var5, byte[] var6);
    }
}

