/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.box.BAlarmChannel;
import com.tridium.box.BServerSession;
import com.tridium.box.BServerSessionHandler;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.alarm.AlarmSpaceConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSource;
import javax.baja.collection.AbstractReverseCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.security.BIProtected;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

@NiagaraType
public final class BAlarmConsoleSummarySessionHandler
extends BServerSessionHandler
implements BiConsumer<BConsoleRecipient, BAlarmRecord> {
    public static final Type TYPE = Sys.loadType(BAlarmConsoleSummarySessionHandler.class);
    private Map<BOrdList, Row> newAlarmBuffer;
    private IntHashMap ackStates;
    private HashMap<BOrdList, Long> mostRecentPerSource;
    private final Object alarmMonitor = new Object();
    private static int ALARM_DOWNLOAD_LIMIT = AccessController.doPrivileged(() -> Integer.getInteger("box.alarmconsole.alarmlimit", 100));
    private BConsoleRecipient recipient;
    private BAlarmService service;
    private BUser user;
    private BFilterSet filterSet;
    private Map<String, Set<String>> alarmClasses;
    private final int alarmDownloadLimit;
    private AlarmSpaceConnection initialConnection;
    private Cursor<BAlarmSource> initialSources;
    private long lastInitialQueryTime = 0L;
    private long initialQueryTotalIterationCount = 0L;
    private long initialQueryAlarmSourceIterationCount = 0L;
    private long initialQueryAlarmEncodingCount = 0L;
    private long initialQueryMultiSourceSummaryCount = 0L;
    private static final Logger LOG = Logger.getLogger("box.alarmConsoleSummarySessionHandler");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAlarmConsoleSummarySessionHandler() {
        this.alarmDownloadLimit = ALARM_DOWNLOAD_LIMIT;
    }

    public BAlarmConsoleSummarySessionHandler(BConsoleRecipient recipient, BUser user, BFilterSet filterSet, BAlarmService service, Map<String, Set<String>> alarmClasses, int alarmDownloadLimit) {
        this.recipient = recipient;
        this.user = user;
        this.filterSet = filterSet;
        this.service = service;
        this.alarmClasses = alarmClasses;
        this.alarmDownloadLimit = alarmDownloadLimit;
    }

    @Override
    public Object init(Object arg, BoxOp op) throws Exception {
        JSONObject params = (JSONObject)arg;
        if (this.recipient == null) {
            this.recipient = BAlarmChannel.decodeConsoleRecipient(params, (Context)op);
        }
        BAlarmConsoleSummarySessionHandler.checkReadPermissions((BIProtected)this.recipient, (Context)op);
        if (this.user == null) {
            this.user = op.getUser();
        }
        if (this.filterSet == null) {
            this.filterSet = BAlarmChannel.decodeFilterSet(params, (Context)op);
        }
        if (this.alarmClasses == null) {
            this.alarmClasses = BAlarmChannel.getAllSubscribedAlarmClasses((BAlarmRecipient)this.recipient, this.service, this.user);
        }
        return null;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "queryMultiSourceSummary": {
                this.queryMultiSourceSummary((JSONWriter)out, (Context)op);
                return true;
            }
            case "completeInitialization": {
                this.completeInitialization((JSONWriter)out);
                return true;
            }
        }
        return false;
    }

    public void started() throws Exception {
        if (this.service == null) {
            this.service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        this.newAlarmBuffer = new LinkedHashMap<BOrdList, Row>();
        this.ackStates = new IntHashMap();
        this.mostRecentPerSource = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        if (this.recipient != null) {
            this.recipient.unregisterAlarmHandler((BiConsumer)this);
        }
        this.closeInitialAlarmConnection();
        Object object = this.alarmMonitor;
        synchronized (object) {
            this.newAlarmBuffer.clear();
            this.ackStates.clear();
            this.mostRecentPerSource.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object detachEvents(BoxOp op) throws Exception {
        BServerSession serverSession;
        JSONObject data = null;
        boolean moreAlarms = false;
        Object object = this.alarmMonitor;
        synchronized (object) {
            if (!this.newAlarmBuffer.isEmpty()) {
                JSONObject sources = new JSONObject();
                Iterator<BOrdList> iterator = this.newAlarmBuffer.keySet().iterator();
                while (iterator.hasNext()) {
                    BOrdList src = iterator.next();
                    Row row = this.newAlarmBuffer.get(src);
                    iterator.remove();
                    JSONObject jsonRow = new JSONObject();
                    try {
                        if (row.record != null) {
                            jsonRow.put("record", (Object)BAlarmChannel.encodeAlarm(row.record, (Context)op));
                        }
                    }
                    catch (IOException err) {
                        throw new RuntimeException(err);
                    }
                    jsonRow.put("open", row.open);
                    jsonRow.put("acked", row.acked);
                    jsonRow.put("unacked", row.unacked);
                    jsonRow.put("ackPending", row.ackPending);
                    sources.put(src.toString(), (Object)jsonRow);
                    if (sources.length() < this.alarmDownloadLimit) continue;
                    break;
                }
                data = new JSONObject();
                data.put("sources", (Object)sources);
                moreAlarms = !this.newAlarmBuffer.isEmpty();
            }
        }
        if (data != null) {
            JSONObject sourcesObj = data.getJSONObject("sources");
            Iterator it = sourcesObj.keys();
            while (it.hasNext()) {
                BAlarmRecord record;
                String source = (String)it.next();
                JSONObject sourceObj = sourcesObj.getJSONObject(source);
                if (sourceObj.has("record") || (record = this.getLatestOpenAlarmForSource(BOrdList.make((String)source))) == null) continue;
                sourceObj.put("record", (Object)BAlarmChannel.encodeAlarm(record, (Context)op));
            }
        }
        if (moreAlarms && (serverSession = this.getServerSession()) != null) {
            serverSession.newEvents(this);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(BConsoleRecipient recipient, BAlarmRecord record) {
        if (BAlarmChannel.canShowAlarmRecord(record, this.alarmClasses, this.getAllAlarmClassesFromAlarmService()) && (this.filterSet.getPropertyCount() <= 0 || this.filterAccept(record))) {
            boolean isOpen = record.isOpen();
            Object object = this.alarmMonitor;
            synchronized (object) {
                boolean forceCleared;
                BAckState oldAckState = (BAckState)this.ackStates.get(record.getUuid().hashCode());
                Row row = this.newAlarmBuffer.computeIfAbsent(record.getSource(), key -> new Row());
                boolean bl = forceCleared = record.getAlarmData().get("forceCleared") != null && record.isAcknowledged() && record.isNormal();
                if (oldAckState != null) {
                    if (oldAckState != BAckState.acked && oldAckState != BAckState.ackPending && record.isAckPending()) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("unacked->ackPending");
                        }
                        row.unacked--;
                        row.ackPending++;
                    } else if (oldAckState == BAckState.ackPending && record.isAcknowledged()) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("ackPending->acked");
                        }
                        row.ackPending--;
                        if (isOpen) {
                            row.acked++;
                        }
                    } else if (oldAckState == BAckState.ackPending && !record.isAcknowledged() && !record.isAckPending()) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("ackPending->unacked");
                        }
                        row.ackPending--;
                        if (isOpen) {
                            row.unacked++;
                        }
                    } else if (oldAckState == BAckState.acked && !record.isAcknowledged() && !record.isAckPending()) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("acked->unacked");
                        }
                        row.acked--;
                        if (isOpen) {
                            row.unacked++;
                        }
                    } else if (oldAckState == BAckState.acked && record.isAckPending()) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("acked->ackPending");
                        }
                        row.acked--;
                        if (isOpen) {
                            row.ackPending++;
                        }
                    } else if (record.isAcknowledged() && oldAckState != BAckState.acked && oldAckState != BAckState.ackPending) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("unacked->acked");
                        }
                        row.unacked--;
                        if (isOpen) {
                            row.acked++;
                        }
                    } else if (record.isAcknowledged() && oldAckState == BAckState.acked && forceCleared) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("acked->acked+forceCleared");
                        }
                        row.acked--;
                    } else if (record.isAcknowledged() && oldAckState == BAckState.acked && !isOpen) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("acked->acked+!open");
                        }
                        row.acked--;
                    } else if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Unknown transition: " + oldAckState + "->" + record.getAckState().getTag());
                    }
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Cannot find previous state: " + record.getAckState().getTag());
                    }
                    if (record.isAcknowledged()) {
                        if (isOpen) {
                            row.acked++;
                        } else {
                            row.acked--;
                        }
                    } else if (record.isAckPending()) {
                        if (isOpen) {
                            row.ackPending++;
                        } else {
                            row.ackPending--;
                        }
                    } else if (isOpen) {
                        row.unacked++;
                    } else {
                        row.unacked--;
                    }
                }
                if (LOG.isLoggable(Level.FINEST) && forceCleared) {
                    LOG.finest("force cleared detected");
                }
                row.open = isOpen;
                Long mostRecentTimestamp = this.mostRecentPerSource.get(record.getSource());
                if (isOpen) {
                    boolean newRecordIsMostRecent;
                    boolean bl2 = newRecordIsMostRecent = mostRecentTimestamp == null || record.getTimestamp().getMillis() >= mostRecentTimestamp;
                    if (newRecordIsMostRecent) {
                        row.record = (BAlarmRecord)record.newCopy(true);
                        this.mostRecentPerSource.put(record.getSource(), record.getTimestamp().getMillis());
                    }
                    this.ackStates.put(record.getUuid().hashCode(), (Object)record.getAckState());
                } else {
                    row.record = null;
                    this.ackStates.remove(record.getUuid().hashCode());
                    if (mostRecentTimestamp != null && record.getTimestamp().getMillis() >= mostRecentTimestamp) {
                        this.mostRecentPerSource.remove(record.getSource());
                    }
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(row.toString());
                }
            }
            BServerSession serverSession = this.getServerSession();
            if (serverSession != null) {
                serverSession.newEvents(this);
            }
        }
    }

    public void completeInitialization(JSONWriter out) {
        this.closeInitialAlarmConnection();
        this.recipient.registerAlarmHandler((BiConsumer)this);
        out.object().endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryMultiSourceSummary(JSONWriter out, Context cx) throws Exception {
        boolean useFilter;
        ++this.initialQueryMultiSourceSummaryCount;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting multi source summary query");
        }
        long t0 = Clock.ticks();
        boolean bl = useFilter = this.filterSet.getPropertyCount() > 0;
        if (this.initialConnection == null || this.initialSources == null) {
            this.initialConnection = this.service.getAlarmDb().getConnection(cx);
            this.initialSources = this.initialConnection.getOpenAlarmSources();
        }
        out.object().key("sources").object();
        int count = 0;
        boolean moreAlarms = false;
        Set<String> allAlarmClassNames = this.getAllAlarmClassesFromAlarmService();
        Object object = this.alarmMonitor;
        synchronized (object) {
            while (this.initialSources.next()) {
                ++this.initialQueryAlarmSourceIterationCount;
                ++this.initialQueryTotalIterationCount;
                BOrdList source = ((BAlarmSource)this.initialSources.get()).getSourceOrdList();
                try (Cursor cursor = this.initialConnection.getOpenAlarmsForSource(source);){
                    BAlarmRecord lastAcceptedAlarm;
                    BUuid lastAcceptedAlarmUuid = null;
                    int acked = 0;
                    int unacked = 0;
                    int ackPending = 0;
                    while (cursor.next()) {
                        ++this.initialQueryTotalIterationCount;
                        BAlarmRecord alarm = (BAlarmRecord)cursor.get();
                        if (!BAlarmChannel.canShowAlarmRecord(alarm, this.alarmClasses, allAlarmClassNames) || useFilter && !this.filterAccept(alarm)) continue;
                        switch (alarm.getAckState().getOrdinal()) {
                            case 0: {
                                ++acked;
                                break;
                            }
                            case 2: {
                                ++ackPending;
                                break;
                            }
                            default: {
                                ++unacked;
                            }
                        }
                        this.ackStates.put(alarm.getUuid().hashCode(), (Object)alarm.getAckState());
                        this.mostRecentPerSource.put(source, alarm.getTimestamp().getMillis());
                        lastAcceptedAlarmUuid = alarm.getUuid();
                    }
                    if (lastAcceptedAlarmUuid != null && (lastAcceptedAlarm = this.initialConnection.getRecord(lastAcceptedAlarmUuid)) != null) {
                        out.key(source.toString()).object();
                        out.key("record").value((Object)BAlarmChannel.encodeAlarm(lastAcceptedAlarm, cx));
                        out.key("open").value(true);
                        out.key("acked").value((long)acked);
                        out.key("unacked").value((long)unacked);
                        out.key("ackPending").value((long)ackPending);
                        out.endObject();
                        ++this.initialQueryAlarmEncodingCount;
                    }
                }
                if (++count < this.alarmDownloadLimit) continue;
                moreAlarms = true;
                break;
            }
        }
        out.endObject();
        out.key("moreAlarms").value(moreAlarms);
        out.endObject();
        this.lastInitialQueryTime = Clock.ticks() - t0;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Finished multi source summary query: " + this.lastInitialQueryTime + "ms");
        }
    }

    private void closeInitialAlarmConnection() {
        if (this.initialSources != null) {
            try {
                this.initialSources.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initialSources = null;
        }
        if (this.initialConnection != null) {
            try {
                this.initialConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initialConnection = null;
        }
    }

    public boolean isInitialAlarmConnectionOpen() {
        return this.initialSources != null && this.initialConnection != null;
    }

    public BAlarmRecord getLatestOpenAlarmForSource(BOrdList source) throws IOException {
        BAlarmRecord latestOpenAlarm = null;
        boolean useFilter = this.filterSet.getPropertyCount() > 0;
        Set<String> allAlarmClassNames = this.getAllAlarmClassesFromAlarmService();
        try (AlarmSpaceConnection conn = this.service.getAlarmDb().getConnection((Context)new BasicContext(this.user));
             Cursor cursor = conn.getOpenAlarmsForSource(source);){
            BAlarmRecord alarm;
            boolean reversed = false;
            BUuid latestOpenAlarmUuid = null;
            Cursor alarmCursor = cursor;
            if (cursor instanceof AbstractReverseCursor) {
                alarmCursor = ((AbstractReverseCursor)cursor).getReverseCursor();
                reversed = true;
            }
            while (alarmCursor.next() && BAlarmChannel.canShowAlarmRecord(alarm = (BAlarmRecord)alarmCursor.get(), this.alarmClasses, allAlarmClassNames)) {
                if (useFilter && !this.filterAccept(alarm)) continue;
                latestOpenAlarmUuid = alarm.getUuid();
                if (!reversed) continue;
                break;
            }
            if (latestOpenAlarmUuid != null) {
                latestOpenAlarm = conn.getRecord(latestOpenAlarmUuid);
            }
        }
        return latestOpenAlarm;
    }

    private boolean filterAccept(BAlarmRecord record) {
        try {
            return this.filterSet.accept((BComplex)record);
        }
        catch (Exception err) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Alarm Console BQL filter accept error", err);
            }
            return false;
        }
    }

    public Map<BOrdList, Row> getNewAlarmBuffer() {
        return this.newAlarmBuffer == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.newAlarmBuffer);
    }

    public Map<Integer, BAckState> getAckStates() {
        if (this.ackStates == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, BAckState> states = new HashMap<Integer, BAckState>(this.ackStates.size());
        IntHashMap.Iterator it = this.ackStates.iterator();
        while (it.hasNext()) {
            it.next();
            int key = it.key();
            states.put(key, (BAckState)this.ackStates.get(key));
        }
        return Collections.unmodifiableMap(states);
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Alarm Classes Priorities");
        out.prop((Object)"Alarm Classes", (Object)this.toDebugAlarmClasses("default"));
        out.prop((Object)"Alarm Escalation 1", (Object)this.toDebugAlarmClasses("level1"));
        out.prop((Object)"Alarm Escalation 2", (Object)this.toDebugAlarmClasses("level2"));
        out.prop((Object)"Alarm Escalation 3", (Object)this.toDebugAlarmClasses("level3"));
        out.endProps();
        out.startProps("Alarm Console Information");
        out.prop((Object)"New alarm buffer size", this.newAlarmBuffer.size());
        out.prop((Object)"ackStates size", this.ackStates.size());
        out.prop((Object)"mostRecentPerSource size", this.mostRecentPerSource.size());
        out.prop((Object)"Initial last query time", (Object)BRelTime.toString((long)this.lastInitialQueryTime, (Context)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE)));
        out.prop((Object)"Initial query multi source summary calls", (double)this.initialQueryMultiSourceSummaryCount);
        out.prop((Object)"Initial query total iteration count", (double)this.initialQueryTotalIterationCount);
        out.prop((Object)"Initial query alarm source iteration count", (double)this.initialQueryAlarmSourceIterationCount);
        out.prop((Object)"Initial query alarm source iteration count", (double)this.initialQueryAlarmEncodingCount);
        out.prop((Object)"Alarm download limit", this.alarmDownloadLimit);
        out.endProps();
        super.spy(out);
    }

    private String toDebugAlarmClasses(String key) {
        return this.alarmClasses.get(key).stream().collect(Collectors.joining(","));
    }

    private Set<String> getAllAlarmClassesFromAlarmService() {
        return Arrays.stream(this.service.getAlarmClasses()).map(BComplex::getName).collect(Collectors.toSet());
    }

    public static final class Row {
        private BAlarmRecord record;
        private boolean open;
        private int acked = 0;
        private int unacked = 0;
        private int ackPending = 0;

        public BAlarmRecord getRecord() {
            return this.record;
        }

        public boolean isOpen() {
            return this.open;
        }

        public int getAcked() {
            return this.acked;
        }

        public int getUnacked() {
            return this.unacked;
        }

        public int getAckPending() {
            return this.ackPending;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("Alarm row update ->\n");
            out.append("  uuid: ").append((Object)(this.record == null ? "n/a" : this.record.getUuid())).append(",\n");
            out.append("  source: ").append((Object)(this.record == null ? "n/a" : this.record.getSource())).append(",\n");
            out.append("  source state: ").append(this.record == null ? "n/a" : this.record.getSourceState().getTag()).append(",\n");
            out.append("  open: ").append(this.open).append(",\n");
            out.append("  acked: ").append(this.acked).append(",\n");
            out.append("  unacked: ").append(this.unacked).append(",\n");
            out.append("  ackPending: ").append(this.ackPending);
            return out.toString();
        }
    }
}

