/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sysmon.BAbstractCPUMonitor;
import java.io.File;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="applicationToMonitor", type="String", defaultValue=""), @NiagaraProperty(name="lastInterval", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastIntervalPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="sinceStartPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastMinute", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastMinutePercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastHour", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastHourPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastDay", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastDayPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")})})
@NiagaraActions(value={@NiagaraAction(name="pollMinute", flags=4), @NiagaraAction(name="pollHour", flags=4), @NiagaraAction(name="pollDay", flags=4)})
public final class BUsedCPUMonitor
extends BAbstractCPUMonitor {
    public static final Property applicationToMonitor = BUsedCPUMonitor.newProperty((int)0, (String)"", null);
    public static final Property lastInterval = BUsedCPUMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastIntervalPercent = BUsedCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property sinceStartPercent = BUsedCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastMinute = BUsedCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastMinutePercent = BUsedCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastHour = BUsedCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastHourPercent = BUsedCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastDay = BUsedCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastDayPercent = BUsedCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Action pollMinute = BUsedCPUMonitor.newAction((int)4, null);
    public static final Action pollHour = BUsedCPUMonitor.newAction((int)4, null);
    public static final Action pollDay = BUsedCPUMonitor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BUsedCPUMonitor.class);
    Clock.Ticket pollMinuteTicket = null;
    Clock.Ticket pollHourTicket = null;
    Clock.Ticket pollDayTicket = null;
    long usedMillisecondsAtStart = 0L;
    long timeAtStart = 0L;
    long lastTriggerTimeMillis = 0L;
    long usedMillisAtPreviousInterval = 0L;
    long usedMillisAtPreviousMinute = 0L;
    long usedMillisAtPreviousHour = 0L;
    long usedMillisAtPreviousDay = 0L;

    public String getApplicationToMonitor() {
        return this.getString(applicationToMonitor);
    }

    public void setApplicationToMonitor(String v) {
        this.setString(applicationToMonitor, v, null);
    }

    public long getLastInterval() {
        return this.getLong(lastInterval);
    }

    public void setLastInterval(long v) {
        this.setLong(lastInterval, v, null);
    }

    public double getLastIntervalPercent() {
        return this.getDouble(lastIntervalPercent);
    }

    public void setLastIntervalPercent(double v) {
        this.setDouble(lastIntervalPercent, v, null);
    }

    public double getSinceStartPercent() {
        return this.getDouble(sinceStartPercent);
    }

    public void setSinceStartPercent(double v) {
        this.setDouble(sinceStartPercent, v, null);
    }

    public long getLastMinute() {
        return this.getLong(lastMinute);
    }

    public void setLastMinute(long v) {
        this.setLong(lastMinute, v, null);
    }

    public double getLastMinutePercent() {
        return this.getDouble(lastMinutePercent);
    }

    public void setLastMinutePercent(double v) {
        this.setDouble(lastMinutePercent, v, null);
    }

    public long getLastHour() {
        return this.getLong(lastHour);
    }

    public void setLastHour(long v) {
        this.setLong(lastHour, v, null);
    }

    public double getLastHourPercent() {
        return this.getDouble(lastHourPercent);
    }

    public void setLastHourPercent(double v) {
        this.setDouble(lastHourPercent, v, null);
    }

    public long getLastDay() {
        return this.getLong(lastDay);
    }

    public void setLastDay(long v) {
        this.setLong(lastDay, v, null);
    }

    public double getLastDayPercent() {
        return this.getDouble(lastDayPercent);
    }

    public void setLastDayPercent(double v) {
        this.setDouble(lastDayPercent, v, null);
    }

    public void pollMinute() {
        this.invoke(pollMinute, null, null);
    }

    public void pollHour() {
        this.invoke(pollHour, null, null);
    }

    public void pollDay() {
        this.invoke(pollDay, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "usedCPUTime_" + (this.getApplicationToMonitor().length() == 0 ? "currentProcess" : this.getApplicationToMonitor());
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:usedCPUCyclesToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:usedCPUCyclesToOffnormal)%";
    }

    @Override
    protected long checkCPU() {
        long usedThisInterval = 0L;
        try {
            String toMonitor;
            String string = toMonitor = this.getApplicationToMonitor().length() == 0 ? null : this.getApplicationToMonitor();
            if (File.separatorChar == '\\' && toMonitor != null && !toMonitor.endsWith(".exe")) {
                toMonitor = toMonitor + ".exe";
            }
            String toMonitorLambda = toMonitor;
            long usedNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getCpuTime(toMonitorLambda, true));
            usedThisInterval = usedNow - this.usedMillisAtPreviousInterval;
            long timeNow = System.currentTimeMillis();
            long timeElapsedMillis = (timeNow - this.lastTriggerTimeMillis) * (long)Runtime.getRuntime().availableProcessors();
            this.lastTriggerTimeMillis = timeNow;
            double percent = (double)usedThisInterval * 100.0 / (double)timeElapsedMillis;
            this.setLastInterval(usedThisInterval);
            this.setLastIntervalPercent(percent);
            this.usedMillisAtPreviousInterval = usedNow;
            long usedMillisSinceStart = usedNow - this.usedMillisecondsAtStart;
            timeElapsedMillis = (System.currentTimeMillis() - this.timeAtStart) * (long)Runtime.getRuntime().availableProcessors();
            double sinceStartPercent = (double)usedMillisSinceStart * 100.0 / (double)timeElapsedMillis;
            this.setSinceStartPercent(sinceStartPercent);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Used milliseconds in last interval: " + usedThisInterval + " (" + percent + "%)");
                this.getLog().trace("Used milliseconds since started: " + usedMillisSinceStart + " (" + sinceStartPercent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking CPU used cycles", (Throwable)e);
        }
        return usedThisInterval;
    }

    public void doPollMinute() {
        try {
            String toMonitor;
            String string = toMonitor = this.getApplicationToMonitor().length() == 0 ? null : this.getApplicationToMonitor();
            if (File.separatorChar == '\\' && toMonitor != null && !toMonitor.endsWith(".exe")) {
                toMonitor = toMonitor + ".exe";
            }
            String toMonitorLambda = toMonitor;
            long usedNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getCpuTime(toMonitorLambda, true));
            long usedThisMinute = usedNow - this.usedMillisAtPreviousMinute;
            long elapsed = 60000L * (long)Runtime.getRuntime().availableProcessors();
            double percent = (double)usedThisMinute * 100.0 / (double)elapsed;
            this.setLastMinute(usedThisMinute);
            this.setLastMinutePercent(percent);
            this.usedMillisAtPreviousMinute = usedNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Used milliseconds in last minute: " + usedThisMinute + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking minutely CPU used cycles", (Throwable)e);
        }
    }

    public void doPollHour() {
        try {
            String toMonitor;
            String string = toMonitor = this.getApplicationToMonitor().length() == 0 ? null : this.getApplicationToMonitor();
            if (File.separatorChar == '\\' && toMonitor != null && !toMonitor.endsWith(".exe")) {
                toMonitor = toMonitor + ".exe";
            }
            String toMonitorLambda = toMonitor;
            long usedNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getCpuTime(toMonitorLambda, true));
            long usedThisHour = usedNow - this.usedMillisAtPreviousHour;
            long elapsed = 3600000L * (long)Runtime.getRuntime().availableProcessors();
            double percent = (double)usedThisHour * 100.0 / (double)elapsed;
            this.setLastHour(usedThisHour);
            this.setLastHourPercent(percent);
            this.usedMillisAtPreviousHour = usedNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Used milliseconds in last hour: " + usedThisHour + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking hourly CPU used cycles", (Throwable)e);
        }
    }

    public void doPollDay() {
        try {
            String toMonitor;
            String string = toMonitor = this.getApplicationToMonitor().length() == 0 ? null : this.getApplicationToMonitor();
            if (File.separatorChar == '\\' && toMonitor != null && !toMonitor.endsWith(".exe")) {
                toMonitor = toMonitor + ".exe";
            }
            String toMonitorLambda = toMonitor;
            long usedNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getCpuTime(toMonitorLambda, true));
            long usedThisDay = usedNow - this.usedMillisAtPreviousDay;
            long elapsed = 86400000L * (long)Runtime.getRuntime().availableProcessors();
            double percent = (double)usedThisDay * 100.0 / (double)elapsed;
            this.setLastDay(usedThisDay);
            this.setLastDayPercent(percent);
            this.usedMillisAtPreviousDay = usedNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Used milliseconds in last day: " + usedThisDay + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking daily CPU used cycles", (Throwable)e);
        }
    }

    @Override
    public void changed(Property changedProperty, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(changedProperty, cxt);
        if (changedProperty == applicationToMonitor) {
            this.setLastDay(0L);
            this.setLastDayPercent(0.0);
            this.setLastHour(0L);
            this.setLastHourPercent(0.0);
            this.setLastMinute(0L);
            this.setLastMinutePercent(0.0);
            this.setLastInterval(0L);
            this.setLastIntervalPercent(0.0);
            this.setSinceStartPercent(0.0);
            try {
                this.doStarted();
            }
            catch (Exception e) {
                this.getLog().error("Failed to reset application statistics", (Throwable)e);
            }
        }
    }

    @Override
    public void doStarted() throws Exception {
        String toMonitor;
        String string = toMonitor = this.getApplicationToMonitor().length() == 0 ? null : this.getApplicationToMonitor();
        if (File.separatorChar == '\\' && toMonitor != null && !toMonitor.endsWith(".exe")) {
            toMonitor = toMonitor + ".exe";
        }
        String toMonitorLambda = toMonitor;
        this.usedMillisecondsAtStart = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getCpuTime(toMonitorLambda, true));
        this.lastTriggerTimeMillis = this.timeAtStart = System.currentTimeMillis();
        this.usedMillisAtPreviousMinute = this.usedMillisecondsAtStart;
        this.usedMillisAtPreviousInterval = this.usedMillisecondsAtStart;
        this.usedMillisAtPreviousHour = this.usedMillisecondsAtStart;
        this.usedMillisAtPreviousDay = this.usedMillisecondsAtStart;
        if (this.pollMinuteTicket != null) {
            this.pollMinuteTicket.cancel();
        }
        if (this.pollHourTicket != null) {
            this.pollHourTicket.cancel();
        }
        if (this.pollDayTicket != null) {
            this.pollDayTicket.cancel();
        }
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollMinute, null);
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.HOUR, (Action)pollHour, null);
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.DAY, (Action)pollDay, null);
        super.doStarted();
    }

    public void stopped() {
        if (this.pollMinuteTicket != null) {
            this.pollMinuteTicket.cancel();
        }
        if (this.pollHourTicket != null) {
            this.pollHourTicket.cancel();
        }
        if (this.pollDayTicket != null) {
            this.pollDayTicket.cancel();
        }
    }
}

