/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sysmon.BAbstractMemoryMonitor;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumSystemMemoryLimit", type="long", defaultValue="512", facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(0)))")}), @NiagaraProperty(name="freeSystemMemory", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(-1)))")}), @NiagaraProperty(name="rebootIfLow", type="boolean", defaultValue="false", flags=4)})
public final class BSystemMemoryMonitor
extends BAbstractMemoryMonitor {
    public static final Property minimumSystemMemoryLimit = BSystemMemoryMonitor.newProperty((int)0, (int)512, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)0L))));
    public static final Property freeSystemMemory = BSystemMemoryMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L))));
    public static final Property rebootIfLow = BSystemMemoryMonitor.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BSystemMemoryMonitor.class);

    public long getMinimumSystemMemoryLimit() {
        return this.getLong(minimumSystemMemoryLimit);
    }

    public void setMinimumSystemMemoryLimit(long v) {
        this.setLong(minimumSystemMemoryLimit, v, null);
    }

    public long getFreeSystemMemory() {
        return this.getLong(freeSystemMemory);
    }

    public void setFreeSystemMemory(long v) {
        this.setLong(freeSystemMemory, v, null);
    }

    public boolean getRebootIfLow() {
        return this.getBoolean(rebootIfLow);
    }

    public void setRebootIfLow(boolean v) {
        this.setBoolean(rebootIfLow, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "freeSystemMemory";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:systemMemoryToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:systemMemoryToOffnormal)%";
    }

    @Override
    protected long checkMemory() {
        long freeSystemMem = 0L;
        try {
            freeSystemMem = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getFreePhysicalMemoryBytes()) / 1024L;
            this.setFreeSystemMemory(freeSystemMem);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Free system memory: " + freeSystemMem + " KB");
            }
            if (freeSystemMem > 0L && freeSystemMem < this.getMinimumSystemMemoryLimit()) {
                BFormat msg = BFormat.make((String)(this.getToOffnormalText() + ": " + freeSystemMem + " KB"));
                this.getLog().warning(msg.format((Object)this));
                this.raiseAlarm(msg, true);
                if (this.getRebootIfLow()) {
                    this.getLog().warning("Platform System Monitor Service detected low System memory. Attempting reboot!");
                    this.reboot();
                }
            } else {
                this.raiseAlarm(false);
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking system memory", (Throwable)e);
        }
        return freeSystemMem;
    }
}

