/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractMemoryMonitor;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="garbageCollectionOnCheckSystem", type="boolean", defaultValue="true"), @NiagaraProperty(name="minimumHeapMemoryLimit", type="long", defaultValue="512", facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(0)))")}), @NiagaraProperty(name="totalHeapMemory", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(-1)))")}), @NiagaraProperty(name="freeHeapMemory", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(-1)))")}), @NiagaraProperty(name="usedHeapMemory", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(-1)))")}), @NiagaraProperty(name="rebootIfLow", type="boolean", defaultValue="false", flags=4)})
public final class BHeapMemoryMonitor
extends BAbstractMemoryMonitor {
    public static final Property garbageCollectionOnCheckSystem = BHeapMemoryMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property minimumHeapMemoryLimit = BHeapMemoryMonitor.newProperty((int)0, (int)512, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)0L))));
    public static final Property totalHeapMemory = BHeapMemoryMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L))));
    public static final Property freeHeapMemory = BHeapMemoryMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L))));
    public static final Property usedHeapMemory = BHeapMemoryMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L))));
    public static final Property rebootIfLow = BHeapMemoryMonitor.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BHeapMemoryMonitor.class);

    public boolean getGarbageCollectionOnCheckSystem() {
        return this.getBoolean(garbageCollectionOnCheckSystem);
    }

    public void setGarbageCollectionOnCheckSystem(boolean v) {
        this.setBoolean(garbageCollectionOnCheckSystem, v, null);
    }

    public long getMinimumHeapMemoryLimit() {
        return this.getLong(minimumHeapMemoryLimit);
    }

    public void setMinimumHeapMemoryLimit(long v) {
        this.setLong(minimumHeapMemoryLimit, v, null);
    }

    public long getTotalHeapMemory() {
        return this.getLong(totalHeapMemory);
    }

    public void setTotalHeapMemory(long v) {
        this.setLong(totalHeapMemory, v, null);
    }

    public long getFreeHeapMemory() {
        return this.getLong(freeHeapMemory);
    }

    public void setFreeHeapMemory(long v) {
        this.setLong(freeHeapMemory, v, null);
    }

    public long getUsedHeapMemory() {
        return this.getLong(usedHeapMemory);
    }

    public void setUsedHeapMemory(long v) {
        this.setLong(usedHeapMemory, v, null);
    }

    public boolean getRebootIfLow() {
        return this.getBoolean(rebootIfLow);
    }

    public void setRebootIfLow(boolean v) {
        this.setBoolean(rebootIfLow, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "usedHeapMemory";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:heapMemoryToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:heapMemoryToOffnormal)%";
    }

    @Override
    protected long checkMemory() {
        long mem = 0L;
        try {
            if (this.getGarbageCollectionOnCheckSystem()) {
                System.gc();
            }
            int totalHeapMemKb = (int)(Runtime.getRuntime().totalMemory() / 1024L);
            int freeHeapMemKb = (int)(Runtime.getRuntime().freeMemory() / 1024L);
            int usedHeapMemKb = totalHeapMemKb - freeHeapMemKb;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Total heap memory: " + totalHeapMemKb);
                this.getLog().trace("Free heap memory: " + freeHeapMemKb);
                this.getLog().trace("Used heap memory: " + usedHeapMemKb);
            }
            this.setTotalHeapMemory(totalHeapMemKb);
            this.setFreeHeapMemory(freeHeapMemKb);
            this.setUsedHeapMemory(usedHeapMemKb);
            if ((long)freeHeapMemKb <= this.getMinimumHeapMemoryLimit()) {
                BFormat msg = BFormat.make((String)(this.getToOffnormalText() + ": " + usedHeapMemKb + " KB"));
                this.getLog().warning(msg.format((Object)this));
                this.raiseAlarm(msg, true);
                if (this.getRebootIfLow()) {
                    this.getLog().warning("Platform System Monitor Service detected low heap memory. Attempting reboot!");
                    this.reboot();
                }
            } else {
                this.raiseAlarm(false);
            }
            mem = usedHeapMemKb;
        }
        catch (Exception e) {
            this.getLog().error("Checking memory", (Throwable)e);
        }
        return mem;
    }
}

