/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query;

import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BGrouping;
import javax.baja.query.BHaving;
import javax.baja.query.BOrdering;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQueryNode;
import javax.baja.query.util.Columns;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BQuery
extends BQueryNode {
    public static final Type TYPE = Sys.loadType(BQuery.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BQuery reset() {
        if (this.hasProjection()) {
            this.remove((BComplex)this.getProjection());
        }
        if (this.hasPredicate()) {
            this.remove((BComplex)this.getPredicate());
        }
        if (this.hasGrouping()) {
            this.remove((BComplex)this.getGrouping());
        }
        if (this.hasHaving()) {
            this.remove((BComplex)this.getHaving());
        }
        if (this.hasOrdering()) {
            this.remove((BComplex)this.getOrdering());
        }
        if (this.hasExtent()) {
            this.remove((BComplex)this.getExtent());
        }
        return this;
    }

    public BQuery select(BProjection projection) {
        if (this.hasProjection()) {
            this.remove((BComplex)this.getProjection());
        }
        this.add("projection", (BValue)projection);
        return this;
    }

    public BQuery select(BProjectionColumn column) {
        if (this.hasProjection()) {
            this.getProjection().add(column);
        } else {
            this.select(Columns.projection(column));
        }
        return this;
    }

    public BQuery select(BExpression columnExpr) {
        return this.select(Columns.make(columnExpr));
    }

    public boolean hasProjection() {
        return this.getProjection() != null;
    }

    public BProjection getProjection() {
        BProjection[] p = (BProjection[])this.getChildren(BProjection.class);
        return p.length == 0 ? null : p[0];
    }

    public BQuery from(BExtent extent) {
        if (this.hasExtent()) {
            this.remove((BComplex)this.getExtent());
        }
        this.add("extent", (BValue)extent);
        return this;
    }

    public boolean hasExtent() {
        return this.getExtent() != null;
    }

    public BExtent getExtent() {
        BExtent[] e = (BExtent[])this.getChildren(BExtent.class);
        return e.length == 0 ? null : e[0];
    }

    public BQuery where(BPredicate predicate) {
        BPredicate p = this.getPredicate();
        if (p != null) {
            this.remove((BComplex)p);
        }
        this.add("predicate", (BValue)predicate);
        return this;
    }

    public final BQuery where(BExpression predicateExpr) {
        return this.where(new BPredicate(predicateExpr));
    }

    public final BQuery where(ExpressionBuilder builder) {
        return this.where(builder.getExpression());
    }

    public boolean hasPredicate() {
        BPredicate p = this.getPredicate();
        return p != null && p.getPredicateExpr() != null;
    }

    public BPredicate getPredicate() {
        BPredicate[] p = (BPredicate[])this.getChildren(BPredicate.class);
        return p.length == 0 ? null : p[0];
    }

    public BQuery groupBy(BGrouping grouping) {
        if (this.hasGrouping()) {
            this.remove((BComplex)this.getGrouping());
        }
        this.add("grouping", (BValue)grouping);
        return this;
    }

    public boolean hasGrouping() {
        return this.getGrouping() != null;
    }

    public BGrouping getGrouping() {
        BGrouping[] g = (BGrouping[])this.getChildren(BGrouping.class);
        return g.length == 0 ? null : g[0];
    }

    public BQuery having(BHaving having) {
        if (this.hasHaving()) {
            this.remove((BComplex)this.getHaving());
        }
        this.add("having", (BValue)having);
        return this;
    }

    public final BQuery having(BExpression havingExpr) {
        return this.having(new BHaving(havingExpr));
    }

    public final BQuery having(ExpressionBuilder builder) {
        return this.having(builder.getExpression());
    }

    public boolean hasHaving() {
        BHaving h = this.getHaving();
        return h != null && h.getHavingExpr() != null;
    }

    public BHaving getHaving() {
        BHaving[] h = (BHaving[])this.getChildren(BHaving.class);
        return h.length == 0 ? null : h[0];
    }

    public BQuery orderBy(BOrdering ordering) {
        if (this.hasOrdering()) {
            this.remove((BComplex)this.getOrdering());
        }
        this.add("ordering", (BValue)ordering);
        return this;
    }

    public boolean hasOrdering() {
        return this.getOrdering() != null;
    }

    public BOrdering getOrdering() {
        BOrdering[] o = (BOrdering[])this.getChildren(BOrdering.class);
        return o.length == 0 ? null : o[0];
    }
}

