/*
 * Decompiled with CFR 0.152.
 */
package com.isma.modbusCore.client.point;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusStringProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModbusClientStringWritableProxyExt
extends BModbusClientProxyExt
implements BIModbusStringProxyExt {
    public static final Property numberRegisters = BModbusClientStringWritableProxyExt.newProperty((int)0, (int)1, null);
    public static final Type TYPE = Sys.loadType(BModbusClientStringWritableProxyExt.class);

    public int getNumberRegisters() {
        return this.getInt(numberRegisters);
    }

    public void setNumberRegisters(int v) {
        this.setInt(numberRegisters, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        int devAddress = device.getDeviceAddress();
        int regAddress = this.getAbsoluteAddress().getDataAddress();
        int regsNo = this.getNumberRegisters();
        int functionNo = 3;
        ModbusReadRequest request = new ModbusReadRequest(((BModbusClientNetwork)device.modbusNet()).getModbusMode(), (BModbusDevice)device, devAddress, functionNo, regAddress, regsNo);
        ModbusResponse response = (ModbusResponse)device.sendModbusMessage((Message)request);
        if (request == null) {
            response = new ModbusResponse(((BModbusClientNetwork)device.modbusNet()).getModbusMode(), (BModbusDevice)device);
            response.exceptionCode = 9;
        }
        this.setOutValues(response);
    }

    public void setOutValues(ModbusResponse response) {
        if (!response.isError()) {
            this.setStringOutValues(response);
        } else {
            this.readFail(response.getExceptionString());
        }
    }

    private final void setStringOutValues(ModbusResponse response) {
        String str;
        try {
            str = response.getString(this.getNumberRegisters());
        }
        catch (IllegalArgumentException ex) {
            this.readFail("error parsing String value (" + ex + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusString(str));
    }

    public BRegisterTypesEnum determineRegisterType() {
        return BRegisterTypesEnum.holdingRegister;
    }

    public BEnum getRegisterType() {
        return BRegisterTypeEnum.holding;
    }

    public int determineNumRegisters() {
        return this.getNumberRegisters();
    }

    public boolean isValidAddress(BFlexAddress flexAddress) {
        if (flexAddress.isModbusFormat() && flexAddress.isModbusAnalogAddress()) {
            return flexAddress.isModbusHoldingAddress();
        }
        return flexAddress.isValid();
    }

    public void devicePoll(BDevicePollConfigEntry bDevicePollConfigEntry) {
        block3: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
            int regNo = this.getNumberRegisters();
            ModbusResponse response = new ModbusResponse(((BModbusClientNetwork)device.modbusNet()).getModbusMode(), (BModbusDevice)device);
            int addr = this.getAbsoluteAddress().getDataAddress();
            try {
                response.data = device.getHoldingRegisterValues(addr, regNo, bDevicePollConfigEntry);
                response.exceptionCode = device.getHoldingRegistersReadStatus(addr, regNo, bDevicePollConfigEntry).getErrorCode();
                response.byteCount = (byte)response.data.length;
                response.numberPoints = regNo;
                this.setOutValues(response);
            }
            catch (ModbusException ex) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block3;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)ex);
            }
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            super.changed(prop, cx);
            return;
        }
        if (prop.equals(numberRegisters)) {
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
        } else {
            super.changed(prop, cx);
        }
    }

    public void doWrite(BStatusValue status) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (status == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(status);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModussClient String point is not writable, disregarding write request.");
        }
        super.doWrite(status);
    }

    public boolean updateOutput(BStatusValue statusValue) {
        String newString = ((BStatusString)statusValue).getValue();
        System.out.println("Nowy string: " + newString);
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork network = (BModbusClientNetwork)this.modbusNet();
        int devAddr = device.getDeviceAddress();
        int regAddr = this.getAbsoluteAddress().getDataAddress();
        int regsNo = this.getNumberRegisters();
        int cmd = 16;
        byte[] stringArray = newString.getBytes();
        byte[] arrayOfByte = new byte[regsNo * 2];
        System.arraycopy(stringArray, 0, arrayOfByte, 0, Math.min(stringArray.length, arrayOfByte.length));
        ModbusWriteRequest request = new ModbusWriteRequest(network.getModbusMode(), (BModbusDevice)device, devAddr, cmd, regAddr, regsNo, arrayOfByte);
        ModbusResponse response = (ModbusResponse)device.sendModbusMessage((Message)request);
        if (response == null) {
            response = new ModbusResponse(network.getModbusMode(), (BModbusDevice)device);
            response.exceptionCode = 9;
        }
        if (response.isError() && response.exceptionCode != 5) {
            this.writeFail(response.getExceptionString());
            return false;
        }
        this.writeOk(statusValue);
        return true;
    }
}

