/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart.binding;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BColumnIdentifier
extends BSimple {
    private static final int NULL_TYPE = 1;
    private static final int ROW_INDEX_TYPE = 2;
    private static final int TABLE_COLUMN_TYPE = 3;
    private static final BColumnIdentifier ROW_INDEX_ID = new BColumnIdentifier(2, "");
    public static final BColumnIdentifier NULL;
    public static final BColumnIdentifier DEFAULT;
    public static final Type TYPE;
    private int type = 2;
    private String columnName;

    private BColumnIdentifier(int type, String columnName) {
        if (type == 3 && columnName == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.columnName = columnName;
    }

    public static BColumnIdentifier makeRowIndexColumn() {
        return ROW_INDEX_ID;
    }

    public static BColumnIdentifier makeTableColumn(String tableColumnName) {
        return new BColumnIdentifier(3, tableColumnName);
    }

    public boolean isRowIndex() {
        return this.type == 2;
    }

    public boolean isTableColumn() {
        return this.type == 3;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNull() {
        return this.type == 1;
    }

    public int hashCode() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o instanceof BColumnIdentifier) {
            BColumnIdentifier id = (BColumnIdentifier)((Object)o);
            if (this.type != id.type) {
                return false;
            }
            if (this.type == 2) {
                return id.type == 2;
            }
            if (this.type == 3) {
                return this.columnName.equals(id.columnName);
            }
            return false;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.type);
        if (this.type == 3) {
            out.writeUTF(this.columnName);
        }
    }

    public BObject decode(DataInput in) throws IOException {
        int type = in.readInt();
        String colName = null;
        if (type == 3) {
            colName = in.readUTF();
        }
        if (type == 2) {
            return ROW_INDEX_ID;
        }
        if (type == 3) {
            return BColumnIdentifier.makeTableColumn(colName);
        }
        throw new IllegalArgumentException("Invalid column identifier type: " + type);
    }

    public String encodeToString() throws IOException {
        if (this.type == 1) {
            return "null";
        }
        if (this.type == 2) {
            return "rowIndex";
        }
        if (this.type == 3) {
            return "tableColumn:" + this.columnName;
        }
        return this.type + ":" + this.columnName;
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("null")) {
            return NULL;
        }
        if (s.equals("rowIndex")) {
            return ROW_INDEX_ID;
        }
        int colon = s.indexOf(58);
        String typeString = s.substring(0, colon);
        if (typeString.equals("tableColumn")) {
            return BColumnIdentifier.makeTableColumn(s.substring(colon + 1));
        }
        throw new IllegalArgumentException("Invalid column identifier type: " + typeString);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BColumnIdentifier(1, "");
        TYPE = Sys.loadType(BColumnIdentifier.class);
    }
}

