/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart.binding;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public final class BAxisBound
extends BSimple {
    public static final BAxisBound AUTO;
    public static final BAxisBound DEFAULT;
    public static final Type TYPE;
    private static Lexicon lex;
    private boolean auto;
    private BSimple value;

    private BAxisBound() {
    }

    private BAxisBound(boolean auto, BSimple value) {
        this.auto = auto;
        if (!auto) {
            this.value = value;
        }
    }

    public static BAxisBound makeAuto() {
        return AUTO;
    }

    public static BAxisBound make(BSimple value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        BAxisBound result = new BAxisBound();
        result.auto = false;
        result.value = value;
        return result;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public BSimple getValue() {
        if (this.auto) {
            return null;
        }
        return this.value;
    }

    public int hashCode() {
        if (this.auto || this.value == null) {
            return 0;
        }
        return this.value.hashCode() + 1;
    }

    public boolean equals(Object o) {
        if (o instanceof BAxisBound) {
            BAxisBound other = (BAxisBound)((Object)o);
            if (this.auto) {
                return other.auto;
            }
            return this.value.equals((Object)other.value);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeBoolean(this.auto);
        if (!this.auto) {
            this.value.getType().getTypeSpec().encode(out);
            this.value.encode(out);
        }
    }

    public BObject decode(DataInput in) throws IOException {
        boolean auto = in.readBoolean();
        if (auto) {
            return BAxisBound.makeAuto();
        }
        BTypeSpec type = (BTypeSpec)BTypeSpec.DEFAULT.decode(in);
        BSimple value = (BSimple)((BSimple)type.getInstance()).decode(in);
        return BAxisBound.make(value);
    }

    public String encodeToString() throws IOException {
        if (this.auto) {
            return "auto";
        }
        return "fixed," + this.value.getType().getTypeSpec().encodeToString() + "," + this.value.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        boolean auto = s.equals("auto");
        if (auto) {
            return BAxisBound.makeAuto();
        }
        int comma = s.indexOf(44);
        s = s.substring(comma + 1);
        comma = s.indexOf(44);
        BTypeSpec type = BTypeSpec.make((String)s.substring(0, comma));
        BSimple value = (BSimple)((BSimple)type.getInstance()).decodeFromString(s.substring(comma + 1));
        return BAxisBound.make(value);
    }

    public String toString(Context cx) {
        if (this.auto) {
            return lex.getText("auto");
        }
        return this.value.toString(cx);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = AUTO = new BAxisBound(true, null);
        TYPE = Sys.loadType(BAxisBound.class);
        lex = Lexicon.make((String)"chart");
    }
}

