/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.driverUpgrade.wizard.UpgradeTaskDetailPane;
import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platcrypto.daemon.wb.BDaemonSecureSession;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;

public class BConnectStep
extends BUpgradeWizardStep {
    public static final Type TYPE = Sys.loadType(BConnectStep.class);
    protected int mode = 1;
    protected ConnectTasks connectTasks;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BConnectStep() {
        super(null);
    }

    public BConnectStep(UpgradeWizardModel wizardModel) {
        super(wizardModel);
    }

    @Override
    public String getSectionName() {
        return "connect";
    }

    @Override
    public String getStepName() {
        return "connect";
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void enter() {
        this.connectTasks = new ConnectTasks();
        this.setContent(this.connectTasks.getPane());
        new Thread(this.connectTasks).start();
    }

    @Override
    public boolean exit(int direction) {
        return !this.connectTasks.isRunning();
    }

    @Override
    public boolean cancel() {
        if (this.connectTasks.isRunning()) {
            this.connectTasks.cancel();
            return false;
        }
        return true;
    }

    @Override
    public void checkMode() {
        this.mode = this.connectTasks.isRunning() ? 0 : (this.getWizardModel().platform != null ? 3 : 1);
        this.getWizardModel().update(this.mode);
    }

    protected class ConnectTasks
    extends UpgradeTaskDetailPane
    implements DaemonSessionTaskListener {
        protected String lastText;
        protected boolean isRunning = false;
        protected UpgradeTaskDetailPane.TaskItem stationConnectTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.stationConnect"));
        protected UpgradeTaskDetailPane.TaskItem platformConnectTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.platformConnect"));

        public ConnectTasks() {
            this.init();
        }

        @Override
        public void run() {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            try {
                if (!this.verifyStation()) {
                    return;
                }
                if (!this.verifyPlatform()) {
                    return;
                }
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.successFooter")));
            }
            catch (ICancelHint.CanceledException ce) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.canceled") + '\n');
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.canceled")));
                this.updateCurrentItemState(BJobState.canceled);
            }
            catch (Throwable t) {
                this.updateCurrentItemState(BJobState.failed);
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.failed")));
                t.printStackTrace();
                this.getLog().append(t);
                this.getLog().append("\n");
            }
            finally {
                this.isRunning = false;
                BConnectStep.this.checkMode();
            }
        }

        private boolean verifyStation() throws Exception {
            this.setCurrentItem(this.stationConnectTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.connectingStation") + '\n');
            BFoxSession foxSession = BConnectStep.this.getWizardModel().foxSession();
            try {
                foxSession.engageNoRetry("UpgradeWizard.connect");
                foxSession.disengage("UpgradeWizard.connect");
                this.checkCanceled();
                this.updateCurrentItemState(BJobState.success);
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.connectSuccess") + '\n');
                return true;
            }
            catch (AuthenticationException ae) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.authFail") + '\n');
                this.updateCurrentItemState(BJobState.failed);
            }
            catch (FoxAuthenticationException fae) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.authFail") + '\n');
                this.updateCurrentItemState(BJobState.failed);
            }
            catch (ConnectException ce) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.connectFail") + '\n');
                this.updateCurrentItemState(BJobState.failed);
            }
            return false;
        }

        private boolean verifyPlatform() throws Exception {
            this.setCurrentItem(this.platformConnectTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.connecting") + '\n');
            BDaemonSession session = BConnectStep.this.getWizardModel().platformCnxHandler.isSecure() ? BDaemonSecureSession.make((BHost)BConnectStep.this.getWizardModel().host, (int)BConnectStep.this.getWizardModel().platformCnxHandler.getPort()) : BDaemonSession.make((BHost)BConnectStep.this.getWizardModel().host, (int)BConnectStep.this.getWizardModel().platformCnxHandler.getPort());
            session.setCredentials(BConnectStep.this.getWizardModel().platformCredentials, true);
            try {
                session.connect();
                this.checkCanceled();
                BConnectStep.this.getWizardModel().stationDirs = this.getStationsDirs(session);
                BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)session, (DaemonSessionTaskListener)this);
                BConnectStep.this.getWizardModel().platform = platform;
                if (BConnectStep.this.getWizardModel().stationDirs.length > 1) {
                    boolean found = false;
                    BAppSurrogate[] apps = BAppSurrogate.makeAll((Type)BStationSurrogate.TYPE, (BDaemonSession)session);
                    for (int i = 0; i < apps.length; ++i) {
                        if (apps[i].getAppStatus() != BStationStatus.running) continue;
                        BConnectStep.this.getWizardModel().selectedStation = i;
                        found = true;
                        this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.ident") + " " + apps[i].getAppName() + '\n');
                        break;
                    }
                    if (!found) {
                        this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.norunning") + '\n');
                        this.updateCurrentItemState(BJobState.failed);
                        return false;
                    }
                }
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.connectSuccess") + '\n');
                this.updateCurrentItemState(BJobState.success);
                BConnectStep.this.getWizardModel().daemonSession = session;
                return true;
            }
            catch (AuthenticationException platform) {
            }
            catch (ConnectException ce) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.connectFail") + '\n');
                this.updateCurrentItemState(BJobState.failed);
            }
            return false;
        }

        private BDirectory[] getStationsDirs(BDaemonSession session) {
            Array list = new Array(BDirectory.class);
            BDirectory remoteDir = (BDirectory)session.getFileSpace().findFile(new FilePath("~stations"), BCacheAccessPolicy.forceFetch);
            BIFile[] kids = remoteDir.listFiles();
            for (int i = 0; i < kids.length; ++i) {
                if (!kids[i].isDirectory()) continue;
                list.add((Object)((BDirectory)kids[i]));
            }
            return (BDirectory[])list.trim();
        }

        @Override
        public void updateCurrentItemState(BJobState state) {
            super.updateCurrentItemState(state);
            switch (state.getOrdinal()) {
                case 5: {
                    this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.failedFooter")));
                }
                case 3: {
                    BConnectStep.this.getWizardModel().solution = null;
                    BConnectStep.this.getWizardModel().platform = null;
                }
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.lastText = null;
            this.isRunning = false;
        }

        @Override
        public String getItemListHeading() {
            return BUpgradeWizardStep.LEX.getText("UpgradeWizard.connect.heading");
        }

        @Override
        public UpgradeTaskDetailPane.TaskItem[] makeTaskItems() {
            return new UpgradeTaskDetailPane.TaskItem[]{this.stationConnectTask, this.platformConnectTask};
        }

        public void taskStarted(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
            if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
                this.setCancelEnabled(false);
            }
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        @Override
        public void cancel() {
            super.cancel();
            BConnectStep.this.checkMode();
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }
}

