/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import java.io.IOException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;

public final class VirtualSlotNameParser {
    private String virtualPathName;
    private String slotName = "";
    private boolean frozen = false;
    private boolean isComponent = false;
    private String typeSpec = "";
    private int flags = 0;
    private BFacets facets = BFacets.NULL;
    private boolean isAction = false;
    private String returnTypeSpec = "";

    private VirtualSlotNameParser() {
    }

    public static VirtualSlotNameParser make(String virtualPathName) {
        VirtualSlotNameParser p = new VirtualSlotNameParser();
        p.virtualPathName = virtualPathName;
        return p;
    }

    public VirtualSlotNameParser parse() throws Exception {
        String[] strs = TextUtil.splitAndTrim((String)this.virtualPathName, (char)';');
        if (strs.length <= 1) {
            throw new Exception("Invalid virtual slot name: " + this.virtualPathName);
        }
        for (int i = 0; i < strs.length; ++i) {
            if (i == 0) {
                this.slotName = VirtualSlotNameParser.unescape(strs[i]);
                continue;
            }
            if (i == 1) {
                if (strs[i].equals(String.valueOf('f'))) {
                    this.frozen = true;
                    continue;
                }
                if (strs[i].equals(String.valueOf('d'))) {
                    this.frozen = false;
                    continue;
                }
                throw new Exception("Could not decode whether Slot is virtually frozen");
            }
            if (i == 2) {
                if (strs[i].equals("a")) {
                    this.isAction = true;
                    this.isComponent = false;
                    continue;
                }
                if (strs[i].equals("c")) {
                    this.isAction = false;
                    this.isComponent = true;
                    continue;
                }
                if (strs[i].equals("p")) {
                    this.isAction = false;
                    this.isComponent = false;
                    continue;
                }
                throw new Exception("Could not decode virtual type: " + strs[i]);
            }
            if (i == 3) {
                this.typeSpec = VirtualSlotNameParser.unescape(strs[i]);
                if (!this.isComponent) continue;
                break;
            }
            if (i == 4) {
                try {
                    this.flags = Integer.parseInt(strs[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Could not decode virtual config flags: " + strs[i]);
                }
            }
            if (i == 5) {
                try {
                    this.facets = (BFacets)BFacets.DEFAULT.decodeFromString(VirtualSlotNameParser.unescape(strs[i]));
                    continue;
                }
                catch (IOException e) {
                    throw new Exception("Could not decode virtual facets: " + this.facets);
                }
            }
            if (i != 5 || !this.isAction) continue;
            this.returnTypeSpec = VirtualSlotNameParser.unescape(strs[i]);
        }
        return this;
    }

    public VirtualSlotNameParser parsePartial() throws Exception {
        char[] chars = this.virtualPathName.toCharArray();
        boolean nextDone = false;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (nextDone) {
                if (chars[i] == 'f') {
                    this.frozen = true;
                    break;
                }
                if (chars[i] == 'd') {
                    this.frozen = false;
                    break;
                }
                throw new Exception("Could not decode whether Slot is virtually frozen");
            }
            if (chars[i] == ';') {
                nextDone = true;
                continue;
            }
            buff.append(chars[i]);
        }
        if (!nextDone) {
            throw new Exception("Could not parse Slot name");
        }
        this.slotName = VirtualSlotNameParser.unescape(buff.toString());
        return this;
    }

    public static String escape(String s) {
        if (s.length() == 0) {
            return "";
        }
        s = SlotPath.escape((String)s);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '$') continue;
            chars[i] = 37;
        }
        return new String(chars);
    }

    public static String unescape(String s) {
        if (s.length() == 0) {
            return "";
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '%') continue;
            chars[i] = 36;
        }
        return SlotPath.unescape((String)new String(chars));
    }

    public String getSlotName() {
        return this.slotName;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isComponent() {
        return this.isComponent;
    }

    public String getTypeSpec() {
        return this.typeSpec;
    }

    public int getFlags() {
        return this.flags;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public boolean isAction() {
        return this.isAction;
    }

    public String getReturnTypeSpec() {
        return this.returnTypeSpec;
    }
}

