/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.VirtualSlotNameParser;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

@Deprecated
public final class VirtualSlotNameBuilder {
    private String slotName = "";
    private boolean frozen = false;
    private boolean isComponent = false;
    private String typeSpec = "";
    private BFacets facets = BFacets.NULL;
    private int flags = 0;
    private boolean isAction = false;
    private String returnTypeSpec = "";

    private VirtualSlotNameBuilder() {
    }

    public static VirtualSlotNameBuilder make() {
        return new VirtualSlotNameBuilder();
    }

    public static VirtualSlotNameBuilder make(BComplex comp, String slotName) throws Exception {
        return VirtualSlotNameBuilder.make(comp, slotName, true);
    }

    public static VirtualSlotNameBuilder make(BComplex comp, String slotName, boolean supportsWritable) throws Exception {
        Slot slot = comp.getSlot(slotName);
        if (slot == null) {
            throw new Exception("Slot doesn't exist!");
        }
        if (slot.isTopic()) {
            throw new Exception("Topics not supported by Niagara Virtuals");
        }
        VirtualSlotNameBuilder builder = VirtualSlotNameBuilder.make();
        builder.setSlotName(slotName);
        builder.setFrozen(slot.isFrozen());
        if (slot.isAction()) {
            Type retType;
            builder.setIsAction(true);
            Action action = slot.asAction();
            Type argType = action.getParameterType();
            if (argType != null) {
                builder.setTypeSpec(argType.toString());
            }
            if ((retType = action.getReturnType()) != null) {
                builder.setReturnTypeSpec(retType.toString());
            }
        } else if (slot.isProperty()) {
            BValue val = comp.get(slot.asProperty());
            builder.setTypeSpec(val.getType().toString());
            if (val instanceof BComponent) {
                builder.setIsComponent(true);
            }
        }
        if (!builder.isComponent) {
            builder.setFlags(comp.getFlags(slot));
            BFacets facets = comp.getSlotFacets(slot);
            facets = BFacets.make((BFacets)facets, (String)"nVirtualW", (BIDataValue)BBoolean.make((boolean)supportsWritable));
            builder.setFacets(facets);
        }
        return builder;
    }

    public static BOrd buildVirtualSlotPath(OrdTarget target) throws Exception {
        BComponent comp = target.getComponent();
        SlotPath path = comp.getSlotPath();
        if (path == null) {
            throw new Exception("No valid Slot Path available!");
        }
        comp = (BComponent)BOrd.make((String)"station:|slot:/").get((BObject)comp);
        StringBuffer buff = new StringBuffer();
        buff.append("virtual:");
        String[] names = path.getNames();
        for (int i = 0; i < names.length; ++i) {
            buff.append("/");
            buff.append(SlotPath.unescape((String)VirtualSlotNameBuilder.make((BComplex)comp, names[i]).buildName()));
            comp = (BComponent)comp.get(names[i]);
        }
        Slot slot = target.getSlotInComponent();
        if (slot != null && slot.isAction()) {
            buff.append("/");
            buff.append(SlotPath.unescape((String)VirtualSlotNameBuilder.make((BComplex)comp, slot.getName()).buildName()));
        } else {
            Property[] props = target.getPropertyPathInComponent();
            if (props != null) {
                BComponent clx = comp;
                boolean lastStruct = false;
                for (int i = 0; i < props.length; ++i) {
                    BValue val = clx.get(props[i]);
                    buff.append("/");
                    if (lastStruct) {
                        buff.append(props[i].getName());
                    } else {
                        buff.append(SlotPath.unescape((String)VirtualSlotNameBuilder.make((BComplex)clx, props[i].getName()).buildName()));
                    }
                    if (!val.isComplex()) continue;
                    clx = (BComplex)val;
                    if (lastStruct || !val.isStruct()) continue;
                    lastStruct = true;
                }
            }
        }
        return BOrd.make((String)buff.toString());
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setIsComponent(boolean isComponent) {
        this.isComponent = isComponent;
    }

    public void setTypeSpec(String typeSpec) {
        this.typeSpec = typeSpec;
    }

    public void setFacets(BFacets facets) {
        this.facets = facets;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setIsAction(boolean isAction) {
        this.isAction = isAction;
    }

    public void setReturnTypeSpec(String returnTypeSpec) {
        this.returnTypeSpec = returnTypeSpec;
    }

    public String buildName() throws Exception {
        StringBuffer nameBuff = new StringBuffer();
        nameBuff.append(VirtualSlotNameParser.escape(this.slotName));
        nameBuff.append(';');
        nameBuff.append(this.frozen ? (char)'f' : 'd');
        if (this.isComponent) {
            nameBuff.append(';');
            nameBuff.append('c');
            nameBuff.append(';');
            nameBuff.append(VirtualSlotNameParser.escape(this.typeSpec));
        } else {
            nameBuff.append(';');
            nameBuff.append(this.isAction ? (char)'a' : 'p');
            nameBuff.append(';');
            nameBuff.append(VirtualSlotNameParser.escape(this.typeSpec));
            nameBuff.append(';');
            nameBuff.append(this.flags);
            nameBuff.append(';');
            nameBuff.append(VirtualSlotNameParser.escape(this.facets.encodeToString()));
            if (this.isAction) {
                nameBuff.append(';');
                nameBuff.append(VirtualSlotNameParser.escape(this.returnTypeSpec));
            }
        }
        return SlotPath.escape((String)nameBuff.toString());
    }
}

